/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.service.impl;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.price.list.exception.CommerceBasePriceListCannotDeleteException;
import com.liferay.commerce.price.list.exception.CommercePriceListCurrencyException;
import com.liferay.commerce.price.list.exception.CommercePriceListDisplayDateException;
import com.liferay.commerce.price.list.exception.CommercePriceListExpirationDateException;
import com.liferay.commerce.price.list.exception.CommercePriceListParentPriceListGroupIdException;
import com.liferay.commerce.price.list.exception.DuplicateCommerceBasePriceListException;
import com.liferay.commerce.price.list.exception.DuplicateCommercePriceListException;
import com.liferay.commerce.price.list.exception.NoSuchPriceListException;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceEntryTable;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListAccountRelTable;
import com.liferay.commerce.price.list.model.CommercePriceListChannelRelTable;
import com.liferay.commerce.price.list.model.CommercePriceListCommerceAccountGroupRelTable;
import com.liferay.commerce.price.list.model.CommercePriceListOrderTypeRelTable;
import com.liferay.commerce.price.list.model.CommercePriceListTable;
import com.liferay.commerce.price.list.service.base.CommercePriceListLocalServiceBaseImpl;
import com.liferay.commerce.pricing.exception.CommerceUndefinedBasePriceListException;
import com.liferay.commerce.pricing.service.CommercePriceModifierLocalService;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.LongStream;

public class CommercePriceListLocalServiceImpl
extends CommercePriceListLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "groupId", "uid"};
    private static final Log _log = LogFactoryUtil.getLog(CommercePriceListLocalServiceImpl.class);
    @ServiceReference(type=CommerceCurrencyLocalService.class)
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @ServiceReference(type=CommercePriceModifierLocalService.class)
    private CommercePriceModifierLocalService _commercePriceModifierLocalService;
    @ServiceReference(type=CompanyLocalService.class)
    private CompanyLocalService _companyLocalService;
    @ServiceReference(type=ExpandoRowLocalService.class)
    private ExpandoRowLocalService _expandoRowLocalService;
    @ServiceReference(type=MultiVMPool.class)
    private MultiVMPool _multiVMPool;
    @ServiceReference(type=WorkflowInstanceLinkLocalService.class)
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    public CommercePriceList addCatalogBaseCommercePriceList(long groupId, long userId, long commerceCurrencyId, String type, String name, ServiceContext serviceContext) throws PortalException {
        Date date = new Date();
        Calendar calendar = CalendarFactoryUtil.getCalendar((long)date.getTime());
        int displayDateHour = calendar.get(10);
        if (calendar.get(9) == 1) {
            displayDateHour += 12;
        }
        return this.commercePriceListLocalService.addCommercePriceList(null, groupId, userId, commerceCurrencyId, true, type, 0L, true, name, 0.0, calendar.get(2), calendar.get(5), calendar.get(1), displayDateHour, calendar.get(12), 0, 0, 0, 0, 0, true, serviceContext);
    }

    @Deprecated
    public CommercePriceList addCommerceCatalogBasePriceList(long groupId, long userId, long commerceCurrencyId, String type, String name, ServiceContext serviceContext) throws PortalException {
        return this.commercePriceListLocalService.addCatalogBaseCommercePriceList(groupId, userId, commerceCurrencyId, type, name, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceList addCommercePriceList(String externalReferenceCode, long groupId, long userId, long commerceCurrencyId, boolean netPrice, String type, long parentCommercePriceListId, boolean catalogBasePriceList, String name, double priority, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        this.validate(groupId, commerceCurrencyId, parentCommercePriceListId, catalogBasePriceList, 0L, type);
        this.validateExternalReferenceCode(externalReferenceCode, serviceContext.getCompanyId());
        Date expirationDate = null;
        Date date = new Date();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), CommercePriceListDisplayDateException.class);
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), CommercePriceListExpirationDateException.class);
        }
        long commercePriceListId = this.counterLocalService.increment();
        CommercePriceList commercePriceList = this.commercePriceListPersistence.create(commercePriceListId);
        commercePriceList.setExternalReferenceCode(externalReferenceCode);
        commercePriceList.setGroupId(groupId);
        commercePriceList.setCompanyId(user.getCompanyId());
        commercePriceList.setUserId(user.getUserId());
        commercePriceList.setUserName(user.getFullName());
        commercePriceList.setCommerceCurrencyId(commerceCurrencyId);
        commercePriceList.setParentCommercePriceListId(parentCommercePriceListId);
        commercePriceList.setCatalogBasePriceList(catalogBasePriceList);
        commercePriceList.setNetPrice(netPrice);
        commercePriceList.setType(type);
        commercePriceList.setName(name);
        commercePriceList.setPriority(priority);
        commercePriceList.setDisplayDate(displayDate);
        commercePriceList.setExpirationDate(expirationDate);
        if (expirationDate == null || expirationDate.after(date)) {
            commercePriceList.setStatus(2);
        } else {
            commercePriceList.setStatus(3);
        }
        if (catalogBasePriceList) {
            commercePriceList.setStatus(0);
        }
        commercePriceList.setStatusByUserId(user.getUserId());
        commercePriceList.setStatusDate(serviceContext.getModifiedDate(date));
        commercePriceList.setExpandoBridgeAttributes(serviceContext);
        commercePriceList = (CommercePriceList)this.commercePriceListPersistence.update((BaseModel)commercePriceList);
        commercePriceList = this.startWorkflowInstance(user.getUserId(), commercePriceList, serviceContext);
        this.cleanPriceListCache(user.getCompanyId());
        this.resourceLocalService.addModelResources((AuditedModel)commercePriceList, serviceContext);
        return commercePriceList;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceList addOrUpdateCommercePriceList(String externalReferenceCode, long groupId, long userId, long commercePriceListId, long commerceCurrencyId, boolean netPrice, String type, long parentCommercePriceListId, boolean catalogBasePriceList, String name, double priority, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        CommercePriceList commercePriceList;
        block5: {
            if (commercePriceListId > 0L) {
                try {
                    return this.updateCommercePriceList(commercePriceListId, commerceCurrencyId, netPrice, type, parentCommercePriceListId, catalogBasePriceList, name, priority, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
                }
                catch (NoSuchPriceListException noSuchPriceListException) {
                    if (!_log.isDebugEnabled()) break block5;
                    _log.debug((Object)("Unable to find price list with ID: " + commercePriceListId), (Throwable)noSuchPriceListException);
                }
            }
        }
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        if (Validator.isNotNull((String)externalReferenceCode) && (commercePriceList = this.commercePriceListPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode)) != null) {
            return this.commercePriceListLocalService.updateCommercePriceList(commercePriceList.getCommercePriceListId(), commerceCurrencyId, netPrice, type, parentCommercePriceListId, catalogBasePriceList, name, priority, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
        }
        return this.commercePriceListLocalService.addCommercePriceList(externalReferenceCode, groupId, userId, commerceCurrencyId, netPrice, type, parentCommercePriceListId, catalogBasePriceList, name, priority, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public void checkCommercePriceLists() throws PortalException {
        this.checkCommercePriceListsByDisplayDate();
        this.checkCommercePriceListsByExpirationDate();
    }

    public void cleanPriceListCache(long companyId) {
        PortalCache portalCache = this._multiVMPool.getPortalCache("PRICE_LISTS_" + companyId);
        portalCache.removeAll();
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommercePriceList deleteCommercePriceList(CommercePriceList commercePriceList) throws PortalException {
        if (commercePriceList.isCatalogBasePriceList()) {
            throw new CommerceBasePriceListCannotDeleteException();
        }
        return this.commercePriceListLocalService.forceDeleteCommercePriceList(commercePriceList);
    }

    @Override
    public CommercePriceList deleteCommercePriceList(long commercePriceListId) throws PortalException {
        CommercePriceList commercePriceList = this.commercePriceListPersistence.findByPrimaryKey(commercePriceListId);
        return this.commercePriceListLocalService.deleteCommercePriceList(commercePriceList);
    }

    public void deleteCommercePriceLists(long companyId) throws PortalException {
        List commercePriceLists = this.commercePriceListLocalService.getCommercePriceLists(companyId, -1, -1);
        for (CommercePriceList commercePriceList : commercePriceLists) {
            this.commercePriceListLocalService.forceDeleteCommercePriceList(commercePriceList);
        }
    }

    public CommercePriceList fetchByExternalReferenceCode(String externalReferenceCode, long companyId) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.commercePriceListPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public CommercePriceList fetchCatalogBaseCommercePriceList(long groupId) throws PortalException {
        return this.commercePriceListPersistence.fetchByG_C_T(groupId, true, "price-list");
    }

    public CommercePriceList fetchCatalogBaseCommercePriceListByType(long groupId, String type) throws PortalException {
        return this.commercePriceListPersistence.fetchByG_C_T(groupId, true, type);
    }

    @Deprecated
    public CommercePriceList fetchCommerceCatalogBasePriceList(long groupId) throws PortalException {
        return this.commercePriceListLocalService.fetchCatalogBaseCommercePriceList(groupId);
    }

    @Deprecated
    public CommercePriceList fetchCommerceCatalogBasePriceListByType(long groupId, String type) throws PortalException {
        return this.commercePriceListLocalService.fetchCatalogBaseCommercePriceListByType(groupId, type);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommercePriceList forceDeleteCommercePriceList(CommercePriceList commercePriceList) throws PortalException {
        this.commercePriceEntryLocalService.deleteCommercePriceEntries(commercePriceList.getCommercePriceListId());
        this.commercePriceListAccountRelLocalService.deleteCommercePriceListAccountRels(commercePriceList.getCommercePriceListId());
        this.commercePriceListChannelRelLocalService.deleteCommercePriceListChannelRels(commercePriceList.getCommercePriceListId());
        this.commercePriceListCommerceAccountGroupRelLocalService.deleteCommercePriceListCommerceAccountGroupRels(commercePriceList.getCommercePriceListId());
        this.commercePriceListDiscountRelLocalService.deleteCommercePriceListDiscountRels(commercePriceList.getCommercePriceListId());
        this.commercePriceListOrderTypeRelLocalService.deleteCommercePriceListOrderTypeRels(commercePriceList.getCommercePriceListId());
        this._commercePriceModifierLocalService.deleteCommercePriceModifiersByCommercePriceListId(commercePriceList.getCommercePriceListId());
        this.resourceLocalService.deleteResource((AuditedModel)commercePriceList, 4);
        this.commercePriceListPersistence.remove((BaseModel)commercePriceList);
        this._expandoRowLocalService.deleteRows(commercePriceList.getCommercePriceListId());
        this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(commercePriceList.getCompanyId(), commercePriceList.getGroupId(), CommercePriceList.class.getName(), commercePriceList.getCommercePriceListId());
        this.cleanPriceListCache(commercePriceList.getCompanyId());
        return commercePriceList;
    }

    public CommercePriceList getCatalogBaseCommercePriceList(long groupId) throws PortalException {
        CommercePriceList commercePriceList = this.commercePriceListPersistence.fetchByG_C_T(groupId, true, "price-list");
        if (commercePriceList == null) {
            throw new CommerceUndefinedBasePriceListException();
        }
        return commercePriceList;
    }

    public CommercePriceList getCatalogBaseCommercePriceListByType(long groupId, String type) throws PortalException {
        CommercePriceList commercePriceList = this.commercePriceListPersistence.fetchByG_C_T(groupId, true, type);
        if (commercePriceList == null) {
            throw new CommerceUndefinedBasePriceListException();
        }
        return commercePriceList;
    }

    @Deprecated
    public CommercePriceList getCommerceCatalogBasePriceList(long groupId) throws PortalException {
        return this.commercePriceListLocalService.getCatalogBaseCommercePriceList(groupId);
    }

    @Deprecated
    public CommercePriceList getCommerceCatalogBasePriceListByType(long groupId, String type) throws PortalException {
        return this.commercePriceListLocalService.getCatalogBaseCommercePriceListByType(groupId, type);
    }

    public Optional<CommercePriceList> getCommercePriceList(long companyId, long groupId, long commerceAccountId, long[] commerceAccountGroupIds) throws PortalException {
        Company company = this._companyLocalService.getCompany(companyId);
        if (commerceAccountGroupIds == null) {
            commerceAccountGroupIds = new long[]{};
        } else if (commerceAccountGroupIds.length > 1) {
            commerceAccountGroupIds = ArrayUtil.unique((long[])commerceAccountGroupIds);
            Arrays.sort(commerceAccountGroupIds);
        }
        String cacheKey = StringBundler.concat((Object[])new Object[]{groupId, "#", commerceAccountId, "#", StringUtil.merge((long[])commerceAccountGroupIds)});
        PortalCache portalCache = this._multiVMPool.getPortalCache("PRICE_LISTS_" + company.getCompanyId());
        boolean priceListCalculated = GetterUtil.getBoolean((Object)portalCache.get((Serializable)((Object)(cacheKey + "_calculated"))));
        CommercePriceList commercePriceList = (CommercePriceList)portalCache.get((Serializable)((Object)cacheKey));
        if (priceListCalculated) {
            return Optional.ofNullable(commercePriceList);
        }
        SearchContext searchContext = this.buildSearchContext(company.getCompanyId(), groupId, commerceAccountId, commerceAccountGroupIds);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommercePriceList.class);
        Hits hits = indexer.search(searchContext, new String[]{"entryClassPK"});
        List documents = hits.toList();
        if (documents.isEmpty()) {
            portalCache.put((Serializable)((Object)(cacheKey + "_calculated")), (Object)true);
            return Optional.empty();
        }
        Document document = (Document)documents.get(0);
        long commercePriceListId = GetterUtil.getLong((String)document.get("entryClassPK"));
        commercePriceList = this.fetchCommercePriceList(commercePriceListId);
        portalCache.put((Serializable)((Object)cacheKey), (Object)commercePriceList);
        portalCache.put((Serializable)((Object)(cacheKey + "_calculated")), (Object)true);
        return Optional.ofNullable(commercePriceList);
    }

    public CommercePriceList getCommercePriceListByAccountAndChannelAndOrderTypeId(long groupId, long commerceAccountId, long commerceChannelId, long commerceOrderTypeId, String type) {
        List commercePriceLists = (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePriceListTable.INSTANCE), groupId, commerceAccountId, null, commerceChannelId, commerceOrderTypeId, type).orderBy(new OrderByExpression[]{CommercePriceListTable.INSTANCE.priority.descending()}).limit(0, 1));
        if (commercePriceLists.isEmpty()) {
            return null;
        }
        return (CommercePriceList)commercePriceLists.get(0);
    }

    public CommercePriceList getCommercePriceListByAccountAndChannelId(long groupId, long commerceAccountId, long commerceChannelId, String type) {
        List commercePriceLists = (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePriceListTable.INSTANCE), groupId, commerceAccountId, null, commerceChannelId, null, type).orderBy(new OrderByExpression[]{CommercePriceListTable.INSTANCE.priority.descending()}).limit(0, 1));
        if (commercePriceLists.isEmpty()) {
            return null;
        }
        return (CommercePriceList)commercePriceLists.get(0);
    }

    public CommercePriceList getCommercePriceListByAccountAndOrderTypeId(long groupId, long commerceAccountId, long commerceOrderTypeId, String type) {
        List commercePriceLists = (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePriceListTable.INSTANCE), groupId, commerceAccountId, null, null, commerceOrderTypeId, type).orderBy(new OrderByExpression[]{CommercePriceListTable.INSTANCE.priority.descending()}).limit(0, 1));
        if (commercePriceLists.isEmpty()) {
            return null;
        }
        return (CommercePriceList)commercePriceLists.get(0);
    }

    public CommercePriceList getCommercePriceListByAccountGroupAndOrderTypeId(long groupId, long[] commerceAccountGroupIds, long commerceOrderTypeId, String type) {
        List commercePriceLists = (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePriceListTable.INSTANCE), groupId, null, commerceAccountGroupIds, null, commerceOrderTypeId, type).orderBy(new OrderByExpression[]{CommercePriceListTable.INSTANCE.priority.descending()}).limit(0, 1));
        if (commercePriceLists.isEmpty()) {
            return null;
        }
        return (CommercePriceList)commercePriceLists.get(0);
    }

    public CommercePriceList getCommercePriceListByAccountGroupIds(long groupId, long[] commerceAccountGroupIds, String type) {
        List commercePriceLists = (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePriceListTable.INSTANCE), groupId, null, commerceAccountGroupIds, null, null, type).orderBy(new OrderByExpression[]{CommercePriceListTable.INSTANCE.priority.descending()}).limit(0, 1));
        if (commercePriceLists.isEmpty()) {
            return null;
        }
        return (CommercePriceList)commercePriceLists.get(0);
    }

    public CommercePriceList getCommercePriceListByAccountGroupsAndChannelAndOrderTypeId(long groupId, long[] commerceAccountGroupIds, long commerceChannelId, long commerceOrderTypeId, String type) {
        List commercePriceLists = (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePriceListTable.INSTANCE), groupId, null, commerceAccountGroupIds, commerceChannelId, commerceOrderTypeId, type).orderBy(new OrderByExpression[]{CommercePriceListTable.INSTANCE.priority.descending()}).limit(0, 1));
        if (commercePriceLists.isEmpty()) {
            return null;
        }
        return (CommercePriceList)commercePriceLists.get(0);
    }

    public CommercePriceList getCommercePriceListByAccountGroupsAndChannelId(long groupId, long[] commerceAccountGroupIds, long commerceChannelId, String type) {
        List commercePriceLists = (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePriceListTable.INSTANCE), groupId, null, commerceAccountGroupIds, commerceChannelId, null, type).orderBy(new OrderByExpression[]{CommercePriceListTable.INSTANCE.priority.descending()}).limit(0, 1));
        if (commercePriceLists.isEmpty()) {
            return null;
        }
        return (CommercePriceList)commercePriceLists.get(0);
    }

    public CommercePriceList getCommercePriceListByAccountGroupsAndOrderTypeId(long groupId, long[] commerceAccountGroupIds, long commerceOrderTypeId, String type) {
        List commercePriceLists = (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePriceListTable.INSTANCE), groupId, null, commerceAccountGroupIds, null, commerceOrderTypeId, type).orderBy(new OrderByExpression[]{CommercePriceListTable.INSTANCE.priority.descending()}).limit(0, 1));
        if (commercePriceLists.isEmpty()) {
            return null;
        }
        return (CommercePriceList)commercePriceLists.get(0);
    }

    public CommercePriceList getCommercePriceListByAccountId(long groupId, long commerceAccountId, String type) {
        List commercePriceLists = (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePriceListTable.INSTANCE), groupId, commerceAccountId, null, null, null, type).orderBy(new OrderByExpression[]{CommercePriceListTable.INSTANCE.priority.descending()}).limit(0, 1));
        if (commercePriceLists.isEmpty()) {
            return null;
        }
        return (CommercePriceList)commercePriceLists.get(0);
    }

    public CommercePriceList getCommercePriceListByChannelAndOrderTypeId(long groupId, long commerceChannelId, long commerceOrderTypeId, String type) {
        List commercePriceLists = (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePriceListTable.INSTANCE), groupId, null, null, commerceChannelId, commerceOrderTypeId, type).orderBy(new OrderByExpression[]{CommercePriceListTable.INSTANCE.priority.descending()}).limit(0, 1));
        if (commercePriceLists.isEmpty()) {
            return null;
        }
        return (CommercePriceList)commercePriceLists.get(0);
    }

    public CommercePriceList getCommercePriceListByChannelId(long groupId, long commerceChannelId, String type) {
        List commercePriceLists = (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePriceListTable.INSTANCE), groupId, null, null, commerceChannelId, null, type).orderBy(new OrderByExpression[]{CommercePriceListTable.INSTANCE.priority.descending()}).limit(0, 1));
        if (commercePriceLists.isEmpty()) {
            return null;
        }
        return (CommercePriceList)commercePriceLists.get(0);
    }

    public CommercePriceList getCommercePriceListByLowestPrice(long groupId, long commerceAccountId, long[] commerceAccountGroupIds, long commerceChannelId, long commerceOrderTypeId, String cPInstanceUuid, String type) throws PortalException {
        List commercePriceEntries = (List)this.commercePriceEntryPersistence.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePriceEntryTable.INSTANCE), groupId, commerceAccountId, commerceAccountGroupIds, commerceChannelId, commerceOrderTypeId, cPInstanceUuid, type).orderBy(new OrderByExpression[]{CommercePriceEntryTable.INSTANCE.price.ascending()}).limit(0, 1));
        if (commercePriceEntries.isEmpty()) {
            return null;
        }
        CommercePriceEntry commercePriceEntry = (CommercePriceEntry)commercePriceEntries.get(0);
        return commercePriceEntry.getCommercePriceList();
    }

    public CommercePriceList getCommercePriceListByOrderTypeId(long groupId, long commerceOrderTypeId, String type) {
        List commercePriceLists = (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePriceListTable.INSTANCE), groupId, null, null, null, commerceOrderTypeId, type).orderBy(new OrderByExpression[]{CommercePriceListTable.INSTANCE.priority.descending()}).limit(0, 1));
        if (commercePriceLists.isEmpty()) {
            return null;
        }
        return (CommercePriceList)commercePriceLists.get(0);
    }

    public CommercePriceList getCommercePriceListByUnqualified(long groupId, String type) {
        List commercePriceLists = (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePriceListTable.INSTANCE), groupId, null, null, null, null, type).orderBy(new OrderByExpression[]{CommercePriceListTable.INSTANCE.priority.descending(), CommercePriceListTable.INSTANCE.catalogBasePriceList.ascending()}).limit(0, 1));
        if (commercePriceLists.isEmpty()) {
            return null;
        }
        return (CommercePriceList)commercePriceLists.get(0);
    }

    public List<CommercePriceList> getCommercePriceLists(long companyId, int start, int end) {
        return this.commercePriceListPersistence.findByCompanyId(companyId, start, end);
    }

    public List<CommercePriceList> getCommercePriceLists(long[] groupIds, long companyId, int start, int end) {
        return this.commercePriceListPersistence.findByG_C(groupIds, companyId, start, end);
    }

    public List<CommercePriceList> getCommercePriceLists(long[] groupIds, long companyId, int status, int start, int end, OrderByComparator<CommercePriceList> orderByComparator) {
        if (status == -1) {
            return this.commercePriceListPersistence.findByG_C_NotS(groupIds, companyId, 8, start, end, orderByComparator);
        }
        return this.commercePriceListPersistence.findByG_C_S(groupIds, companyId, status, start, end, orderByComparator);
    }

    public int getCommercePriceListsCount(long commercePricingClassId, String name) {
        return this.commercePriceListFinder.countByCommercePricingClassId(commercePricingClassId, name);
    }

    public int getCommercePriceListsCount(long[] groupIds, long companyId, int status) {
        if (status == -1) {
            return this.commercePriceListPersistence.countByG_C_NotS(groupIds, companyId, 8);
        }
        return this.commercePriceListPersistence.countByG_C_S(groupIds, companyId, status);
    }

    public Hits search(SearchContext searchContext) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommercePriceList.class);
            return indexer.search(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public List<CommercePriceList> searchByCommercePricingClassId(long commercePricingClassId, String name, int start, int end) {
        return this.commercePriceListFinder.findByCommercePricingClassId(commercePricingClassId, name, start, end);
    }

    public BaseModelSearchResult<CommercePriceList> searchCommercePriceLists(long companyId, long[] groupIds, String keywords, int status, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, keywords, status, start, end, sort);
        return this.searchCommercePriceLists(searchContext);
    }

    public int searchCommercePriceListsCount(long companyId, long[] groupIds, String keywords, int status) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, keywords, status, -1, -1, null);
        return this.searchCommercePriceListsCount(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceList setCatalogBasePriceList(long commercePriceListId, boolean catalogBasePriceList) throws PortalException {
        CommercePriceList commercePriceList = this.commercePriceListPersistence.findByPrimaryKey(commercePriceListId);
        commercePriceList.setCatalogBasePriceList(catalogBasePriceList);
        return (CommercePriceList)this.commercePriceListPersistence.update((BaseModel)commercePriceList);
    }

    public void setCatalogBasePriceList(long groupId, long commercePriceListId, String type) throws PortalException {
        CommercePriceList baseCommercePriceList = this.commercePriceListPersistence.fetchByG_C_T(groupId, true, type);
        if (baseCommercePriceList != null) {
            this.commercePriceListLocalService.setCatalogBasePriceList(baseCommercePriceList.getCommercePriceListId(), false);
        }
        this.commercePriceListLocalService.setCatalogBasePriceList(commercePriceListId, true);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceList updateCommercePriceList(long commercePriceListId, long commerceCurrencyId, boolean netPrice, long parentCommercePriceListId, String name, double priority, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        CommercePriceList commercePriceList = this.commercePriceListPersistence.findByPrimaryKey(commercePriceListId);
        return this.commercePriceListLocalService.updateCommercePriceList(commercePriceListId, commerceCurrencyId, netPrice, commercePriceList.getType(), parentCommercePriceListId, commercePriceList.isCatalogBasePriceList(), name, priority, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceList updateCommercePriceList(long commercePriceListId, long commerceCurrencyId, boolean netPrice, String type, long parentCommercePriceListId, boolean catalogBasePriceList, String name, double priority, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CommercePriceList commercePriceList = this.commercePriceListPersistence.findByPrimaryKey(commercePriceListId);
        this.validate(commercePriceList.getGroupId(), commerceCurrencyId, parentCommercePriceListId, catalogBasePriceList, commercePriceListId, type);
        Date expirationDate = null;
        Date date = new Date();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), CommercePriceListDisplayDateException.class);
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), CommercePriceListExpirationDateException.class);
        }
        commercePriceList.setCommerceCurrencyId(commerceCurrencyId);
        commercePriceList.setParentCommercePriceListId(parentCommercePriceListId);
        commercePriceList.setCatalogBasePriceList(catalogBasePriceList);
        commercePriceList.setNetPrice(netPrice);
        commercePriceList.setType(type);
        commercePriceList.setName(name);
        commercePriceList.setPriority(priority);
        commercePriceList.setDisplayDate(displayDate);
        commercePriceList.setExpirationDate(expirationDate);
        if (expirationDate == null || expirationDate.after(date)) {
            commercePriceList.setStatus(2);
        } else {
            commercePriceList.setStatus(3);
        }
        commercePriceList.setStatusByUserId(user.getUserId());
        commercePriceList.setStatusDate(serviceContext.getModifiedDate(date));
        commercePriceList.setExpandoBridgeAttributes(serviceContext);
        commercePriceList = (CommercePriceList)this.commercePriceListPersistence.update((BaseModel)commercePriceList);
        commercePriceList = this.startWorkflowInstance(user.getUserId(), commercePriceList, serviceContext);
        this.cleanPriceListCache(commercePriceList.getCompanyId());
        return commercePriceList;
    }

    public void updateCommercePriceListCurrencies(long commerceCurrencyId) throws PortalException {
        List commercePriceLists = this.commercePriceListPersistence.findByCommerceCurrencyId(commerceCurrencyId);
        for (CommercePriceList commercePriceList : commercePriceLists) {
            commercePriceList.setCommerceCurrencyId(0L);
            commercePriceList = (CommercePriceList)this.commercePriceListPersistence.update((BaseModel)commercePriceList);
            this.cleanPriceListCache(commercePriceList.getCompanyId());
            this.doReindex(commercePriceList.getCommercePriceListId());
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceList updateExternalReferenceCode(CommercePriceList commercePriceList, String externalReferenceCode) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        commercePriceList.setExternalReferenceCode(externalReferenceCode);
        commercePriceList = (CommercePriceList)this.commercePriceListPersistence.update((BaseModel)commercePriceList);
        this.cleanPriceListCache(commercePriceList.getCompanyId());
        return commercePriceList;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceList updateStatus(long userId, long commercePriceListId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        Date expirationDate;
        User user = this.userLocalService.getUser(userId);
        Date date = new Date();
        CommercePriceList commercePriceList = this.commercePriceListPersistence.findByPrimaryKey(commercePriceListId);
        if (status == 0 && commercePriceList.getDisplayDate() != null && date.before(commercePriceList.getDisplayDate())) {
            status = 7;
        }
        Date modifiedDate = serviceContext.getModifiedDate(date);
        if (status == 0 && (expirationDate = commercePriceList.getExpirationDate()) != null && expirationDate.before(date)) {
            commercePriceList.setExpirationDate(null);
        }
        if (status == 3) {
            commercePriceList.setExpirationDate(date);
        }
        commercePriceList.setStatus(status);
        commercePriceList.setStatusByUserId(user.getUserId());
        commercePriceList.setStatusByUserName(user.getFullName());
        commercePriceList.setStatusDate(modifiedDate);
        commercePriceList = (CommercePriceList)this.commercePriceListPersistence.update((BaseModel)commercePriceList);
        this.cleanPriceListCache(commercePriceList.getCompanyId());
        return commercePriceList;
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, long commerceAccountId, long[] commerceAccountGroupIds) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"status", (Object)0).put((Object)"commerceAccountGroupIds", (Object)commerceAccountGroupIds).put((Object)"commerceAccountId", (Object)commerceAccountId).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(1);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setStart(0);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        Sort sort = SortFactoryUtil.create((String)"priority_Number_sortable", (boolean)true);
        searchContext.setSorts(new Sort[]{sort});
        return searchContext;
    }

    protected SearchContext buildSearchContext(long companyId, long[] groupIds, String keywords, int status, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"entryClassPK", (Object)keywords).put((Object)"name", (Object)keywords).put((Object)"status", (Object)status).put((Object)"userName", (Object)keywords).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(groupIds);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected void checkCommercePriceListsByDisplayDate() throws PortalException {
        List commercePriceLists = this.commercePriceListPersistence.findByLtD_S(new Date(), 7);
        for (CommercePriceList commercePriceList : commercePriceLists) {
            long userId = PortalUtil.getValidUserId((long)commercePriceList.getCompanyId(), (long)commercePriceList.getUserId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            serviceContext.setScopeGroupId(commercePriceList.getGroupId());
            this.commercePriceListLocalService.updateStatus(userId, commercePriceList.getCommercePriceListId(), 0, serviceContext, new HashMap());
            this.cleanPriceListCache(commercePriceList.getCompanyId());
        }
    }

    protected void checkCommercePriceListsByExpirationDate() throws PortalException {
        List commercePriceLists = this.commercePriceListFinder.findByExpirationDate(new Date(), new QueryDefinition(0));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Expiring " + commercePriceLists.size() + " commerce price lists"));
        }
        if (commercePriceLists != null && !commercePriceLists.isEmpty()) {
            for (CommercePriceList commercePriceList : commercePriceLists) {
                long userId = PortalUtil.getValidUserId((long)commercePriceList.getCompanyId(), (long)commercePriceList.getUserId());
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCommand("update");
                serviceContext.setScopeGroupId(commercePriceList.getGroupId());
                this.commercePriceListLocalService.updateStatus(userId, commercePriceList.getCommercePriceListId(), 3, serviceContext, new HashMap());
                this.cleanPriceListCache(commercePriceList.getCompanyId());
            }
        }
    }

    protected void doReindex(long commercePriceListId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommercePriceList.class);
        indexer.reindex(CommercePriceList.class.getName(), commercePriceListId);
    }

    protected List<CommercePriceList> getCommercePriceLists(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommercePriceList> commercePriceLists = new ArrayList<CommercePriceList>(documents.size());
        for (Document document : documents) {
            long commercePriceListId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommercePriceList commercePriceList = this.fetchCommercePriceList(commercePriceListId);
            if (commercePriceList == null) {
                commercePriceLists = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommercePriceList.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commercePriceLists == null) continue;
            commercePriceLists.add(commercePriceList);
        }
        return commercePriceLists;
    }

    protected BaseModelSearchResult<CommercePriceList> searchCommercePriceLists(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommercePriceList.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommercePriceList> commercePriceLists = this.getCommercePriceLists(hits);
            if (commercePriceLists == null) continue;
            return new BaseModelSearchResult(commercePriceLists, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected int searchCommercePriceListsCount(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommercePriceList.class);
        return GetterUtil.getInteger((Object)indexer.searchCount(searchContext));
    }

    protected CommercePriceList startWorkflowInstance(long userId, CommercePriceList commercePriceList, ServiceContext serviceContext) throws PortalException {
        HashMap workflowContext = new HashMap();
        return (CommercePriceList)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)commercePriceList.getCompanyId(), (long)commercePriceList.getGroupId(), (long)userId, (String)CommercePriceList.class.getName(), (long)commercePriceList.getCommercePriceListId(), (Object)commercePriceList, (ServiceContext)serviceContext, workflowContext);
    }

    protected void validate(long groupId, long commerceCurrencyId, long parentCommercePriceListId, boolean catalogBasePriceList, long commercePriceListId, String type) throws PortalException {
        CommerceCurrency commerceCurrency;
        CommercePriceList basePriceList;
        if (catalogBasePriceList && (basePriceList = this.commercePriceListPersistence.fetchByG_C_T(groupId, true, type)) != null && basePriceList.getCommercePriceListId() != commercePriceListId) {
            throw new DuplicateCommerceBasePriceListException();
        }
        if (parentCommercePriceListId > 0L) {
            if (parentCommercePriceListId == commercePriceListId) {
                throw new CommercePriceListParentPriceListGroupIdException();
            }
            CommercePriceList commercePriceList = this.commercePriceListLocalService.fetchCommercePriceList(parentCommercePriceListId);
            if (commercePriceList != null && commercePriceList.getGroupId() != groupId) {
                throw new CommercePriceListParentPriceListGroupIdException();
            }
        }
        if ((commerceCurrency = this._commerceCurrencyLocalService.fetchCommerceCurrency(commerceCurrencyId)) == null) {
            throw new CommercePriceListCurrencyException();
        }
    }

    protected void validateExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        CommercePriceList commercePriceList = this.commercePriceListPersistence.fetchByC_ERC(companyId, externalReferenceCode);
        if (commercePriceList != null) {
            throw new DuplicateCommercePriceListException("There is another commerce price list with external reference code " + externalReferenceCode);
        }
    }

    private GroupByStep _getGroupByStep(FromStep fromStep, Long groupId, Long commerceAccountId, long[] commerceAccountGroupIds, Long commerceChannelId, Long commerceOrderTypeId, String type) {
        JoinStep joinStep = fromStep.from((Table)CommercePriceListTable.INSTANCE);
        Predicate predicate = CommercePriceListTable.INSTANCE.status.eq((Object)0).and((Expression)CommercePriceListTable.INSTANCE.groupId.eq((Object)groupId)).and((Expression)CommercePriceListTable.INSTANCE.type.eq((Object)type));
        if (commerceAccountId != null) {
            joinStep = joinStep.innerJoinON((Table)CommercePriceListAccountRelTable.INSTANCE, CommercePriceListAccountRelTable.INSTANCE.commercePriceListId.eq((Expression)CommercePriceListTable.INSTANCE.commercePriceListId));
            predicate = predicate.and((Expression)CommercePriceListAccountRelTable.INSTANCE.commerceAccountId.eq((Object)commerceAccountId));
        } else {
            joinStep = joinStep.leftJoinOn((Table)CommercePriceListAccountRelTable.INSTANCE, CommercePriceListAccountRelTable.INSTANCE.commercePriceListId.eq((Expression)CommercePriceListTable.INSTANCE.commercePriceListId));
            predicate = predicate.and((Expression)CommercePriceListAccountRelTable.INSTANCE.commercePriceListAccountRelId.isNull());
        }
        if (commerceAccountGroupIds != null) {
            if (commerceAccountGroupIds.length == 0) {
                commerceAccountGroupIds = new long[]{0L};
            }
            joinStep = joinStep.innerJoinON((Table)CommercePriceListCommerceAccountGroupRelTable.INSTANCE, CommercePriceListCommerceAccountGroupRelTable.INSTANCE.commercePriceListId.eq((Expression)CommercePriceListTable.INSTANCE.commercePriceListId));
            LongStream longStream = Arrays.stream(commerceAccountGroupIds);
            predicate = predicate.and((Expression)CommercePriceListCommerceAccountGroupRelTable.INSTANCE.commerceAccountGroupId.in((Object[])longStream.boxed().toArray(Long[]::new)));
        } else {
            joinStep = joinStep.leftJoinOn((Table)CommercePriceListCommerceAccountGroupRelTable.INSTANCE, CommercePriceListCommerceAccountGroupRelTable.INSTANCE.commercePriceListId.eq((Expression)CommercePriceListTable.INSTANCE.commercePriceListId));
            predicate = predicate.and((Expression)CommercePriceListCommerceAccountGroupRelTable.INSTANCE.commercePriceListCommerceAccountGroupRelId.isNull());
        }
        if (commerceChannelId != null) {
            joinStep = joinStep.innerJoinON((Table)CommercePriceListChannelRelTable.INSTANCE, CommercePriceListChannelRelTable.INSTANCE.commercePriceListId.eq((Expression)CommercePriceListTable.INSTANCE.commercePriceListId));
            predicate = predicate.and((Expression)CommercePriceListChannelRelTable.INSTANCE.commerceChannelId.eq((Object)commerceChannelId));
        } else {
            joinStep = joinStep.leftJoinOn((Table)CommercePriceListChannelRelTable.INSTANCE, CommercePriceListChannelRelTable.INSTANCE.commercePriceListId.eq((Expression)CommercePriceListTable.INSTANCE.commercePriceListId));
            predicate = predicate.and((Expression)CommercePriceListChannelRelTable.INSTANCE.CommercePriceListChannelRelId.isNull());
        }
        if (commerceOrderTypeId != null) {
            joinStep = joinStep.innerJoinON((Table)CommercePriceListOrderTypeRelTable.INSTANCE, CommercePriceListOrderTypeRelTable.INSTANCE.commercePriceListId.eq((Expression)CommercePriceListTable.INSTANCE.commercePriceListId));
            predicate = predicate.and((Expression)CommercePriceListOrderTypeRelTable.INSTANCE.commerceOrderTypeId.eq((Object)commerceOrderTypeId));
        } else {
            joinStep = joinStep.leftJoinOn((Table)CommercePriceListOrderTypeRelTable.INSTANCE, CommercePriceListOrderTypeRelTable.INSTANCE.commercePriceListId.eq((Expression)CommercePriceListTable.INSTANCE.commercePriceListId));
            predicate = predicate.and((Expression)CommercePriceListOrderTypeRelTable.INSTANCE.commercePriceListOrderTypeRelId.isNull());
        }
        return joinStep.where(predicate);
    }

    private GroupByStep _getGroupByStep(FromStep fromStep, Long groupId, Long commerceAccountId, long[] commerceAccountGroupIds, Long commerceChannelId, Long commerceOrderTypeId, String cPInstanceUuid, String type) {
        JoinStep joinStep = fromStep.from((Table)CommercePriceEntryTable.INSTANCE).innerJoinON((Table)CommercePriceListTable.INSTANCE, CommercePriceListTable.INSTANCE.commercePriceListId.eq((Expression)CommercePriceEntryTable.INSTANCE.commercePriceListId)).leftJoinOn((Table)CommercePriceListAccountRelTable.INSTANCE, CommercePriceListAccountRelTable.INSTANCE.commercePriceListId.eq((Expression)CommercePriceListTable.INSTANCE.commercePriceListId)).leftJoinOn((Table)CommercePriceListCommerceAccountGroupRelTable.INSTANCE, CommercePriceListCommerceAccountGroupRelTable.INSTANCE.commercePriceListId.eq((Expression)CommercePriceListTable.INSTANCE.commercePriceListId)).leftJoinOn((Table)CommercePriceListChannelRelTable.INSTANCE, CommercePriceListChannelRelTable.INSTANCE.commercePriceListId.eq((Expression)CommercePriceListTable.INSTANCE.commercePriceListId)).leftJoinOn((Table)CommercePriceListOrderTypeRelTable.INSTANCE, CommercePriceListOrderTypeRelTable.INSTANCE.commercePriceListId.eq((Expression)CommercePriceListTable.INSTANCE.commercePriceListId));
        Object[] commerceAccountGroupObjs = new Long[]{0L};
        if (commerceAccountGroupIds != null && commerceAccountGroupIds.length > 0) {
            LongStream longStream = Arrays.stream(commerceAccountGroupIds);
            commerceAccountGroupObjs = (Long[])longStream.boxed().toArray(Long[]::new);
        }
        Predicate predicate = CommercePriceListTable.INSTANCE.status.eq((Object)0).and((Expression)CommercePriceListTable.INSTANCE.groupId.eq((Object)groupId)).and((Expression)CommercePriceListTable.INSTANCE.type.eq((Object)type)).and((Expression)CommercePriceListAccountRelTable.INSTANCE.commerceAccountId.eq((Object)commerceAccountId).or((Expression)CommercePriceListAccountRelTable.INSTANCE.commercePriceListAccountRelId.isNull()).withParentheses()).and((Expression)CommercePriceListCommerceAccountGroupRelTable.INSTANCE.commerceAccountGroupId.in(commerceAccountGroupObjs).or((Expression)CommercePriceListCommerceAccountGroupRelTable.INSTANCE.commercePriceListCommerceAccountGroupRelId.isNull()).withParentheses()).and((Expression)CommercePriceListChannelRelTable.INSTANCE.commerceChannelId.eq((Object)commerceChannelId).or((Expression)CommercePriceListChannelRelTable.INSTANCE.CommercePriceListChannelRelId.isNull()).withParentheses()).and((Expression)CommercePriceListOrderTypeRelTable.INSTANCE.commerceOrderTypeId.eq((Object)commerceOrderTypeId).or((Expression)CommercePriceListOrderTypeRelTable.INSTANCE.commercePriceListOrderTypeRelId.isNull()).withParentheses());
        if (!Validator.isBlank((String)cPInstanceUuid)) {
            predicate = predicate.and((Expression)CommercePriceEntryTable.INSTANCE.CPInstanceUuid.eq((Object)cPInstanceUuid)).and((Expression)CommercePriceEntryTable.INSTANCE.status.eq((Object)0));
        }
        return joinStep.where(predicate);
    }
}

