/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.service.persistence.impl;

import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.impl.CommercePriceEntryImpl;
import com.liferay.commerce.price.list.model.impl.CommercePriceListImpl;
import com.liferay.commerce.price.list.service.persistence.CommercePriceListFinder;
import com.liferay.commerce.price.list.service.persistence.impl.CommercePriceListFinderBaseImpl;
import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class CommercePriceListFinderImpl
extends CommercePriceListFinderBaseImpl
implements CommercePriceListFinder {
    public static final String COUNT_BY_COMMERCE_PRICING_CLASS_ID = CommercePriceListFinder.class.getName() + ".countByCommercePricingClassId";
    public static final String COUNT_BY_CPINSTANCE_UUID = CommercePriceListFinder.class.getName() + ".countByCPInstanceUuid";
    public static final String FIND_BASE_PRICE_ENTRY = CommercePriceListFinder.class.getName() + ".findBasePriceEntry";
    public static final String FIND_BY_EXPIRATION_DATE = CommercePriceListFinder.class.getName() + ".findByExpirationDate";
    public static final String FIND_BY_COMMERCE_ACCOUNT_ID = CommercePriceListFinder.class.getName() + ".findByCommerceAccountId";
    public static final String FIND_BY_COMMERCE_PRICING_CLASS_ID = CommercePriceListFinder.class.getName() + ".findByCommercePricingClassId";
    public static final String FIND_BY_CPINSTANCE_UUID = CommercePriceListFinder.class.getName() + ".findByCPInstanceUuid";
    public static final String FIND_BY_ACCOUNT_AND_CHANNEL_ID = CommercePriceListFinder.class.getName() + ".findByAccountAndChannelId";
    public static final String FIND_BY_COMMERCE_ACCOUNT_GROUP_IDS = CommercePriceListFinder.class.getName() + ".findByCommerceAccountGroupIds";
    public static final String FIND_BY_ACCOUNT_GROUPS_AND_CHANNEL_ID = CommercePriceListFinder.class.getName() + ".findByAccountGroupsAndChannelId";
    public static final String FIND_BY_COMMERCE_CHANNEL_ID = CommercePriceListFinder.class.getName() + ".findByCommerceChannelId";
    public static final String FIND_BY_UNQUALIFIED = CommercePriceListFinder.class.getName() + ".findByUnqualified";
    public static final String FIND_BY_LOWEST_PRICE = CommercePriceListFinder.class.getName() + ".findByLowestPrice";
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;

    public int countByCommercePricingClassId(long commercePricingClassId, String name) {
        return this.countByCommercePricingClassId(commercePricingClassId, name, false);
    }

    public int countByCommercePricingClassId(long commercePricingClassId, String name, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            Iterator iterator;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_COMMERCE_PRICING_CLASS_ID);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)CommercePriceList.class.getName(), (String)"CommercePriceList.commercePriceListId", null, null, (long[])new long[]{0L}, null);
            }
            String[] keywords = this._customSQL.keywords(name, true);
            if (Validator.isNotNull((String)name)) {
                sql = this._customSQL.replaceKeywords(sql, "(LOWER(CommercePriceList.name)", "LIKE", true, keywords);
                sql = this._customSQL.replaceAndOperator(sql, false);
            } else {
                sql = StringUtil.removeSubstring((String)sql, (String)" AND (LOWER(CommercePriceList.name) LIKE ? [$AND_OR_NULL_CHECK$])");
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(PortalUtil.getClassNameId((String)CommercePricingClass.class.getName()));
            queryPos.add(commercePricingClassId);
            if (Validator.isNotNull((String)name)) {
                queryPos.add(keywords, 2);
            }
            if ((iterator = sqlQuery.iterate()).hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByCPInstanceUuid(String cpInstanceUuid) {
        return this.countByCPInstanceUuid(cpInstanceUuid, false);
    }

    public int countByCPInstanceUuid(String cpInstanceUuid, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_CPINSTANCE_UUID);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)CommercePriceList.class.getName(), (String)"CommercePriceEntry.commercePriceListId", null, null, (long[])new long[]{0L}, null);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(cpInstanceUuid);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public CommercePriceEntry findBasePriceEntry(String cpInstanceUuid, String priceListType) {
        return this.findBasePriceEntry(cpInstanceUuid, priceListType, false);
    }

    public CommercePriceEntry findBasePriceEntry(String cpInstanceUuid, String priceListType, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BASE_PRICE_ENTRY);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)CommercePriceList.class.getName(), (String)"CommercePriceEntry.commercePriceListId", null, null, (long[])new long[]{0L}, null);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommercePriceEntry", CommercePriceEntryImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(cpInstanceUuid);
            queryPos.add(priceListType);
            List commercePriceEntries = sqlQuery.list();
            if (!commercePriceEntries.isEmpty()) {
                CommercePriceEntry commercePriceEntry = (CommercePriceEntry)commercePriceEntries.get(0);
                return commercePriceEntry;
            }
            CommercePriceEntry commercePriceEntry = null;
            return commercePriceEntry;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommercePriceList> findByCommerceAccountAndChannelId(QueryDefinition<CommercePriceList> queryDefinition) {
        return this.doFindByPK(FIND_BY_ACCOUNT_AND_CHANNEL_ID, (Long)queryDefinition.getAttribute("groupId"), (String)((Object)queryDefinition.getAttribute("type")), (Long)queryDefinition.getAttribute("commerceChannelId"), (Long)queryDefinition.getAttribute("commerceAccountId"), queryDefinition.getStart(), queryDefinition.getEnd());
    }

    public List<CommercePriceList> findByExpirationDate(Date expirationDate, QueryDefinition<CommercePriceList> queryDefinition) {
        return this.doFindByExpirationDate(expirationDate, queryDefinition);
    }

    public List<CommercePriceList> findByCommerceAccountId(QueryDefinition<CommercePriceList> queryDefinition) {
        return this.doFindByPK(FIND_BY_COMMERCE_ACCOUNT_ID, (Long)queryDefinition.getAttribute("groupId"), (String)((Object)queryDefinition.getAttribute("type")), (Long)queryDefinition.getAttribute("commerceAccountId"), queryDefinition.getStart(), queryDefinition.getEnd());
    }

    public List<CommercePriceList> findByCommerceAccountGroupIds(QueryDefinition<CommercePriceList> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_COMMERCE_ACCOUNT_GROUP_IDS);
            long[] commerceAccountGroupIds = (long[])queryDefinition.getAttribute("commerceAccountGroupIds");
            sql = this.replaceAccountGroupIds(sql, commerceAccountGroupIds);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommercePriceList", CommercePriceListImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            long groupId = (Long)queryDefinition.getAttribute("groupId");
            String type = (String)((Object)queryDefinition.getAttribute("type"));
            queryPos.add(groupId);
            queryPos.add(type);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommercePriceList> findByCommerceAccountGroupsAndChannelId(QueryDefinition<CommercePriceList> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_ACCOUNT_GROUPS_AND_CHANNEL_ID);
            long[] commerceAccountGroupIds = (long[])queryDefinition.getAttribute("commerceAccountGroupIds");
            sql = this.replaceAccountGroupIds(sql, commerceAccountGroupIds);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommercePriceList", CommercePriceListImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            long commerceChannelId = (Long)queryDefinition.getAttribute("commerceChannelId");
            long groupId = (Long)queryDefinition.getAttribute("groupId");
            String type = (String)((Object)queryDefinition.getAttribute("type"));
            queryPos.add(commerceChannelId);
            queryPos.add(groupId);
            queryPos.add(type);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommercePriceList> findByCommercePricingClassId(long commercePricingClassId, String name, int start, int end) {
        return this.findByCommercePricingClassId(commercePricingClassId, name, start, end, false);
    }

    public List<CommercePriceList> findByCommercePricingClassId(long commercePricingClassId, String name, int start, int end, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String[] keywords = this._customSQL.keywords(name, true);
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_COMMERCE_PRICING_CLASS_ID);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)CommercePriceList.class.getName(), (String)"CommercePriceList.commercePriceListId", null, null, (long[])new long[]{0L}, null);
            }
            if (Validator.isNotNull((String)name)) {
                sql = this._customSQL.replaceKeywords(sql, "(LOWER(CommercePriceList.name)", "LIKE", true, keywords);
                sql = this._customSQL.replaceAndOperator(sql, false);
            } else {
                sql = StringUtil.removeSubstring((String)sql, (String)" AND (LOWER(CommercePriceList.name) LIKE ? [$AND_OR_NULL_CHECK$])");
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommercePriceList", CommercePriceListImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(PortalUtil.getClassNameId((String)CommercePricingClass.class.getName()));
            queryPos.add(commercePricingClassId);
            if (Validator.isNotNull((String)name)) {
                queryPos.add(keywords, 2);
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommercePriceEntry> findByCPInstanceUuid(String cpInstanceUuid, int start, int end) {
        return this.findByCPInstanceUuid(cpInstanceUuid, start, end, false);
    }

    public List<CommercePriceEntry> findByCPInstanceUuid(String cpInstanceUuid, int start, int end, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_CPINSTANCE_UUID);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)CommercePriceList.class.getName(), (String)"CommercePriceEntry.commercePriceListId", null, null, (long[])new long[]{0L}, null);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommercePriceEntry", CommercePriceEntryImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(cpInstanceUuid);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommercePriceList> findByCommerceChannelId(QueryDefinition<CommercePriceList> queryDefinition) {
        return this.doFindByPK(FIND_BY_COMMERCE_CHANNEL_ID, (Long)queryDefinition.getAttribute("groupId"), (String)((Object)queryDefinition.getAttribute("type")), (Long)queryDefinition.getAttribute("commerceChannelId"), queryDefinition.getStart(), queryDefinition.getEnd());
    }

    public List<CommercePriceList> findByUnqualified(QueryDefinition<CommercePriceList> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_UNQUALIFIED);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommercePriceList", CommercePriceListImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            long groupId = (Long)queryDefinition.getAttribute("groupId");
            String type = (String)((Object)queryDefinition.getAttribute("type"));
            queryPos.add(groupId);
            queryPos.add(type);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommercePriceEntry> findByLowestPrice(QueryDefinition<CommercePriceList> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_LOWEST_PRICE);
            long[] commerceAccountGroupIds = (long[])queryDefinition.getAttribute("commerceAccountGroupIds");
            sql = this.replaceAccountGroupIds(sql, commerceAccountGroupIds);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommercePriceEntry", CommercePriceEntryImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            String cPInstanceUuid = (String)((Object)queryDefinition.getAttribute("cPInstanceUuid"));
            long groupId = (Long)queryDefinition.getAttribute("groupId");
            String type = (String)((Object)queryDefinition.getAttribute("type"));
            long commerceAccountId = (Long)queryDefinition.getAttribute("commerceAccountId");
            long commerceChannelId = (Long)queryDefinition.getAttribute("commerceChannelId");
            queryPos.add(cPInstanceUuid);
            queryPos.add(groupId);
            queryPos.add(type);
            queryPos.add(commerceAccountId);
            queryPos.add(commerceChannelId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<CommercePriceList> doFindByExpirationDate(Date expirationDate, QueryDefinition<CommercePriceList> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_EXPIRATION_DATE, queryDefinition, "CommercePriceList");
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommercePriceList", CommercePriceListImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (expirationDate != null) {
                queryPos.add(expirationDate);
            }
            queryPos.add(queryDefinition.getStatus());
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<CommercePriceList> doFindByPK(String queryName, long groupId, String type, long classPK, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), queryName);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommercePriceList", CommercePriceListImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(classPK);
            queryPos.add(groupId);
            queryPos.add(type);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<CommercePriceList> doFindByPK(String queryName, long groupId, String type, long classPK1, long classPK2, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), queryName);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommercePriceList", CommercePriceListImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(classPK1);
            queryPos.add(classPK2);
            queryPos.add(groupId);
            queryPos.add(type);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String replaceAccountGroupIds(String sql, long[] commerceAccountGroupIds) {
        if (commerceAccountGroupIds.length == 0) {
            return StringUtil.replace((String)sql, (String)"[$ACCOUNT_GROUP_IDS$]", (String)"0");
        }
        StringBundler sb = new StringBundler(commerceAccountGroupIds.length);
        for (int i = 0; i < commerceAccountGroupIds.length; ++i) {
            sb.append(commerceAccountGroupIds[i]);
            if (i == commerceAccountGroupIds.length - 1) continue;
            sb.append(", ");
        }
        return StringUtil.replace((String)sql, (String)"[$ACCOUNT_GROUP_IDS$]", (String)sb.toString());
    }
}

