/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.price.list.model.impl;

import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommercePriceList service. Represents a row in the &quot;CommercePriceList&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommercePriceListModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommercePriceListImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommercePriceListImpl
 * @generated
 */
@JSON(strict = true)
public class CommercePriceListModelImpl
	extends BaseModelImpl<CommercePriceList> implements CommercePriceListModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce price list model instance should use the <code>CommercePriceList</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommercePriceList";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"externalReferenceCode", Types.VARCHAR},
		{"commercePriceListId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"commerceCurrencyId", Types.BIGINT},
		{"parentCommercePriceListId", Types.BIGINT},
		{"catalogBasePriceList", Types.BOOLEAN}, {"netPrice", Types.BOOLEAN},
		{"type_", Types.VARCHAR}, {"name", Types.VARCHAR},
		{"priority", Types.DOUBLE}, {"displayDate", Types.TIMESTAMP},
		{"expirationDate", Types.TIMESTAMP},
		{"lastPublishDate", Types.TIMESTAMP}, {"status", Types.INTEGER},
		{"statusByUserId", Types.BIGINT}, {"statusByUserName", Types.VARCHAR},
		{"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commercePriceListId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("commerceCurrencyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("parentCommercePriceListId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("catalogBasePriceList", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("netPrice", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("type_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("priority", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("displayDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("expirationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommercePriceList (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,commercePriceListId LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,commerceCurrencyId LONG,parentCommercePriceListId LONG,catalogBasePriceList BOOLEAN,netPrice BOOLEAN,type_ VARCHAR(75) null,name VARCHAR(75) null,priority DOUBLE,displayDate DATE null,expirationDate DATE null,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null,primary key (commercePriceListId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table CommercePriceList";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commercePriceList.displayDate DESC, commercePriceList.createDate DESC, commercePriceList.priority DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommercePriceList.displayDate DESC, CommercePriceList.createDate DESC, CommercePriceList.priority DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CATALOGBASEPRICELIST_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMMERCECURRENCYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DISPLAYDATE_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PARENTCOMMERCEPRICELISTID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TYPE_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 1024L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PRIORITY_COLUMN_BITMASK = 2048L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public CommercePriceListModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commercePriceListId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommercePriceListId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commercePriceListId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommercePriceList.class;
	}

	@Override
	public String getModelClassName() {
		return CommercePriceList.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommercePriceList, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommercePriceList, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommercePriceList, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommercePriceList)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommercePriceList, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommercePriceList, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommercePriceList)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommercePriceList, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommercePriceList, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<CommercePriceList, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<CommercePriceList, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommercePriceList, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<CommercePriceList, Object>>();
		Map<String, BiConsumer<CommercePriceList, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<CommercePriceList, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", CommercePriceList::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<CommercePriceList, Long>)
				CommercePriceList::setMvccVersion);
		attributeGetterFunctions.put(
			"ctCollectionId", CommercePriceList::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId",
			(BiConsumer<CommercePriceList, Long>)
				CommercePriceList::setCtCollectionId);
		attributeGetterFunctions.put("uuid", CommercePriceList::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<CommercePriceList, String>)CommercePriceList::setUuid);
		attributeGetterFunctions.put(
			"externalReferenceCode",
			CommercePriceList::getExternalReferenceCode);
		attributeSetterBiConsumers.put(
			"externalReferenceCode",
			(BiConsumer<CommercePriceList, String>)
				CommercePriceList::setExternalReferenceCode);
		attributeGetterFunctions.put(
			"commercePriceListId", CommercePriceList::getCommercePriceListId);
		attributeSetterBiConsumers.put(
			"commercePriceListId",
			(BiConsumer<CommercePriceList, Long>)
				CommercePriceList::setCommercePriceListId);
		attributeGetterFunctions.put("groupId", CommercePriceList::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<CommercePriceList, Long>)CommercePriceList::setGroupId);
		attributeGetterFunctions.put(
			"companyId", CommercePriceList::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<CommercePriceList, Long>)
				CommercePriceList::setCompanyId);
		attributeGetterFunctions.put("userId", CommercePriceList::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<CommercePriceList, Long>)CommercePriceList::setUserId);
		attributeGetterFunctions.put(
			"userName", CommercePriceList::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<CommercePriceList, String>)
				CommercePriceList::setUserName);
		attributeGetterFunctions.put(
			"createDate", CommercePriceList::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<CommercePriceList, Date>)
				CommercePriceList::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", CommercePriceList::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<CommercePriceList, Date>)
				CommercePriceList::setModifiedDate);
		attributeGetterFunctions.put(
			"commerceCurrencyId", CommercePriceList::getCommerceCurrencyId);
		attributeSetterBiConsumers.put(
			"commerceCurrencyId",
			(BiConsumer<CommercePriceList, Long>)
				CommercePriceList::setCommerceCurrencyId);
		attributeGetterFunctions.put(
			"parentCommercePriceListId",
			CommercePriceList::getParentCommercePriceListId);
		attributeSetterBiConsumers.put(
			"parentCommercePriceListId",
			(BiConsumer<CommercePriceList, Long>)
				CommercePriceList::setParentCommercePriceListId);
		attributeGetterFunctions.put(
			"catalogBasePriceList", CommercePriceList::getCatalogBasePriceList);
		attributeSetterBiConsumers.put(
			"catalogBasePriceList",
			(BiConsumer<CommercePriceList, Boolean>)
				CommercePriceList::setCatalogBasePriceList);
		attributeGetterFunctions.put(
			"netPrice", CommercePriceList::getNetPrice);
		attributeSetterBiConsumers.put(
			"netPrice",
			(BiConsumer<CommercePriceList, Boolean>)
				CommercePriceList::setNetPrice);
		attributeGetterFunctions.put("type", CommercePriceList::getType);
		attributeSetterBiConsumers.put(
			"type",
			(BiConsumer<CommercePriceList, String>)CommercePriceList::setType);
		attributeGetterFunctions.put("name", CommercePriceList::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<CommercePriceList, String>)CommercePriceList::setName);
		attributeGetterFunctions.put(
			"priority", CommercePriceList::getPriority);
		attributeSetterBiConsumers.put(
			"priority",
			(BiConsumer<CommercePriceList, Double>)
				CommercePriceList::setPriority);
		attributeGetterFunctions.put(
			"displayDate", CommercePriceList::getDisplayDate);
		attributeSetterBiConsumers.put(
			"displayDate",
			(BiConsumer<CommercePriceList, Date>)
				CommercePriceList::setDisplayDate);
		attributeGetterFunctions.put(
			"expirationDate", CommercePriceList::getExpirationDate);
		attributeSetterBiConsumers.put(
			"expirationDate",
			(BiConsumer<CommercePriceList, Date>)
				CommercePriceList::setExpirationDate);
		attributeGetterFunctions.put(
			"lastPublishDate", CommercePriceList::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<CommercePriceList, Date>)
				CommercePriceList::setLastPublishDate);
		attributeGetterFunctions.put("status", CommercePriceList::getStatus);
		attributeSetterBiConsumers.put(
			"status",
			(BiConsumer<CommercePriceList, Integer>)
				CommercePriceList::setStatus);
		attributeGetterFunctions.put(
			"statusByUserId", CommercePriceList::getStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<CommercePriceList, Long>)
				CommercePriceList::setStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName", CommercePriceList::getStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<CommercePriceList, String>)
				CommercePriceList::setStatusByUserName);
		attributeGetterFunctions.put(
			"statusDate", CommercePriceList::getStatusDate);
		attributeSetterBiConsumers.put(
			"statusDate",
			(BiConsumer<CommercePriceList, Date>)
				CommercePriceList::setStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getCommercePriceListId() {
		return _commercePriceListId;
	}

	@Override
	public void setCommercePriceListId(long commercePriceListId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commercePriceListId = commercePriceListId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCommerceCurrencyId() {
		return _commerceCurrencyId;
	}

	@Override
	public void setCommerceCurrencyId(long commerceCurrencyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceCurrencyId = commerceCurrencyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCommerceCurrencyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("commerceCurrencyId"));
	}

	@JSON
	@Override
	public long getParentCommercePriceListId() {
		return _parentCommercePriceListId;
	}

	@Override
	public void setParentCommercePriceListId(long parentCommercePriceListId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parentCommercePriceListId = parentCommercePriceListId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalParentCommercePriceListId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("parentCommercePriceListId"));
	}

	@JSON
	@Override
	public boolean getCatalogBasePriceList() {
		return _catalogBasePriceList;
	}

	@JSON
	@Override
	public boolean isCatalogBasePriceList() {
		return _catalogBasePriceList;
	}

	@Override
	public void setCatalogBasePriceList(boolean catalogBasePriceList) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_catalogBasePriceList = catalogBasePriceList;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalCatalogBasePriceList() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("catalogBasePriceList"));
	}

	@JSON
	@Override
	public boolean getNetPrice() {
		return _netPrice;
	}

	@JSON
	@Override
	public boolean isNetPrice() {
		return _netPrice;
	}

	@Override
	public void setNetPrice(boolean netPrice) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_netPrice = netPrice;
	}

	@JSON
	@Override
	public String getType() {
		if (_type == null) {
			return "";
		}
		else {
			return _type;
		}
	}

	@Override
	public void setType(String type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalType() {
		return getColumnOriginalValue("type_");
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@JSON
	@Override
	public double getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(double priority) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_priority = priority;
	}

	@JSON
	@Override
	public Date getDisplayDate() {
		return _displayDate;
	}

	@Override
	public void setDisplayDate(Date displayDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_displayDate = displayDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalDisplayDate() {
		return getColumnOriginalValue("displayDate");
	}

	@JSON
	@Override
	public Date getExpirationDate() {
		return _expirationDate;
	}

	@Override
	public void setExpirationDate(Date expirationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_expirationDate = expirationDate;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(CommercePriceList.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommercePriceList.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommercePriceList toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommercePriceList>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommercePriceListImpl commercePriceListImpl =
			new CommercePriceListImpl();

		commercePriceListImpl.setMvccVersion(getMvccVersion());
		commercePriceListImpl.setCtCollectionId(getCtCollectionId());
		commercePriceListImpl.setUuid(getUuid());
		commercePriceListImpl.setExternalReferenceCode(
			getExternalReferenceCode());
		commercePriceListImpl.setCommercePriceListId(getCommercePriceListId());
		commercePriceListImpl.setGroupId(getGroupId());
		commercePriceListImpl.setCompanyId(getCompanyId());
		commercePriceListImpl.setUserId(getUserId());
		commercePriceListImpl.setUserName(getUserName());
		commercePriceListImpl.setCreateDate(getCreateDate());
		commercePriceListImpl.setModifiedDate(getModifiedDate());
		commercePriceListImpl.setCommerceCurrencyId(getCommerceCurrencyId());
		commercePriceListImpl.setParentCommercePriceListId(
			getParentCommercePriceListId());
		commercePriceListImpl.setCatalogBasePriceList(isCatalogBasePriceList());
		commercePriceListImpl.setNetPrice(isNetPrice());
		commercePriceListImpl.setType(getType());
		commercePriceListImpl.setName(getName());
		commercePriceListImpl.setPriority(getPriority());
		commercePriceListImpl.setDisplayDate(getDisplayDate());
		commercePriceListImpl.setExpirationDate(getExpirationDate());
		commercePriceListImpl.setLastPublishDate(getLastPublishDate());
		commercePriceListImpl.setStatus(getStatus());
		commercePriceListImpl.setStatusByUserId(getStatusByUserId());
		commercePriceListImpl.setStatusByUserName(getStatusByUserName());
		commercePriceListImpl.setStatusDate(getStatusDate());

		commercePriceListImpl.resetOriginalValues();

		return commercePriceListImpl;
	}

	@Override
	public CommercePriceList cloneWithOriginalValues() {
		CommercePriceListImpl commercePriceListImpl =
			new CommercePriceListImpl();

		commercePriceListImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		commercePriceListImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		commercePriceListImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		commercePriceListImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		commercePriceListImpl.setCommercePriceListId(
			this.<Long>getColumnOriginalValue("commercePriceListId"));
		commercePriceListImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		commercePriceListImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		commercePriceListImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		commercePriceListImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		commercePriceListImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		commercePriceListImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		commercePriceListImpl.setCommerceCurrencyId(
			this.<Long>getColumnOriginalValue("commerceCurrencyId"));
		commercePriceListImpl.setParentCommercePriceListId(
			this.<Long>getColumnOriginalValue("parentCommercePriceListId"));
		commercePriceListImpl.setCatalogBasePriceList(
			this.<Boolean>getColumnOriginalValue("catalogBasePriceList"));
		commercePriceListImpl.setNetPrice(
			this.<Boolean>getColumnOriginalValue("netPrice"));
		commercePriceListImpl.setType(
			this.<String>getColumnOriginalValue("type_"));
		commercePriceListImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		commercePriceListImpl.setPriority(
			this.<Double>getColumnOriginalValue("priority"));
		commercePriceListImpl.setDisplayDate(
			this.<Date>getColumnOriginalValue("displayDate"));
		commercePriceListImpl.setExpirationDate(
			this.<Date>getColumnOriginalValue("expirationDate"));
		commercePriceListImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));
		commercePriceListImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));
		commercePriceListImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		commercePriceListImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		commercePriceListImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return commercePriceListImpl;
	}

	@Override
	public int compareTo(CommercePriceList commercePriceList) {
		int value = 0;

		value = DateUtil.compareTo(
			getDisplayDate(), commercePriceList.getDisplayDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		value = DateUtil.compareTo(
			getCreateDate(), commercePriceList.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		if (getPriority() < commercePriceList.getPriority()) {
			value = -1;
		}
		else if (getPriority() > commercePriceList.getPriority()) {
			value = 1;
		}
		else {
			value = 0;
		}

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommercePriceList)) {
			return false;
		}

		CommercePriceList commercePriceList = (CommercePriceList)object;

		long primaryKey = commercePriceList.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommercePriceList> toCacheModel() {
		CommercePriceListCacheModel commercePriceListCacheModel =
			new CommercePriceListCacheModel();

		commercePriceListCacheModel.mvccVersion = getMvccVersion();

		commercePriceListCacheModel.ctCollectionId = getCtCollectionId();

		commercePriceListCacheModel.uuid = getUuid();

		String uuid = commercePriceListCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commercePriceListCacheModel.uuid = null;
		}

		commercePriceListCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			commercePriceListCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			commercePriceListCacheModel.externalReferenceCode = null;
		}

		commercePriceListCacheModel.commercePriceListId =
			getCommercePriceListId();

		commercePriceListCacheModel.groupId = getGroupId();

		commercePriceListCacheModel.companyId = getCompanyId();

		commercePriceListCacheModel.userId = getUserId();

		commercePriceListCacheModel.userName = getUserName();

		String userName = commercePriceListCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commercePriceListCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commercePriceListCacheModel.createDate = createDate.getTime();
		}
		else {
			commercePriceListCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commercePriceListCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commercePriceListCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commercePriceListCacheModel.commerceCurrencyId =
			getCommerceCurrencyId();

		commercePriceListCacheModel.parentCommercePriceListId =
			getParentCommercePriceListId();

		commercePriceListCacheModel.catalogBasePriceList =
			isCatalogBasePriceList();

		commercePriceListCacheModel.netPrice = isNetPrice();

		commercePriceListCacheModel.type = getType();

		String type = commercePriceListCacheModel.type;

		if ((type != null) && (type.length() == 0)) {
			commercePriceListCacheModel.type = null;
		}

		commercePriceListCacheModel.name = getName();

		String name = commercePriceListCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			commercePriceListCacheModel.name = null;
		}

		commercePriceListCacheModel.priority = getPriority();

		Date displayDate = getDisplayDate();

		if (displayDate != null) {
			commercePriceListCacheModel.displayDate = displayDate.getTime();
		}
		else {
			commercePriceListCacheModel.displayDate = Long.MIN_VALUE;
		}

		Date expirationDate = getExpirationDate();

		if (expirationDate != null) {
			commercePriceListCacheModel.expirationDate =
				expirationDate.getTime();
		}
		else {
			commercePriceListCacheModel.expirationDate = Long.MIN_VALUE;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			commercePriceListCacheModel.lastPublishDate =
				lastPublishDate.getTime();
		}
		else {
			commercePriceListCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		commercePriceListCacheModel.status = getStatus();

		commercePriceListCacheModel.statusByUserId = getStatusByUserId();

		commercePriceListCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = commercePriceListCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			commercePriceListCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			commercePriceListCacheModel.statusDate = statusDate.getTime();
		}
		else {
			commercePriceListCacheModel.statusDate = Long.MIN_VALUE;
		}

		return commercePriceListCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommercePriceList, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommercePriceList, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommercePriceList, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommercePriceList)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommercePriceList, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommercePriceList, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommercePriceList, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((CommercePriceList)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CommercePriceList>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					CommercePriceList.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private String _externalReferenceCode;
	private long _commercePriceListId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _commerceCurrencyId;
	private long _parentCommercePriceListId;
	private boolean _catalogBasePriceList;
	private boolean _netPrice;
	private String _type;
	private String _name;
	private double _priority;
	private Date _displayDate;
	private Date _expirationDate;
	private Date _lastPublishDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommercePriceList, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommercePriceList)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("commercePriceListId", _commercePriceListId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("commerceCurrencyId", _commerceCurrencyId);
		_columnOriginalValues.put(
			"parentCommercePriceListId", _parentCommercePriceListId);
		_columnOriginalValues.put(
			"catalogBasePriceList", _catalogBasePriceList);
		_columnOriginalValues.put("netPrice", _netPrice);
		_columnOriginalValues.put("type_", _type);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("priority", _priority);
		_columnOriginalValues.put("displayDate", _displayDate);
		_columnOriginalValues.put("expirationDate", _expirationDate);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("externalReferenceCode", 8L);

		columnBitmasks.put("commercePriceListId", 16L);

		columnBitmasks.put("groupId", 32L);

		columnBitmasks.put("companyId", 64L);

		columnBitmasks.put("userId", 128L);

		columnBitmasks.put("userName", 256L);

		columnBitmasks.put("createDate", 512L);

		columnBitmasks.put("modifiedDate", 1024L);

		columnBitmasks.put("commerceCurrencyId", 2048L);

		columnBitmasks.put("parentCommercePriceListId", 4096L);

		columnBitmasks.put("catalogBasePriceList", 8192L);

		columnBitmasks.put("netPrice", 16384L);

		columnBitmasks.put("type_", 32768L);

		columnBitmasks.put("name", 65536L);

		columnBitmasks.put("priority", 131072L);

		columnBitmasks.put("displayDate", 262144L);

		columnBitmasks.put("expirationDate", 524288L);

		columnBitmasks.put("lastPublishDate", 1048576L);

		columnBitmasks.put("status", 2097152L);

		columnBitmasks.put("statusByUserId", 4194304L);

		columnBitmasks.put("statusByUserName", 8388608L);

		columnBitmasks.put("statusDate", 16777216L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommercePriceList _escapedModel;

}