/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.price.list.model.impl;

import com.liferay.commerce.price.list.model.CommerceTierPriceEntry;
import com.liferay.commerce.price.list.model.CommerceTierPriceEntryModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.math.BigDecimal;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceTierPriceEntry service. Represents a row in the &quot;CommerceTierPriceEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceTierPriceEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceTierPriceEntryImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceTierPriceEntryImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceTierPriceEntryModelImpl
	extends BaseModelImpl<CommerceTierPriceEntry>
	implements CommerceTierPriceEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce tier price entry model instance should use the <code>CommerceTierPriceEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceTierPriceEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"externalReferenceCode", Types.VARCHAR},
		{"commerceTierPriceEntryId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"commercePriceEntryId", Types.BIGINT}, {"price", Types.DECIMAL},
		{"promoPrice", Types.DECIMAL}, {"discountDiscovery", Types.BOOLEAN},
		{"discountLevel1", Types.DECIMAL}, {"discountLevel2", Types.DECIMAL},
		{"discountLevel3", Types.DECIMAL}, {"discountLevel4", Types.DECIMAL},
		{"minQuantity", Types.INTEGER}, {"displayDate", Types.TIMESTAMP},
		{"expirationDate", Types.TIMESTAMP},
		{"lastPublishDate", Types.TIMESTAMP}, {"status", Types.INTEGER},
		{"statusByUserId", Types.BIGINT}, {"statusByUserName", Types.VARCHAR},
		{"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceTierPriceEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("commercePriceEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("price", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("promoPrice", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountDiscovery", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("discountLevel1", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountLevel2", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountLevel3", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountLevel4", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("minQuantity", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("displayDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("expirationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceTierPriceEntry (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,commerceTierPriceEntryId LONG not null,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,commercePriceEntryId LONG,price DECIMAL(30, 16) null,promoPrice DECIMAL(30, 16) null,discountDiscovery BOOLEAN,discountLevel1 DECIMAL(30, 16) null,discountLevel2 DECIMAL(30, 16) null,discountLevel3 DECIMAL(30, 16) null,discountLevel4 DECIMAL(30, 16) null,minQuantity INTEGER,displayDate DATE null,expirationDate DATE null,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null,primary key (commerceTierPriceEntryId, ctCollectionId))";

	public static final String TABLE_SQL_DROP =
		"drop table CommerceTierPriceEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceTierPriceEntry.minQuantity ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceTierPriceEntry.minQuantity ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMMERCEPRICEENTRYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DISPLAYDATE_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXPIRATIONDATE_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MINQUANTITY_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public CommerceTierPriceEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceTierPriceEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceTierPriceEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceTierPriceEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceTierPriceEntry.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceTierPriceEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceTierPriceEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceTierPriceEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceTierPriceEntry, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommerceTierPriceEntry)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceTierPriceEntry, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceTierPriceEntry, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceTierPriceEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceTierPriceEntry, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceTierPriceEntry, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<CommerceTierPriceEntry, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<CommerceTierPriceEntry, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommerceTierPriceEntry, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<CommerceTierPriceEntry, Object>>();
		Map<String, BiConsumer<CommerceTierPriceEntry, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<CommerceTierPriceEntry, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", CommerceTierPriceEntry::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<CommerceTierPriceEntry, Long>)
				CommerceTierPriceEntry::setMvccVersion);
		attributeGetterFunctions.put(
			"ctCollectionId", CommerceTierPriceEntry::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId",
			(BiConsumer<CommerceTierPriceEntry, Long>)
				CommerceTierPriceEntry::setCtCollectionId);
		attributeGetterFunctions.put("uuid", CommerceTierPriceEntry::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<CommerceTierPriceEntry, String>)
				CommerceTierPriceEntry::setUuid);
		attributeGetterFunctions.put(
			"externalReferenceCode",
			CommerceTierPriceEntry::getExternalReferenceCode);
		attributeSetterBiConsumers.put(
			"externalReferenceCode",
			(BiConsumer<CommerceTierPriceEntry, String>)
				CommerceTierPriceEntry::setExternalReferenceCode);
		attributeGetterFunctions.put(
			"commerceTierPriceEntryId",
			CommerceTierPriceEntry::getCommerceTierPriceEntryId);
		attributeSetterBiConsumers.put(
			"commerceTierPriceEntryId",
			(BiConsumer<CommerceTierPriceEntry, Long>)
				CommerceTierPriceEntry::setCommerceTierPriceEntryId);
		attributeGetterFunctions.put(
			"companyId", CommerceTierPriceEntry::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<CommerceTierPriceEntry, Long>)
				CommerceTierPriceEntry::setCompanyId);
		attributeGetterFunctions.put(
			"userId", CommerceTierPriceEntry::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<CommerceTierPriceEntry, Long>)
				CommerceTierPriceEntry::setUserId);
		attributeGetterFunctions.put(
			"userName", CommerceTierPriceEntry::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<CommerceTierPriceEntry, String>)
				CommerceTierPriceEntry::setUserName);
		attributeGetterFunctions.put(
			"createDate", CommerceTierPriceEntry::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<CommerceTierPriceEntry, Date>)
				CommerceTierPriceEntry::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", CommerceTierPriceEntry::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<CommerceTierPriceEntry, Date>)
				CommerceTierPriceEntry::setModifiedDate);
		attributeGetterFunctions.put(
			"commercePriceEntryId",
			CommerceTierPriceEntry::getCommercePriceEntryId);
		attributeSetterBiConsumers.put(
			"commercePriceEntryId",
			(BiConsumer<CommerceTierPriceEntry, Long>)
				CommerceTierPriceEntry::setCommercePriceEntryId);
		attributeGetterFunctions.put("price", CommerceTierPriceEntry::getPrice);
		attributeSetterBiConsumers.put(
			"price",
			(BiConsumer<CommerceTierPriceEntry, BigDecimal>)
				CommerceTierPriceEntry::setPrice);
		attributeGetterFunctions.put(
			"promoPrice", CommerceTierPriceEntry::getPromoPrice);
		attributeSetterBiConsumers.put(
			"promoPrice",
			(BiConsumer<CommerceTierPriceEntry, BigDecimal>)
				CommerceTierPriceEntry::setPromoPrice);
		attributeGetterFunctions.put(
			"discountDiscovery", CommerceTierPriceEntry::getDiscountDiscovery);
		attributeSetterBiConsumers.put(
			"discountDiscovery",
			(BiConsumer<CommerceTierPriceEntry, Boolean>)
				CommerceTierPriceEntry::setDiscountDiscovery);
		attributeGetterFunctions.put(
			"discountLevel1", CommerceTierPriceEntry::getDiscountLevel1);
		attributeSetterBiConsumers.put(
			"discountLevel1",
			(BiConsumer<CommerceTierPriceEntry, BigDecimal>)
				CommerceTierPriceEntry::setDiscountLevel1);
		attributeGetterFunctions.put(
			"discountLevel2", CommerceTierPriceEntry::getDiscountLevel2);
		attributeSetterBiConsumers.put(
			"discountLevel2",
			(BiConsumer<CommerceTierPriceEntry, BigDecimal>)
				CommerceTierPriceEntry::setDiscountLevel2);
		attributeGetterFunctions.put(
			"discountLevel3", CommerceTierPriceEntry::getDiscountLevel3);
		attributeSetterBiConsumers.put(
			"discountLevel3",
			(BiConsumer<CommerceTierPriceEntry, BigDecimal>)
				CommerceTierPriceEntry::setDiscountLevel3);
		attributeGetterFunctions.put(
			"discountLevel4", CommerceTierPriceEntry::getDiscountLevel4);
		attributeSetterBiConsumers.put(
			"discountLevel4",
			(BiConsumer<CommerceTierPriceEntry, BigDecimal>)
				CommerceTierPriceEntry::setDiscountLevel4);
		attributeGetterFunctions.put(
			"minQuantity", CommerceTierPriceEntry::getMinQuantity);
		attributeSetterBiConsumers.put(
			"minQuantity",
			(BiConsumer<CommerceTierPriceEntry, Integer>)
				CommerceTierPriceEntry::setMinQuantity);
		attributeGetterFunctions.put(
			"displayDate", CommerceTierPriceEntry::getDisplayDate);
		attributeSetterBiConsumers.put(
			"displayDate",
			(BiConsumer<CommerceTierPriceEntry, Date>)
				CommerceTierPriceEntry::setDisplayDate);
		attributeGetterFunctions.put(
			"expirationDate", CommerceTierPriceEntry::getExpirationDate);
		attributeSetterBiConsumers.put(
			"expirationDate",
			(BiConsumer<CommerceTierPriceEntry, Date>)
				CommerceTierPriceEntry::setExpirationDate);
		attributeGetterFunctions.put(
			"lastPublishDate", CommerceTierPriceEntry::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<CommerceTierPriceEntry, Date>)
				CommerceTierPriceEntry::setLastPublishDate);
		attributeGetterFunctions.put(
			"status", CommerceTierPriceEntry::getStatus);
		attributeSetterBiConsumers.put(
			"status",
			(BiConsumer<CommerceTierPriceEntry, Integer>)
				CommerceTierPriceEntry::setStatus);
		attributeGetterFunctions.put(
			"statusByUserId", CommerceTierPriceEntry::getStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<CommerceTierPriceEntry, Long>)
				CommerceTierPriceEntry::setStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName", CommerceTierPriceEntry::getStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<CommerceTierPriceEntry, String>)
				CommerceTierPriceEntry::setStatusByUserName);
		attributeGetterFunctions.put(
			"statusDate", CommerceTierPriceEntry::getStatusDate);
		attributeSetterBiConsumers.put(
			"statusDate",
			(BiConsumer<CommerceTierPriceEntry, Date>)
				CommerceTierPriceEntry::setStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getCommerceTierPriceEntryId() {
		return _commerceTierPriceEntryId;
	}

	@Override
	public void setCommerceTierPriceEntryId(long commerceTierPriceEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceTierPriceEntryId = commerceTierPriceEntryId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCommercePriceEntryId() {
		return _commercePriceEntryId;
	}

	@Override
	public void setCommercePriceEntryId(long commercePriceEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commercePriceEntryId = commercePriceEntryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCommercePriceEntryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("commercePriceEntryId"));
	}

	@JSON
	@Override
	public BigDecimal getPrice() {
		return _price;
	}

	@Override
	public void setPrice(BigDecimal price) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_price = price;
	}

	@JSON
	@Override
	public BigDecimal getPromoPrice() {
		return _promoPrice;
	}

	@Override
	public void setPromoPrice(BigDecimal promoPrice) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_promoPrice = promoPrice;
	}

	@JSON
	@Override
	public boolean getDiscountDiscovery() {
		return _discountDiscovery;
	}

	@JSON
	@Override
	public boolean isDiscountDiscovery() {
		return _discountDiscovery;
	}

	@Override
	public void setDiscountDiscovery(boolean discountDiscovery) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountDiscovery = discountDiscovery;
	}

	@JSON
	@Override
	public BigDecimal getDiscountLevel1() {
		return _discountLevel1;
	}

	@Override
	public void setDiscountLevel1(BigDecimal discountLevel1) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountLevel1 = discountLevel1;
	}

	@JSON
	@Override
	public BigDecimal getDiscountLevel2() {
		return _discountLevel2;
	}

	@Override
	public void setDiscountLevel2(BigDecimal discountLevel2) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountLevel2 = discountLevel2;
	}

	@JSON
	@Override
	public BigDecimal getDiscountLevel3() {
		return _discountLevel3;
	}

	@Override
	public void setDiscountLevel3(BigDecimal discountLevel3) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountLevel3 = discountLevel3;
	}

	@JSON
	@Override
	public BigDecimal getDiscountLevel4() {
		return _discountLevel4;
	}

	@Override
	public void setDiscountLevel4(BigDecimal discountLevel4) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountLevel4 = discountLevel4;
	}

	@JSON
	@Override
	public int getMinQuantity() {
		return _minQuantity;
	}

	@Override
	public void setMinQuantity(int minQuantity) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_minQuantity = minQuantity;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalMinQuantity() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("minQuantity"));
	}

	@JSON
	@Override
	public Date getDisplayDate() {
		return _displayDate;
	}

	@Override
	public void setDisplayDate(Date displayDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_displayDate = displayDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalDisplayDate() {
		return getColumnOriginalValue("displayDate");
	}

	@JSON
	@Override
	public Date getExpirationDate() {
		return _expirationDate;
	}

	@Override
	public void setExpirationDate(Date expirationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_expirationDate = expirationDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalExpirationDate() {
		return getColumnOriginalValue("expirationDate");
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(CommerceTierPriceEntry.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceTierPriceEntry.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceTierPriceEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceTierPriceEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceTierPriceEntryImpl commerceTierPriceEntryImpl =
			new CommerceTierPriceEntryImpl();

		commerceTierPriceEntryImpl.setMvccVersion(getMvccVersion());
		commerceTierPriceEntryImpl.setCtCollectionId(getCtCollectionId());
		commerceTierPriceEntryImpl.setUuid(getUuid());
		commerceTierPriceEntryImpl.setExternalReferenceCode(
			getExternalReferenceCode());
		commerceTierPriceEntryImpl.setCommerceTierPriceEntryId(
			getCommerceTierPriceEntryId());
		commerceTierPriceEntryImpl.setCompanyId(getCompanyId());
		commerceTierPriceEntryImpl.setUserId(getUserId());
		commerceTierPriceEntryImpl.setUserName(getUserName());
		commerceTierPriceEntryImpl.setCreateDate(getCreateDate());
		commerceTierPriceEntryImpl.setModifiedDate(getModifiedDate());
		commerceTierPriceEntryImpl.setCommercePriceEntryId(
			getCommercePriceEntryId());
		commerceTierPriceEntryImpl.setPrice(getPrice());
		commerceTierPriceEntryImpl.setPromoPrice(getPromoPrice());
		commerceTierPriceEntryImpl.setDiscountDiscovery(isDiscountDiscovery());
		commerceTierPriceEntryImpl.setDiscountLevel1(getDiscountLevel1());
		commerceTierPriceEntryImpl.setDiscountLevel2(getDiscountLevel2());
		commerceTierPriceEntryImpl.setDiscountLevel3(getDiscountLevel3());
		commerceTierPriceEntryImpl.setDiscountLevel4(getDiscountLevel4());
		commerceTierPriceEntryImpl.setMinQuantity(getMinQuantity());
		commerceTierPriceEntryImpl.setDisplayDate(getDisplayDate());
		commerceTierPriceEntryImpl.setExpirationDate(getExpirationDate());
		commerceTierPriceEntryImpl.setLastPublishDate(getLastPublishDate());
		commerceTierPriceEntryImpl.setStatus(getStatus());
		commerceTierPriceEntryImpl.setStatusByUserId(getStatusByUserId());
		commerceTierPriceEntryImpl.setStatusByUserName(getStatusByUserName());
		commerceTierPriceEntryImpl.setStatusDate(getStatusDate());

		commerceTierPriceEntryImpl.resetOriginalValues();

		return commerceTierPriceEntryImpl;
	}

	@Override
	public CommerceTierPriceEntry cloneWithOriginalValues() {
		CommerceTierPriceEntryImpl commerceTierPriceEntryImpl =
			new CommerceTierPriceEntryImpl();

		commerceTierPriceEntryImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		commerceTierPriceEntryImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		commerceTierPriceEntryImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		commerceTierPriceEntryImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		commerceTierPriceEntryImpl.setCommerceTierPriceEntryId(
			this.<Long>getColumnOriginalValue("commerceTierPriceEntryId"));
		commerceTierPriceEntryImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		commerceTierPriceEntryImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		commerceTierPriceEntryImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		commerceTierPriceEntryImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		commerceTierPriceEntryImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		commerceTierPriceEntryImpl.setCommercePriceEntryId(
			this.<Long>getColumnOriginalValue("commercePriceEntryId"));
		commerceTierPriceEntryImpl.setPrice(
			this.<BigDecimal>getColumnOriginalValue("price"));
		commerceTierPriceEntryImpl.setPromoPrice(
			this.<BigDecimal>getColumnOriginalValue("promoPrice"));
		commerceTierPriceEntryImpl.setDiscountDiscovery(
			this.<Boolean>getColumnOriginalValue("discountDiscovery"));
		commerceTierPriceEntryImpl.setDiscountLevel1(
			this.<BigDecimal>getColumnOriginalValue("discountLevel1"));
		commerceTierPriceEntryImpl.setDiscountLevel2(
			this.<BigDecimal>getColumnOriginalValue("discountLevel2"));
		commerceTierPriceEntryImpl.setDiscountLevel3(
			this.<BigDecimal>getColumnOriginalValue("discountLevel3"));
		commerceTierPriceEntryImpl.setDiscountLevel4(
			this.<BigDecimal>getColumnOriginalValue("discountLevel4"));
		commerceTierPriceEntryImpl.setMinQuantity(
			this.<Integer>getColumnOriginalValue("minQuantity"));
		commerceTierPriceEntryImpl.setDisplayDate(
			this.<Date>getColumnOriginalValue("displayDate"));
		commerceTierPriceEntryImpl.setExpirationDate(
			this.<Date>getColumnOriginalValue("expirationDate"));
		commerceTierPriceEntryImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));
		commerceTierPriceEntryImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));
		commerceTierPriceEntryImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		commerceTierPriceEntryImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		commerceTierPriceEntryImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return commerceTierPriceEntryImpl;
	}

	@Override
	public int compareTo(CommerceTierPriceEntry commerceTierPriceEntry) {
		int value = 0;

		if (getMinQuantity() < commerceTierPriceEntry.getMinQuantity()) {
			value = -1;
		}
		else if (getMinQuantity() > commerceTierPriceEntry.getMinQuantity()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceTierPriceEntry)) {
			return false;
		}

		CommerceTierPriceEntry commerceTierPriceEntry =
			(CommerceTierPriceEntry)object;

		long primaryKey = commerceTierPriceEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceTierPriceEntry> toCacheModel() {
		CommerceTierPriceEntryCacheModel commerceTierPriceEntryCacheModel =
			new CommerceTierPriceEntryCacheModel();

		commerceTierPriceEntryCacheModel.mvccVersion = getMvccVersion();

		commerceTierPriceEntryCacheModel.ctCollectionId = getCtCollectionId();

		commerceTierPriceEntryCacheModel.uuid = getUuid();

		String uuid = commerceTierPriceEntryCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commerceTierPriceEntryCacheModel.uuid = null;
		}

		commerceTierPriceEntryCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			commerceTierPriceEntryCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			commerceTierPriceEntryCacheModel.externalReferenceCode = null;
		}

		commerceTierPriceEntryCacheModel.commerceTierPriceEntryId =
			getCommerceTierPriceEntryId();

		commerceTierPriceEntryCacheModel.companyId = getCompanyId();

		commerceTierPriceEntryCacheModel.userId = getUserId();

		commerceTierPriceEntryCacheModel.userName = getUserName();

		String userName = commerceTierPriceEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceTierPriceEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceTierPriceEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceTierPriceEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceTierPriceEntryCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			commerceTierPriceEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceTierPriceEntryCacheModel.commercePriceEntryId =
			getCommercePriceEntryId();

		commerceTierPriceEntryCacheModel.price = getPrice();

		commerceTierPriceEntryCacheModel.promoPrice = getPromoPrice();

		commerceTierPriceEntryCacheModel.discountDiscovery =
			isDiscountDiscovery();

		commerceTierPriceEntryCacheModel.discountLevel1 = getDiscountLevel1();

		commerceTierPriceEntryCacheModel.discountLevel2 = getDiscountLevel2();

		commerceTierPriceEntryCacheModel.discountLevel3 = getDiscountLevel3();

		commerceTierPriceEntryCacheModel.discountLevel4 = getDiscountLevel4();

		commerceTierPriceEntryCacheModel.minQuantity = getMinQuantity();

		Date displayDate = getDisplayDate();

		if (displayDate != null) {
			commerceTierPriceEntryCacheModel.displayDate =
				displayDate.getTime();
		}
		else {
			commerceTierPriceEntryCacheModel.displayDate = Long.MIN_VALUE;
		}

		Date expirationDate = getExpirationDate();

		if (expirationDate != null) {
			commerceTierPriceEntryCacheModel.expirationDate =
				expirationDate.getTime();
		}
		else {
			commerceTierPriceEntryCacheModel.expirationDate = Long.MIN_VALUE;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			commerceTierPriceEntryCacheModel.lastPublishDate =
				lastPublishDate.getTime();
		}
		else {
			commerceTierPriceEntryCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		commerceTierPriceEntryCacheModel.status = getStatus();

		commerceTierPriceEntryCacheModel.statusByUserId = getStatusByUserId();

		commerceTierPriceEntryCacheModel.statusByUserName =
			getStatusByUserName();

		String statusByUserName =
			commerceTierPriceEntryCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			commerceTierPriceEntryCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			commerceTierPriceEntryCacheModel.statusDate = statusDate.getTime();
		}
		else {
			commerceTierPriceEntryCacheModel.statusDate = Long.MIN_VALUE;
		}

		return commerceTierPriceEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceTierPriceEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceTierPriceEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceTierPriceEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommerceTierPriceEntry)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceTierPriceEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceTierPriceEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceTierPriceEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply((CommerceTierPriceEntry)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CommerceTierPriceEntry>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					CommerceTierPriceEntry.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private String _externalReferenceCode;
	private long _commerceTierPriceEntryId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _commercePriceEntryId;
	private BigDecimal _price;
	private BigDecimal _promoPrice;
	private boolean _discountDiscovery;
	private BigDecimal _discountLevel1;
	private BigDecimal _discountLevel2;
	private BigDecimal _discountLevel3;
	private BigDecimal _discountLevel4;
	private int _minQuantity;
	private Date _displayDate;
	private Date _expirationDate;
	private Date _lastPublishDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommerceTierPriceEntry, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommerceTierPriceEntry)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put(
			"commerceTierPriceEntryId", _commerceTierPriceEntryId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"commercePriceEntryId", _commercePriceEntryId);
		_columnOriginalValues.put("price", _price);
		_columnOriginalValues.put("promoPrice", _promoPrice);
		_columnOriginalValues.put("discountDiscovery", _discountDiscovery);
		_columnOriginalValues.put("discountLevel1", _discountLevel1);
		_columnOriginalValues.put("discountLevel2", _discountLevel2);
		_columnOriginalValues.put("discountLevel3", _discountLevel3);
		_columnOriginalValues.put("discountLevel4", _discountLevel4);
		_columnOriginalValues.put("minQuantity", _minQuantity);
		_columnOriginalValues.put("displayDate", _displayDate);
		_columnOriginalValues.put("expirationDate", _expirationDate);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("externalReferenceCode", 8L);

		columnBitmasks.put("commerceTierPriceEntryId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("userName", 128L);

		columnBitmasks.put("createDate", 256L);

		columnBitmasks.put("modifiedDate", 512L);

		columnBitmasks.put("commercePriceEntryId", 1024L);

		columnBitmasks.put("price", 2048L);

		columnBitmasks.put("promoPrice", 4096L);

		columnBitmasks.put("discountDiscovery", 8192L);

		columnBitmasks.put("discountLevel1", 16384L);

		columnBitmasks.put("discountLevel2", 32768L);

		columnBitmasks.put("discountLevel3", 65536L);

		columnBitmasks.put("discountLevel4", 131072L);

		columnBitmasks.put("minQuantity", 262144L);

		columnBitmasks.put("displayDate", 524288L);

		columnBitmasks.put("expirationDate", 1048576L);

		columnBitmasks.put("lastPublishDate", 2097152L);

		columnBitmasks.put("status", 4194304L);

		columnBitmasks.put("statusByUserId", 8388608L);

		columnBitmasks.put("statusByUserName", 16777216L);

		columnBitmasks.put("statusDate", 33554432L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommerceTierPriceEntry _escapedModel;

}