/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.internal.portlet.action;

import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommerceTierPriceEntry;
import com.liferay.commerce.price.list.portlet.action.CommercePriceListActionHelper;
import com.liferay.commerce.price.list.service.CommercePriceEntryService;
import com.liferay.commerce.price.list.service.CommercePriceListService;
import com.liferay.commerce.price.list.service.CommerceTierPriceEntryService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommercePriceListActionHelper.class})
public class CommercePriceListActionHelperImpl
implements CommercePriceListActionHelper {
    @Reference
    private CommercePriceEntryService _commercePriceEntryService;
    @Reference
    private CommercePriceListService _commercePriceListService;
    @Reference
    private CommerceTierPriceEntryService _commerceTierPriceEntryService;

    public List<CommercePriceEntry> getCommercePriceEntries(PortletRequest portletRequest) throws PortalException {
        long[] commercePriceEntryIds;
        ArrayList<CommercePriceEntry> commercePriceEntries = new ArrayList<CommercePriceEntry>();
        for (long commercePriceEntryId : commercePriceEntryIds = ParamUtil.getLongValues((PortletRequest)portletRequest, (String)"rowIds")) {
            CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.fetchCommercePriceEntry(commercePriceEntryId);
            if (commercePriceEntry == null) continue;
            commercePriceEntries.add(commercePriceEntry);
        }
        return commercePriceEntries;
    }

    public CommercePriceEntry getCommercePriceEntry(RenderRequest renderRequest) throws PortalException {
        CommercePriceEntry commercePriceEntry = (CommercePriceEntry)renderRequest.getAttribute("COMMERCE_PRICE_ENTRY");
        if (commercePriceEntry != null) {
            return commercePriceEntry;
        }
        long commercePriceEntryId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"commercePriceEntryId");
        if (commercePriceEntryId > 0L) {
            commercePriceEntry = this._commercePriceEntryService.fetchCommercePriceEntry(commercePriceEntryId);
        }
        if (commercePriceEntry != null) {
            renderRequest.setAttribute("COMMERCE_PRICE_ENTRY", (Object)commercePriceEntry);
        }
        return commercePriceEntry;
    }

    public CommercePriceList getCommercePriceList(PortletRequest portletRequest) throws PortalException {
        CommercePriceList commercePriceList = (CommercePriceList)portletRequest.getAttribute("COMMERCE_PRICE_LIST");
        if (commercePriceList != null) {
            return commercePriceList;
        }
        long commercePriceListId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"commercePriceListId");
        if (commercePriceListId > 0L) {
            commercePriceList = this._commercePriceListService.fetchCommercePriceList(commercePriceListId);
        }
        if (commercePriceList != null) {
            portletRequest.setAttribute("COMMERCE_PRICE_LIST", (Object)commercePriceList);
        }
        return commercePriceList;
    }

    public List<CommercePriceList> getCommercePriceLists(PortletRequest portletRequest) throws PortalException {
        long[] commercePriceListIds;
        ArrayList<CommercePriceList> commercePriceLists = new ArrayList<CommercePriceList>();
        for (long commercePriceListId : commercePriceListIds = ParamUtil.getLongValues((PortletRequest)portletRequest, (String)"rowIds")) {
            CommercePriceList commercePriceList = this._commercePriceListService.fetchCommercePriceList(commercePriceListId);
            if (commercePriceList == null) continue;
            commercePriceLists.add(commercePriceList);
        }
        return commercePriceLists;
    }

    public List<CommerceTierPriceEntry> getCommerceTierPriceEntries(PortletRequest portletRequest) throws PortalException {
        long[] commerceTierPriceEntryIds;
        ArrayList<CommerceTierPriceEntry> commerceTierPriceEntries = new ArrayList<CommerceTierPriceEntry>();
        for (long commerceTierPriceEntryId : commerceTierPriceEntryIds = ParamUtil.getLongValues((PortletRequest)portletRequest, (String)"rowIds")) {
            CommerceTierPriceEntry commerceTierPriceEntry = this._commerceTierPriceEntryService.fetchCommerceTierPriceEntry(commerceTierPriceEntryId);
            if (commerceTierPriceEntry == null) continue;
            commerceTierPriceEntries.add(commerceTierPriceEntry);
        }
        return commerceTierPriceEntries;
    }

    public CommerceTierPriceEntry getCommerceTierPriceEntry(RenderRequest renderRequest) throws PortalException {
        long commerceTierPriceEntryId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"commerceTierPriceEntryId");
        return this._commerceTierPriceEntryService.fetchCommerceTierPriceEntry(commerceTierPriceEntryId);
    }
}

