/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.internal.search;

import com.liferay.commerce.price.list.model.CommerceTierPriceEntry;
import com.liferay.commerce.price.list.service.CommerceTierPriceEntryLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={Indexer.class})
public class CommerceTierPriceEntryIndexer
extends BaseIndexer<CommerceTierPriceEntry> {
    public static final String CLASS_NAME = CommerceTierPriceEntry.class.getName();
    public static final String FIELD_COMMERCE_PRICE_ENTRY_ID = "commercePriceEntryId";
    public static final String FIELD_EXTERNAL_REFERENCE_CODE = "externalReferenceCode";
    private static final Log _log = LogFactoryUtil.getLog(CommerceTierPriceEntryIndexer.class);
    @Reference
    private CommerceTierPriceEntryLocalService _commerceTierPriceEntryLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CommerceTierPriceEntryIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "groupId", "modified", "scopeGroupId", "uid"});
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long commercePriceEntryId = GetterUtil.getLong((Object)searchContext.getAttribute(FIELD_COMMERCE_PRICE_ENTRY_ID));
        if (commercePriceEntryId > 0L) {
            contextBooleanFilter.addRequiredTerm(FIELD_COMMERCE_PRICE_ENTRY_ID, commercePriceEntryId);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        this.addSearchTerm(searchQuery, searchContext, FIELD_EXTERNAL_REFERENCE_CODE, false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(CommerceTierPriceEntry commerceTierPriceEntry) throws Exception {
        this.deleteDocument(commerceTierPriceEntry.getCompanyId(), commerceTierPriceEntry.getCommercePriceEntryId());
    }

    protected Document doGetDocument(CommerceTierPriceEntry commerceTierPriceEntry) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing tier price entry " + commerceTierPriceEntry));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commerceTierPriceEntry);
        document.addKeyword(FIELD_COMMERCE_PRICE_ENTRY_ID, commerceTierPriceEntry.getCommercePriceEntryId());
        document.addKeyword(FIELD_EXTERNAL_REFERENCE_CODE, commerceTierPriceEntry.getExternalReferenceCode());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + commerceTierPriceEntry + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, FIELD_COMMERCE_PRICE_ENTRY_ID, FIELD_COMMERCE_PRICE_ENTRY_ID);
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CommerceTierPriceEntry commerceTierPriceEntry) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), commerceTierPriceEntry.getCompanyId(), this.getDocument(commerceTierPriceEntry), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._commerceTierPriceEntryLocalService.getCommerceTierPriceEntry(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this._reindexCommerceTierPriceEntries(companyId);
    }

    private void _reindexCommerceTierPriceEntries(long companyId) throws Exception {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commerceTierPriceEntryLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(commerceTierPriceEntry -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(commerceTierPriceEntry)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    long commerceTierPriceEntryId = commerceTierPriceEntry.getCommerceTierPriceEntryId();
                    _log.warn((Object)("Unable to index commerce tier price entry " + commerceTierPriceEntryId), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

