/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.service.impl;

import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListAccountRel;
import com.liferay.commerce.price.list.service.base.CommercePriceListAccountRelLocalServiceBaseImpl;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.price.list.model.CommercePriceListAccountRel"}, service={AopService.class})
public class CommercePriceListAccountRelLocalServiceImpl
extends CommercePriceListAccountRelLocalServiceBaseImpl {
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public CommercePriceListAccountRel addCommercePriceListAccountRel(long userId, long commercePriceListId, long commerceAccountId, int order, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        CommercePriceListAccountRel commercePriceListAccountRel = this.commercePriceListAccountRelPersistence.create(this.counterLocalService.increment());
        commercePriceListAccountRel.setCompanyId(user.getCompanyId());
        commercePriceListAccountRel.setUserId(user.getUserId());
        commercePriceListAccountRel.setUserName(user.getFullName());
        commercePriceListAccountRel.setCommerceAccountId(commerceAccountId);
        commercePriceListAccountRel.setCommercePriceListId(commercePriceListId);
        commercePriceListAccountRel.setOrder(order);
        commercePriceListAccountRel.setExpandoBridgeAttributes(serviceContext);
        commercePriceListAccountRel = (CommercePriceListAccountRel)this.commercePriceListAccountRelPersistence.update((BaseModel)commercePriceListAccountRel);
        this.reindexCommercePriceList(commercePriceListId);
        return commercePriceListAccountRel;
    }

    @Override
    @SystemEvent(type=1)
    public CommercePriceListAccountRel deleteCommercePriceListAccountRel(CommercePriceListAccountRel commercePriceListAccountRel) throws PortalException {
        this.commercePriceListAccountRelPersistence.remove((BaseModel)commercePriceListAccountRel);
        this._expandoRowLocalService.deleteRows(commercePriceListAccountRel.getCommercePriceListAccountRelId());
        this.reindexCommercePriceList(commercePriceListAccountRel.getCommercePriceListId());
        return commercePriceListAccountRel;
    }

    @Override
    public CommercePriceListAccountRel deleteCommercePriceListAccountRel(long commercePriceListAccountRelId) throws PortalException {
        CommercePriceListAccountRel commercePriceListAccountRel = this.commercePriceListAccountRelPersistence.findByPrimaryKey(commercePriceListAccountRelId);
        return this.commercePriceListAccountRelLocalService.deleteCommercePriceListAccountRel(commercePriceListAccountRel);
    }

    public void deleteCommercePriceListAccountRels(long commercePriceListId) throws PortalException {
        List commercePriceListAccountRels = this.commercePriceListAccountRelPersistence.findByCommercePriceListId(commercePriceListId);
        for (CommercePriceListAccountRel commercePriceListAccountRel : commercePriceListAccountRels) {
            this.commercePriceListAccountRelLocalService.deleteCommercePriceListAccountRel(commercePriceListAccountRel);
        }
    }

    public void deleteCommercePriceListAccountRelsByCommercePriceListId(long commercePriceListId) throws PortalException {
        List commercePriceListAccountRels = this.commercePriceListAccountRelPersistence.findByCommercePriceListId(commercePriceListId);
        for (CommercePriceListAccountRel commercePriceListAccountRel : commercePriceListAccountRels) {
            this.commercePriceListAccountRelLocalService.deleteCommercePriceListAccountRel(commercePriceListAccountRel);
        }
    }

    public CommercePriceListAccountRel fetchCommercePriceListAccountRel(long commerceAccountId, long commercePriceListId) {
        return this.commercePriceListAccountRelPersistence.fetchByCAI_CPI(commerceAccountId, commercePriceListId);
    }

    public List<CommercePriceListAccountRel> getCommercePriceListAccountRels(long commercePriceListId) {
        return this.commercePriceListAccountRelPersistence.findByCommercePriceListId(commercePriceListId);
    }

    public List<CommercePriceListAccountRel> getCommercePriceListAccountRels(long commercePriceListId, int start, int end, OrderByComparator<CommercePriceListAccountRel> orderByComparator) {
        return this.commercePriceListAccountRelPersistence.findByCommercePriceListId(commercePriceListId, start, end, orderByComparator);
    }

    public List<CommercePriceListAccountRel> getCommercePriceListAccountRels(long commercePriceListId, String name, int start, int end) {
        return this.commercePriceListAccountRelFinder.findByCommercePriceListId(commercePriceListId, name, start, end);
    }

    public int getCommercePriceListAccountRelsCount(long commercePriceListId) {
        return this.commercePriceListAccountRelPersistence.countByCommercePriceListId(commercePriceListId);
    }

    public int getCommercePriceListAccountRelsCount(long commercePriceListId, String name) {
        return this.commercePriceListAccountRelFinder.countByCommercePriceListId(commercePriceListId, name);
    }

    protected void reindexCommercePriceList(long commercePriceListId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommercePriceList.class);
        indexer.reindex(CommercePriceList.class.getName(), commercePriceListId);
    }
}

