/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.service.impl;

import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListAccountRel;
import com.liferay.commerce.price.list.service.base.CommercePriceListAccountRelServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommercePriceListAccountRel"}, service={AopService.class})
public class CommercePriceListAccountRelServiceImpl
extends CommercePriceListAccountRelServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.commerce.price.list.model.CommercePriceList)")
    private ModelResourcePermission<CommercePriceList> _commercePriceListModelResourcePermission;

    public CommercePriceListAccountRel addCommercePriceListAccountRel(long commercePriceListId, long commerceAccountId, int order, ServiceContext serviceContext) throws PortalException {
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "UPDATE");
        return this.commercePriceListAccountRelLocalService.addCommercePriceListAccountRel(this.getUserId(), commercePriceListId, commerceAccountId, order, serviceContext);
    }

    public void deleteCommercePriceListAccountRel(long commercePriceListAccountRelId) throws PortalException {
        CommercePriceListAccountRel commercePriceListAccountRel = this.commercePriceListAccountRelLocalService.getCommercePriceListAccountRel(commercePriceListAccountRelId);
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListAccountRel.getCommercePriceListId(), "UPDATE");
        this.commercePriceListAccountRelLocalService.deleteCommercePriceListAccountRel(commercePriceListAccountRel);
    }

    public void deleteCommercePriceListAccountRelsByCommercePriceListId(long commercePriceListId) throws PortalException {
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "UPDATE");
        this.commercePriceListAccountRelLocalService.deleteCommercePriceListAccountRelsByCommercePriceListId(commercePriceListId);
    }

    public CommercePriceListAccountRel fetchCommercePriceListAccountRel(long commercePriceListId, long commerceAccountId) throws PortalException {
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "VIEW");
        return this.commercePriceListAccountRelLocalService.fetchCommercePriceListAccountRel(commercePriceListId, commerceAccountId);
    }

    public CommercePriceListAccountRel getCommercePriceListAccountRel(long commercePriceListAccountRelId) throws PortalException {
        CommercePriceListAccountRel commercePriceListAccountRel = this.commercePriceListAccountRelLocalService.getCommercePriceListAccountRel(commercePriceListAccountRelId);
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListAccountRel.getCommercePriceListId(), "VIEW");
        return commercePriceListAccountRel;
    }

    public List<CommercePriceListAccountRel> getCommercePriceListAccountRels(long commercePriceListId) throws PortalException {
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "VIEW");
        return this.commercePriceListAccountRelLocalService.getCommercePriceListAccountRels(commercePriceListId);
    }

    public List<CommercePriceListAccountRel> getCommercePriceListAccountRels(long commercePriceListId, int start, int end, OrderByComparator<CommercePriceListAccountRel> orderByComparator) throws PortalException {
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "VIEW");
        return this.commercePriceListAccountRelLocalService.getCommercePriceListAccountRels(commercePriceListId, start, end, orderByComparator);
    }

    public List<CommercePriceListAccountRel> getCommercePriceListAccountRels(long commercePriceListId, String name, int start, int end) {
        return this.commercePriceListAccountRelFinder.findByCommercePriceListId(commercePriceListId, name, start, end, true);
    }

    public int getCommercePriceListAccountRelsCount(long commercePriceListId) throws PortalException {
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "VIEW");
        return this.commercePriceListAccountRelLocalService.getCommercePriceListAccountRelsCount(commercePriceListId);
    }

    public int getCommercePriceListAccountRelsCount(long commercePriceListId, String name) {
        return this.commercePriceListAccountRelFinder.countByCommercePriceListId(commercePriceListId, name, true);
    }
}

