/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.service.impl;

import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListChannelRel;
import com.liferay.commerce.price.list.service.base.CommercePriceListChannelRelLocalServiceBaseImpl;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.price.list.model.CommercePriceListChannelRel"}, service={AopService.class})
public class CommercePriceListChannelRelLocalServiceImpl
extends CommercePriceListChannelRelLocalServiceBaseImpl {
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public CommercePriceListChannelRel addCommercePriceListChannelRel(long userId, long commercePriceListId, long commerceChannelId, int order, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        CommercePriceListChannelRel commercePriceListChannelRel = this.commercePriceListChannelRelPersistence.create(this.counterLocalService.increment());
        commercePriceListChannelRel.setCompanyId(user.getCompanyId());
        commercePriceListChannelRel.setUserId(user.getUserId());
        commercePriceListChannelRel.setUserName(user.getFullName());
        commercePriceListChannelRel.setCommerceChannelId(commerceChannelId);
        commercePriceListChannelRel.setCommercePriceListId(commercePriceListId);
        commercePriceListChannelRel.setOrder(order);
        commercePriceListChannelRel.setExpandoBridgeAttributes(serviceContext);
        commercePriceListChannelRel = (CommercePriceListChannelRel)this.commercePriceListChannelRelPersistence.update((BaseModel)commercePriceListChannelRel);
        this.reindexCommercePriceList(commercePriceListId);
        return commercePriceListChannelRel;
    }

    @Override
    @SystemEvent(type=1)
    public CommercePriceListChannelRel deleteCommercePriceListChannelRel(CommercePriceListChannelRel commercePriceListChannelRel) throws PortalException {
        this.commercePriceListChannelRelPersistence.remove((BaseModel)commercePriceListChannelRel);
        this._expandoRowLocalService.deleteRows(commercePriceListChannelRel.getCommercePriceListChannelRelId());
        this.reindexCommercePriceList(commercePriceListChannelRel.getCommercePriceListId());
        return commercePriceListChannelRel;
    }

    @Override
    public CommercePriceListChannelRel deleteCommercePriceListChannelRel(long commercePriceListChannelRelId) throws PortalException {
        CommercePriceListChannelRel commercePriceListChannelRel = this.commercePriceListChannelRelPersistence.findByPrimaryKey(commercePriceListChannelRelId);
        return this.commercePriceListChannelRelLocalService.deleteCommercePriceListChannelRel(commercePriceListChannelRel);
    }

    public void deleteCommercePriceListChannelRels(long commercePriceListId) throws PortalException {
        List commercePriceListChannelRels = this.commercePriceListChannelRelPersistence.findByCommercePriceListId(commercePriceListId);
        for (CommercePriceListChannelRel commercePriceListChannelRel : commercePriceListChannelRels) {
            this.commercePriceListChannelRelLocalService.deleteCommercePriceListChannelRel(commercePriceListChannelRel);
        }
    }

    public CommercePriceListChannelRel fetchCommercePriceListChannelRel(long commerceChannelId, long commercePriceListId) {
        return this.commercePriceListChannelRelPersistence.fetchByCCI_CPI(commerceChannelId, commercePriceListId);
    }

    public List<CommercePriceListChannelRel> getCommercePriceListChannelRels(long commercePriceListId) {
        return this.commercePriceListChannelRelPersistence.findByCommercePriceListId(commercePriceListId);
    }

    public List<CommercePriceListChannelRel> getCommercePriceListChannelRels(long commercePriceListId, int start, int end, OrderByComparator<CommercePriceListChannelRel> orderByComparator) {
        return this.commercePriceListChannelRelPersistence.findByCommercePriceListId(commercePriceListId, start, end, orderByComparator);
    }

    public List<CommercePriceListChannelRel> getCommercePriceListChannelRels(long commercePriceListId, String name, int start, int end) {
        return this.commercePriceListChannelRelFinder.findByCommercePriceListId(commercePriceListId, name, start, end);
    }

    public int getCommercePriceListChannelRelsCount(long commercePriceListId) {
        return this.commercePriceListChannelRelPersistence.countByCommercePriceListId(commercePriceListId);
    }

    public int getCommercePriceListChannelRelsCount(long commercePriceListId, String name) {
        return this.commercePriceListChannelRelFinder.countByCommercePriceListId(commercePriceListId, name);
    }

    protected void reindexCommercePriceList(long commercePriceListId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommercePriceList.class);
        indexer.reindex(CommercePriceList.class.getName(), commercePriceListId);
    }
}

