/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.service.impl;

import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListChannelRel;
import com.liferay.commerce.price.list.service.base.CommercePriceListChannelRelServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommercePriceListChannelRel"}, service={AopService.class})
public class CommercePriceListChannelRelServiceImpl
extends CommercePriceListChannelRelServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.commerce.price.list.model.CommercePriceList)")
    private ModelResourcePermission<CommercePriceList> _commercePriceListModelResourcePermission;

    public CommercePriceListChannelRel addCommercePriceListChannelRel(long commercePriceListId, long commerceChannelId, int order, ServiceContext serviceContext) throws PortalException {
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "UPDATE");
        return this.commercePriceListChannelRelLocalService.addCommercePriceListChannelRel(this.getUserId(), commercePriceListId, commerceChannelId, order, serviceContext);
    }

    public void deleteCommercePriceListChannelRel(long commercePriceListChannelRelId) throws PortalException {
        CommercePriceListChannelRel commercePriceListChannelRel = this.commercePriceListChannelRelLocalService.getCommercePriceListChannelRel(commercePriceListChannelRelId);
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListChannelRel.getCommercePriceListId(), "UPDATE");
        this.commercePriceListChannelRelLocalService.deleteCommercePriceListChannelRel(commercePriceListChannelRel);
    }

    public void deleteCommercePriceListChannelRelsByCommercePriceListId(long commercePriceListId) throws PortalException {
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "UPDATE");
        this.commercePriceListChannelRelLocalService.deleteCommercePriceListChannelRels(commercePriceListId);
    }

    public CommercePriceListChannelRel fetchCommercePriceListChannelRel(long commerceChannelId, long commercePriceListId) throws PortalException {
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "VIEW");
        return this.commercePriceListChannelRelLocalService.fetchCommercePriceListChannelRel(commerceChannelId, commercePriceListId);
    }

    public CommercePriceListChannelRel getCommercePriceListChannelRel(long commercePriceListChannelRelId) throws PortalException {
        CommercePriceListChannelRel commercePriceListChannelRel = this.commercePriceListChannelRelLocalService.getCommercePriceListChannelRel(commercePriceListChannelRelId);
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListChannelRel.getCommercePriceListId(), "VIEW");
        return commercePriceListChannelRel;
    }

    public List<CommercePriceListChannelRel> getCommercePriceListChannelRels(long commercePriceListId) throws PortalException {
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "VIEW");
        return this.commercePriceListChannelRelLocalService.getCommercePriceListChannelRels(commercePriceListId);
    }

    public List<CommercePriceListChannelRel> getCommercePriceListChannelRels(long commercePriceListId, int start, int end, OrderByComparator<CommercePriceListChannelRel> orderByComparator) throws PortalException {
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "VIEW");
        return this.commercePriceListChannelRelLocalService.getCommercePriceListChannelRels(commercePriceListId, start, end, orderByComparator);
    }

    public List<CommercePriceListChannelRel> getCommercePriceListChannelRels(long commercePriceListId, String name, int start, int end) {
        return this.commercePriceListChannelRelFinder.findByCommercePriceListId(commercePriceListId, name, start, end, true);
    }

    public int getCommercePriceListChannelRelsCount(long commercePriceListId) throws PortalException {
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "VIEW");
        return this.commercePriceListChannelRelLocalService.getCommercePriceListChannelRelsCount(commercePriceListId);
    }

    public int getCommercePriceListChannelRelsCount(long commercePriceListId, String name) {
        return this.commercePriceListChannelRelFinder.countByCommercePriceListId(commercePriceListId, name, true);
    }
}

