/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.service.impl;

import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListDiscountRel;
import com.liferay.commerce.price.list.service.base.CommercePriceListDiscountRelLocalServiceBaseImpl;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.price.list.model.CommercePriceListDiscountRel"}, service={AopService.class})
public class CommercePriceListDiscountRelLocalServiceImpl
extends CommercePriceListDiscountRelLocalServiceBaseImpl {
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public CommercePriceListDiscountRel addCommercePriceListDiscountRel(long userId, long commercePriceListId, long commerceDiscountId, int order, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        CommercePriceListDiscountRel commercePriceListDiscountRel = this.commercePriceListDiscountRelPersistence.create(this.counterLocalService.increment());
        commercePriceListDiscountRel.setCompanyId(user.getCompanyId());
        commercePriceListDiscountRel.setUserId(user.getUserId());
        commercePriceListDiscountRel.setUserName(user.getFullName());
        commercePriceListDiscountRel.setCommerceDiscountId(commerceDiscountId);
        commercePriceListDiscountRel.setCommercePriceListId(commercePriceListId);
        commercePriceListDiscountRel.setOrder(order);
        commercePriceListDiscountRel.setExpandoBridgeAttributes(serviceContext);
        this.reindexPriceList(commercePriceListId);
        return (CommercePriceListDiscountRel)this.commercePriceListDiscountRelPersistence.update((BaseModel)commercePriceListDiscountRel);
    }

    @Override
    @SystemEvent(type=1)
    public CommercePriceListDiscountRel deleteCommercePriceListDiscountRel(CommercePriceListDiscountRel commercePriceListDiscountRel) throws PortalException {
        this.commercePriceListDiscountRelPersistence.remove((BaseModel)commercePriceListDiscountRel);
        this._expandoRowLocalService.deleteRows(commercePriceListDiscountRel.getCommercePriceListDiscountRelId());
        this.reindexPriceList(commercePriceListDiscountRel.getCommercePriceListId());
        return commercePriceListDiscountRel;
    }

    @Override
    public CommercePriceListDiscountRel deleteCommercePriceListDiscountRel(long commercePriceListDiscountRelId) throws PortalException {
        CommercePriceListDiscountRel commercePriceListDiscountRel = this.commercePriceListDiscountRelPersistence.findByPrimaryKey(commercePriceListDiscountRelId);
        return this.commercePriceListDiscountRelLocalService.deleteCommercePriceListDiscountRel(commercePriceListDiscountRel);
    }

    public void deleteCommercePriceListDiscountRels(long commercePriceListId) {
        this.commercePriceListDiscountRelPersistence.removeByCommercePriceListId(commercePriceListId);
    }

    public CommercePriceListDiscountRel fetchCommercePriceListDiscountRel(long commerceDiscountId, long commercePriceListId) {
        return this.commercePriceListDiscountRelPersistence.fetchByCDI_CPI(commerceDiscountId, commercePriceListId);
    }

    public List<CommercePriceListDiscountRel> getCommercePriceListDiscountRels(long commercePriceListId) {
        return this.commercePriceListDiscountRelPersistence.findByCommercePriceListId(commercePriceListId);
    }

    public List<CommercePriceListDiscountRel> getCommercePriceListDiscountRels(long commercePriceListId, int start, int end, OrderByComparator<CommercePriceListDiscountRel> orderByComparator) {
        return this.commercePriceListDiscountRelPersistence.findByCommercePriceListId(commercePriceListId, start, end, orderByComparator);
    }

    public int getCommercePriceListDiscountRelsCount(long commercePriceListId) {
        return this.commercePriceListDiscountRelPersistence.countByCommercePriceListId(commercePriceListId);
    }

    protected void reindexPriceList(long commercePriceListId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommercePriceList.class);
        indexer.reindex(CommercePriceList.class.getName(), commercePriceListId);
    }
}

