/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.service.impl;

import com.liferay.commerce.model.CommerceOrderTypeTable;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListOrderTypeRel;
import com.liferay.commerce.price.list.model.CommercePriceListOrderTypeRelTable;
import com.liferay.commerce.price.list.service.base.CommercePriceListOrderTypeRelLocalServiceBaseImpl;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.price.list.model.CommercePriceListOrderTypeRel"}, service={AopService.class})
public class CommercePriceListOrderTypeRelLocalServiceImpl
extends CommercePriceListOrderTypeRelLocalServiceBaseImpl {
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public CommercePriceListOrderTypeRel addCommercePriceListOrderTypeRel(long userId, long commercePriceListId, long commerceOrderTypeId, int priority, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        CommercePriceListOrderTypeRel commercePriceListOrderTypeRel = this.commercePriceListOrderTypeRelPersistence.create(this.counterLocalService.increment());
        commercePriceListOrderTypeRel.setCompanyId(user.getCompanyId());
        commercePriceListOrderTypeRel.setUserId(user.getUserId());
        commercePriceListOrderTypeRel.setUserName(user.getFullName());
        commercePriceListOrderTypeRel.setCommercePriceListId(commercePriceListId);
        commercePriceListOrderTypeRel.setCommerceOrderTypeId(commerceOrderTypeId);
        commercePriceListOrderTypeRel.setPriority(priority);
        commercePriceListOrderTypeRel.setExpandoBridgeAttributes(serviceContext);
        commercePriceListOrderTypeRel = (CommercePriceListOrderTypeRel)this.commercePriceListOrderTypeRelPersistence.update((BaseModel)commercePriceListOrderTypeRel);
        this.reindexCommercePriceList(commercePriceListId);
        return commercePriceListOrderTypeRel;
    }

    @Override
    @SystemEvent(type=1)
    public CommercePriceListOrderTypeRel deleteCommercePriceListOrderTypeRel(CommercePriceListOrderTypeRel commercePriceListOrderTypeRel) throws PortalException {
        this.commercePriceListOrderTypeRelPersistence.remove((BaseModel)commercePriceListOrderTypeRel);
        this._expandoRowLocalService.deleteRows(commercePriceListOrderTypeRel.getCommercePriceListOrderTypeRelId());
        this.reindexCommercePriceList(commercePriceListOrderTypeRel.getCommercePriceListId());
        return commercePriceListOrderTypeRel;
    }

    @Override
    public CommercePriceListOrderTypeRel deleteCommercePriceListOrderTypeRel(long commercePriceListOrderTypeRelId) throws PortalException {
        CommercePriceListOrderTypeRel commercePriceListOrderTypeRel = this.commercePriceListOrderTypeRelPersistence.findByPrimaryKey(commercePriceListOrderTypeRelId);
        return this.commercePriceListOrderTypeRelLocalService.deleteCommercePriceListOrderTypeRel(commercePriceListOrderTypeRel);
    }

    public void deleteCommercePriceListOrderTypeRels(long commercePriceListId) {
        this.commercePriceListOrderTypeRelPersistence.removeByCommercePriceListId(commercePriceListId);
    }

    public CommercePriceListOrderTypeRel fetchCommercePriceListOrderTypeRel(long commercePriceListId, long commerceOrderTypeId) {
        return this.commercePriceListOrderTypeRelPersistence.fetchByCPI_COTI(commercePriceListId, commerceOrderTypeId);
    }

    @Override
    public CommercePriceListOrderTypeRel getCommercePriceListOrderTypeRel(long commercePriceListOrderTypeRelId) throws PortalException {
        return this.commercePriceListOrderTypeRelPersistence.findByPrimaryKey(commercePriceListOrderTypeRelId);
    }

    public List<CommercePriceListOrderTypeRel> getCommercePriceListOrderTypeRels(long commercePriceListId) {
        return this.commercePriceListOrderTypeRelPersistence.findByCommercePriceListId(commercePriceListId);
    }

    public List<CommercePriceListOrderTypeRel> getCommercePriceListOrderTypeRels(long commercePriceListId, String name, int start, int end, OrderByComparator<CommercePriceListOrderTypeRel> orderByComparator) throws PortalException {
        return (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePriceListOrderTypeRelTable.INSTANCE), commercePriceListId, name).orderBy((Table)CommercePriceListOrderTypeRelTable.INSTANCE, orderByComparator).limit(start, end));
    }

    public int getCommercePriceListOrderTypeRelsCount(long commercePriceListId, String name) throws PortalException {
        return this.dslQueryCount((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)CommercePriceListOrderTypeRelTable.INSTANCE.commercePriceListOrderTypeRelId), commercePriceListId, name));
    }

    protected void reindexCommercePriceList(long commercePriceListId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommercePriceList.class);
        indexer.reindex(CommercePriceList.class.getName(), commercePriceListId);
    }

    private GroupByStep _getGroupByStep(FromStep fromStep, Long commercePriceListId, String keywords) throws PortalException {
        JoinStep joinStep = fromStep.from((Table)CommercePriceListOrderTypeRelTable.INSTANCE).innerJoinON((Table)CommerceOrderTypeTable.INSTANCE, CommerceOrderTypeTable.INSTANCE.commerceOrderTypeId.eq((Expression)CommercePriceListOrderTypeRelTable.INSTANCE.commerceOrderTypeId));
        return joinStep.where(() -> {
            Predicate predicate = CommercePriceListOrderTypeRelTable.INSTANCE.commercePriceListId.eq((Object)commercePriceListId);
            if (Validator.isNotNull((String)keywords)) {
                predicate = predicate.and((Expression)Predicate.withParentheses((Predicate)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)CommerceOrderTypeTable.INSTANCE.name), this._customSQL.keywords(keywords, true))));
            }
            return predicate;
        });
    }
}

