/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.service.impl;

import com.liferay.commerce.price.list.exception.NoSuchPriceListException;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.base.CommercePriceListServiceBaseImpl;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CommerceCatalogService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommercePriceList"}, service={AopService.class})
public class CommercePriceListServiceImpl
extends CommercePriceListServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CommercePriceListServiceImpl.class);
    @Reference
    private CommerceCatalogService _commerceCatalogService;
    @Reference(target="(model.class.name=com.liferay.commerce.price.list.model.CommercePriceList)")
    private ModelResourcePermission<CommercePriceList> _commercePriceListModelResourcePermission;

    public CommercePriceList addCommercePriceList(String externalReferenceCode, long groupId, long commerceCurrencyId, boolean netPrice, String type, long parentCommercePriceListId, boolean catalogBasePriceList, String name, double priority, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        this._checkPortletResourcePermission(groupId, "ADD_COMMERCE_PRICE_LIST");
        return this.commercePriceListLocalService.addCommercePriceList(externalReferenceCode, groupId, this.getUserId(), commerceCurrencyId, netPrice, type, parentCommercePriceListId, catalogBasePriceList, name, priority, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommercePriceList addOrUpdateCommercePriceList(String externalReferenceCode, long groupId, long commercePriceListId, long commerceCurrencyId, boolean netPrice, String type, long parentCommercePriceListId, boolean catalogBasePriceList, String name, double priority, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        CommercePriceList commercePriceList;
        block5: {
            if (commercePriceListId > 0L) {
                try {
                    return this.updateCommercePriceList(commercePriceListId, commerceCurrencyId, netPrice, type, parentCommercePriceListId, catalogBasePriceList, name, priority, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
                }
                catch (NoSuchPriceListException noSuchPriceListException) {
                    if (!_log.isDebugEnabled()) break block5;
                    _log.debug((Object)("Unable to find price list with ID: " + commercePriceListId), (Throwable)noSuchPriceListException);
                }
            }
        }
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        if (Validator.isNotNull((String)externalReferenceCode) && (commercePriceList = this.commercePriceListPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode)) != null) {
            return this.updateCommercePriceList(commercePriceList.getCommercePriceListId(), commerceCurrencyId, netPrice, type, parentCommercePriceListId, catalogBasePriceList, name, priority, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
        }
        return this.addCommercePriceList(externalReferenceCode, groupId, commerceCurrencyId, netPrice, type, parentCommercePriceListId, catalogBasePriceList, name, priority, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public void deleteCommercePriceList(long commercePriceListId) throws PortalException {
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "DELETE");
        this.commercePriceListLocalService.deleteCommercePriceList(commercePriceListId);
    }

    public CommercePriceList fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommercePriceList commercePriceList = this.commercePriceListLocalService.fetchByExternalReferenceCode(externalReferenceCode, companyId);
        if (commercePriceList != null) {
            this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commercePriceList, "VIEW");
        }
        return commercePriceList;
    }

    public CommercePriceList fetchCatalogBaseCommercePriceListByType(long groupId, String type) throws PortalException {
        CommercePriceList commercePriceList = this.commercePriceListLocalService.fetchCatalogBaseCommercePriceListByType(groupId, type);
        if (commercePriceList != null) {
            this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commercePriceList, "VIEW");
        }
        return commercePriceList;
    }

    @Deprecated
    public CommercePriceList fetchCommerceCatalogBasePriceListByType(long groupId, String type) throws PortalException {
        return this.commercePriceListService.fetchCatalogBaseCommercePriceListByType(groupId, type);
    }

    public CommercePriceList fetchCommercePriceList(long commercePriceListId) throws PortalException {
        CommercePriceList commercePriceList = this.commercePriceListLocalService.fetchCommercePriceList(commercePriceListId);
        if (commercePriceList != null) {
            this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "VIEW");
        }
        return commercePriceList;
    }

    public CommercePriceList getCommercePriceList(long commercePriceListId) throws PortalException {
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "VIEW");
        return this.commercePriceListLocalService.getCommercePriceList(commercePriceListId);
    }

    public List<CommercePriceList> getCommercePriceLists(long companyId, int status, int start, int end, OrderByComparator<CommercePriceList> orderByComparator) throws PortalException {
        List commerceCatalogs = this._commerceCatalogService.search(companyId, null, -1, -1, null);
        Stream stream = commerceCatalogs.stream();
        long[] groupIds = stream.mapToLong(CommerceCatalog::getGroupId).toArray();
        if (status == -1) {
            return this.commercePriceListPersistence.filterFindByG_C_NotS(groupIds, companyId, 8, start, end, orderByComparator);
        }
        return this.commercePriceListPersistence.filterFindByG_C_S(groupIds, companyId, status, start, end, orderByComparator);
    }

    public List<CommercePriceList> getCommercePriceLists(long companyId, String type, int status, int start, int end, OrderByComparator<CommercePriceList> orderByComparator) throws PortalException {
        List commerceCatalogs = this._commerceCatalogService.search(companyId, null, -1, -1, null);
        Stream stream = commerceCatalogs.stream();
        long[] groupIds = stream.mapToLong(CommerceCatalog::getGroupId).toArray();
        if (status == -1) {
            return this.commercePriceListPersistence.filterFindByG_C_T_NotS(groupIds, companyId, type, 8, start, end, orderByComparator);
        }
        return this.commercePriceListPersistence.filterFindByG_C_T_S(groupIds, companyId, type, status, start, end, orderByComparator);
    }

    public int getCommercePriceListsCount(long companyId, int status) throws PortalException {
        List commerceCatalogs = this._commerceCatalogService.search(companyId, null, -1, -1, null);
        Stream stream = commerceCatalogs.stream();
        long[] groupIds = stream.mapToLong(CommerceCatalog::getGroupId).toArray();
        if (status == -1) {
            return this.commercePriceListPersistence.filterCountByG_C_NotS(groupIds, companyId, 8);
        }
        return this.commercePriceListPersistence.filterCountByG_C_S(groupIds, companyId, status);
    }

    public int getCommercePriceListsCount(long commercePricingClassId, String title) throws PrincipalException {
        return this.commercePriceListFinder.countByCommercePricingClassId(commercePricingClassId, title, true);
    }

    public List<CommercePriceList> searchByCommercePricingClassId(long commercePricingClassId, String name, int start, int end) throws PrincipalException {
        return this.commercePriceListFinder.findByCommercePricingClassId(commercePricingClassId, name, start, end, true);
    }

    public BaseModelSearchResult<CommercePriceList> searchCommercePriceLists(long companyId, String keywords, int status, int start, int end, Sort sort) throws PortalException {
        List commerceCatalogs = this._commerceCatalogService.search(companyId, null, -1, -1, null);
        Stream stream = commerceCatalogs.stream();
        long[] groupIds = stream.mapToLong(CommerceCatalog::getGroupId).toArray();
        return this.commercePriceListLocalService.searchCommercePriceLists(companyId, groupIds, keywords, status, start, end, sort);
    }

    public int searchCommercePriceListsCount(long companyId, String keywords, int status) throws PortalException {
        List commerceCatalogs = this._commerceCatalogService.search(companyId, null, -1, -1, null);
        Stream stream = commerceCatalogs.stream();
        long[] groupIds = stream.mapToLong(CommerceCatalog::getGroupId).toArray();
        return this.commercePriceListLocalService.searchCommercePriceListsCount(companyId, groupIds, keywords, status);
    }

    public void setCatalogBasePriceList(long groupId, long commercePriceListId, String type) throws PortalException {
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "UPDATE");
        this.commercePriceListLocalService.setCatalogBasePriceList(groupId, commercePriceListId, type);
    }

    public CommercePriceList updateCommercePriceList(long commercePriceListId, long commerceCurrencyId, boolean netPrice, long parentCommercePriceListId, String name, double priority, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "UPDATE");
        return this.commercePriceListLocalService.updateCommercePriceList(commercePriceListId, commerceCurrencyId, netPrice, parentCommercePriceListId, name, priority, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommercePriceList updateCommercePriceList(long commercePriceListId, long commerceCurrencyId, boolean netPrice, String type, long parentCommercePriceListId, boolean catalogBasePriceList, String name, double priority, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "UPDATE");
        return this.commercePriceListLocalService.updateCommercePriceList(commercePriceListId, commerceCurrencyId, netPrice, type, parentCommercePriceListId, catalogBasePriceList, name, priority, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommercePriceList updateExternalReferenceCode(CommercePriceList commercePriceList, String externalReferenceCode, long companyId) throws PortalException {
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commercePriceList, "UPDATE");
        return this.commercePriceListLocalService.updateExternalReferenceCode(commercePriceList, externalReferenceCode);
    }

    private void _checkPortletResourcePermission(long groupId, String actionId) throws PrincipalException {
        PortletResourcePermission portletResourcePermission = this._commercePriceListModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), groupId, actionId);
    }
}

