/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.service.impl;

import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommerceTierPriceEntry;
import com.liferay.commerce.price.list.service.CommercePriceEntryLocalService;
import com.liferay.commerce.price.list.service.base.CommerceTierPriceEntryServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceTierPriceEntry"}, service={AopService.class})
public class CommerceTierPriceEntryServiceImpl
extends CommerceTierPriceEntryServiceBaseImpl {
    @Reference
    private CommercePriceEntryLocalService _commercePriceEntryLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.price.list.model.CommercePriceList)")
    private ModelResourcePermission<CommercePriceList> _commercePriceListModelResourcePermission;

    public CommerceTierPriceEntry addCommerceTierPriceEntry(long commercePriceEntryId, BigDecimal price, BigDecimal promoPrice, int minQuantity, ServiceContext serviceContext) throws PortalException {
        return this.addCommerceTierPriceEntry(null, commercePriceEntryId, price, promoPrice, minQuantity, serviceContext);
    }

    public CommerceTierPriceEntry addCommerceTierPriceEntry(String externalReferenceCode, long commercePriceEntryId, BigDecimal price, BigDecimal promoPrice, int minQuantity, ServiceContext serviceContext) throws PortalException {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.getCommercePriceEntry(commercePriceEntryId);
        if (commercePriceEntry != null) {
            this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        }
        return this.commerceTierPriceEntryLocalService.addCommerceTierPriceEntry(externalReferenceCode, commercePriceEntryId, price, promoPrice, minQuantity, serviceContext);
    }

    public CommerceTierPriceEntry addCommerceTierPriceEntry(String externalReferenceCode, long commercePriceEntryId, BigDecimal price, int minQuantity, boolean bulkPricing, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.getCommercePriceEntry(commercePriceEntryId);
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        return this.commerceTierPriceEntryLocalService.addCommerceTierPriceEntry(externalReferenceCode, commercePriceEntryId, price, minQuantity, bulkPricing, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommerceTierPriceEntry addOrUpdateCommerceTierPriceEntry(String externalReferenceCode, long commerceTierPriceEntryId, long commercePriceEntryId, BigDecimal price, BigDecimal promoPrice, int minQuantity, String priceEntryExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceEntryId);
        if (commercePriceEntry == null && Validator.isNotNull((String)priceEntryExternalReferenceCode)) {
            commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntryByReferenceCode(serviceContext.getCompanyId(), priceEntryExternalReferenceCode);
        }
        if (commercePriceEntry != null) {
            this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        }
        return this.commerceTierPriceEntryLocalService.addOrUpdateCommerceTierPriceEntry(externalReferenceCode, commerceTierPriceEntryId, commercePriceEntryId, price, promoPrice, minQuantity, priceEntryExternalReferenceCode, serviceContext);
    }

    public CommerceTierPriceEntry addOrUpdateCommerceTierPriceEntry(String externalReferenceCode, long commerceTierPriceEntryId, long commercePriceEntryId, BigDecimal price, int minQuantity, boolean bulkPricing, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String priceEntryExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceEntryId);
        if (commercePriceEntry == null && Validator.isNotNull((String)priceEntryExternalReferenceCode)) {
            commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntryByReferenceCode(serviceContext.getCompanyId(), priceEntryExternalReferenceCode);
        }
        if (commercePriceEntry != null) {
            this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        }
        return this.commerceTierPriceEntryLocalService.addOrUpdateCommerceTierPriceEntry(externalReferenceCode, commerceTierPriceEntryId, commercePriceEntryId, price, minQuantity, bulkPricing, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, priceEntryExternalReferenceCode, serviceContext);
    }

    public void deleteCommerceTierPriceEntry(long commerceTierPriceEntryId) throws PortalException {
        CommerceTierPriceEntry commerceTierPriceEntry = this.commerceTierPriceEntryLocalService.getCommerceTierPriceEntry(commerceTierPriceEntryId);
        CommercePriceEntry commercePriceEntry = commerceTierPriceEntry.getCommercePriceEntry();
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        this.commerceTierPriceEntryLocalService.deleteCommerceTierPriceEntry(commerceTierPriceEntryId);
    }

    public CommerceTierPriceEntry fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommerceTierPriceEntry commerceTierPriceEntry = this.commerceTierPriceEntryLocalService.fetchByExternalReferenceCode(externalReferenceCode, companyId);
        if (commerceTierPriceEntry != null) {
            CommercePriceEntry commercePriceEntry = commerceTierPriceEntry.getCommercePriceEntry();
            this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "VIEW");
        }
        return commerceTierPriceEntry;
    }

    @Deprecated
    public List<CommerceTierPriceEntry> fetchCommerceTierPriceEntries(long companyId, int start, int end) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public CommerceTierPriceEntry fetchCommerceTierPriceEntry(long commerceTierPriceEntryId) throws PortalException {
        CommerceTierPriceEntry commerceTierPriceEntry = this.commerceTierPriceEntryLocalService.fetchCommerceTierPriceEntry(commerceTierPriceEntryId);
        if (commerceTierPriceEntry != null) {
            CommercePriceEntry commercePriceEntry = commerceTierPriceEntry.getCommercePriceEntry();
            this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "VIEW");
        }
        return commerceTierPriceEntry;
    }

    public List<CommerceTierPriceEntry> getCommerceTierPriceEntries(long commercePriceEntryId, int start, int end) throws PortalException {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.getCommercePriceEntry(commercePriceEntryId);
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "VIEW");
        return this.commerceTierPriceEntryLocalService.getCommerceTierPriceEntries(commercePriceEntryId, start, end);
    }

    public List<CommerceTierPriceEntry> getCommerceTierPriceEntries(long commercePriceEntryId, int start, int end, OrderByComparator<CommerceTierPriceEntry> orderByComparator) throws PortalException {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.getCommercePriceEntry(commercePriceEntryId);
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "VIEW");
        return this.commerceTierPriceEntryLocalService.getCommerceTierPriceEntries(commercePriceEntryId, start, end, orderByComparator);
    }

    public int getCommerceTierPriceEntriesCount(long commercePriceEntryId) throws PortalException {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.getCommercePriceEntry(commercePriceEntryId);
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "VIEW");
        return this.commerceTierPriceEntryLocalService.getCommerceTierPriceEntriesCount(commercePriceEntryId);
    }

    @Deprecated
    public int getCommerceTierPriceEntriesCountByCompanyId(long companyId) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public CommerceTierPriceEntry getCommerceTierPriceEntry(long commerceTierPriceEntryId) throws PortalException {
        CommerceTierPriceEntry commerceTierPriceEntry = this.commerceTierPriceEntryLocalService.getCommerceTierPriceEntry(commerceTierPriceEntryId);
        CommercePriceEntry commercePriceEntry = commerceTierPriceEntry.getCommercePriceEntry();
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "VIEW");
        return commerceTierPriceEntry;
    }

    public BaseModelSearchResult<CommerceTierPriceEntry> searchCommerceTierPriceEntries(long companyId, long commercePriceEntryId, String keywords, int start, int end, Sort sort) throws PortalException {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceEntryId);
        if (commercePriceEntry != null) {
            this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "VIEW");
        }
        return this.commerceTierPriceEntryLocalService.searchCommerceTierPriceEntries(companyId, commercePriceEntryId, keywords, start, end, sort);
    }

    public int searchCommerceTierPriceEntriesCount(long companyId, long commercePriceEntryId, String keywords) throws PortalException {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.getCommercePriceEntry(commercePriceEntryId);
        if (commercePriceEntry != null) {
            this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        }
        return this._commercePriceEntryLocalService.searchCommercePriceEntriesCount(companyId, commercePriceEntryId, keywords);
    }

    public CommerceTierPriceEntry updateCommerceTierPriceEntry(long commerceTierPriceEntryId, BigDecimal price, BigDecimal promoPrice, int minQuantity, ServiceContext serviceContext) throws PortalException {
        CommerceTierPriceEntry commerceTierPriceEntry = this.commerceTierPriceEntryLocalService.getCommerceTierPriceEntry(commerceTierPriceEntryId);
        CommercePriceEntry commercePriceEntry = commerceTierPriceEntry.getCommercePriceEntry();
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        return this.commerceTierPriceEntryLocalService.updateCommerceTierPriceEntry(commerceTierPriceEntryId, price, promoPrice, minQuantity, serviceContext);
    }

    public CommerceTierPriceEntry updateCommerceTierPriceEntry(long commerceTierPriceEntryId, BigDecimal price, int minQuantity, boolean bulkPricing, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        CommerceTierPriceEntry commerceTierPriceEntry = this.commerceTierPriceEntryLocalService.getCommerceTierPriceEntry(commerceTierPriceEntryId);
        CommercePriceEntry commercePriceEntry = commerceTierPriceEntry.getCommercePriceEntry();
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        return this.commerceTierPriceEntryLocalService.updateCommerceTierPriceEntry(commerceTierPriceEntryId, price, minQuantity, bulkPricing, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommerceTierPriceEntry updateExternalReferenceCode(CommerceTierPriceEntry commerceTierPriceEntry, String externalReferenceCode) throws PortalException {
        CommercePriceEntry commercePriceEntry = commerceTierPriceEntry.getCommercePriceEntry();
        this._commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        return this.commerceTierPriceEntryLocalService.updateExternalReferenceCode(commerceTierPriceEntry, externalReferenceCode);
    }
}

