/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.pricing.service.impl;

import com.liferay.commerce.pricing.exception.NoSuchPricingClassException;
import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.service.base.CommercePricingClassServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.CompanyService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommercePricingClass"}, service={AopService.class})
public class CommercePricingClassServiceImpl
extends CommercePricingClassServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CommercePricingClassServiceImpl.class);
    @Reference(target="(model.class.name=com.liferay.commerce.pricing.model.CommercePricingClass)")
    private ModelResourcePermission<CommercePricingClass> _commercePricingClassResourcePermission;
    @Reference
    private CompanyService _companyService;

    public CommercePricingClass addCommercePricingClass(String externalReferenceCode, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        this._checkPortletResourcePermission(null, "ADD_COMMERCE_PRICING_CLASS");
        PermissionChecker permissionChecker = this.getPermissionChecker();
        return this.commercePricingClassLocalService.addCommercePricingClass(externalReferenceCode, permissionChecker.getUserId(), titleMap, descriptionMap, serviceContext);
    }

    public CommercePricingClass addOrUpdateCommercePricingClass(String externalReferenceCode, long commercePricingClassId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        CommercePricingClass commercePricingClass;
        block4: {
            if (commercePricingClassId > 0L) {
                try {
                    return this.updateCommercePricingClass(commercePricingClassId, titleMap, descriptionMap, serviceContext);
                }
                catch (NoSuchPricingClassException noSuchPricingClassException) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)("Unable to find pricing class with ID: " + commercePricingClassId), (Throwable)noSuchPricingClassException);
                }
            }
        }
        if (!Validator.isBlank((String)externalReferenceCode) && (commercePricingClass = this.commercePricingClassPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode)) != null) {
            return this.commercePricingClassLocalService.updateCommercePricingClass(commercePricingClassId, this.getUserId(), titleMap, descriptionMap, serviceContext);
        }
        return this.addCommercePricingClass(externalReferenceCode, titleMap, descriptionMap, serviceContext);
    }

    public CommercePricingClass deleteCommercePricingClass(long commercePricingClassId) throws PortalException {
        this._commercePricingClassResourcePermission.check(this.getPermissionChecker(), commercePricingClassId, "DELETE");
        return this.commercePricingClassLocalService.deleteCommercePricingClass(commercePricingClassId);
    }

    public CommercePricingClass fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommercePricingClass commercePricingClass = this.commercePricingClassLocalService.fetchByExternalReferenceCode(externalReferenceCode, companyId);
        if (commercePricingClass != null) {
            this._commercePricingClassResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commercePricingClass, "VIEW");
        }
        return commercePricingClass;
    }

    public CommercePricingClass fetchCommercePricingClass(long commercePricingClassId) throws PortalException {
        CommercePricingClass commercePricingClass = this.commercePricingClassLocalService.fetchCommercePricingClass(commercePricingClassId);
        if (commercePricingClass != null) {
            this._commercePricingClassResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commercePricingClass, "VIEW");
        }
        return commercePricingClass;
    }

    public CommercePricingClass getCommercePricingClass(long commercePricingClassId) throws PortalException {
        this._commercePricingClassResourcePermission.check(this.getPermissionChecker(), commercePricingClassId, "VIEW");
        return this.commercePricingClassLocalService.getCommercePricingClass(commercePricingClassId);
    }

    public int getCommercePricingClassCountByCPDefinitionId(long cpDefinitionId, String title) throws PrincipalException {
        return this.commercePricingClassFinder.countByCPDefinitionId(cpDefinitionId, title, true);
    }

    public List<CommercePricingClass> getCommercePricingClasses(long companyId, int start, int end, OrderByComparator<CommercePricingClass> orderByComparator) throws PortalException {
        return this.commercePricingClassPersistence.filterFindByCompanyId(companyId, start, end, orderByComparator);
    }

    public int getCommercePricingClassesCount(long companyId) throws PortalException {
        return this.commercePricingClassPersistence.filterCountByCompanyId(companyId);
    }

    public int getCommercePricingClassesCount(long cpDefinitionId, String title) throws PrincipalException {
        return this.commercePricingClassFinder.countByCPDefinitionId(cpDefinitionId, title, true);
    }

    public List<CommercePricingClass> searchByCPDefinitionId(long cpDefinitionId, String title, int start, int end) throws PrincipalException {
        return this.commercePricingClassFinder.findByCPDefinitionId(cpDefinitionId, title, start, end, true);
    }

    public BaseModelSearchResult<CommercePricingClass> searchCommercePricingClasses(long companyId, String keywords, int start, int end, Sort sort) throws PortalException {
        return this.commercePricingClassLocalService.searchCommercePricingClasses(companyId, keywords, start, end, sort);
    }

    public CommercePricingClass updateCommercePricingClass(long commercePricingClassId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        this._commercePricingClassResourcePermission.check(this.getPermissionChecker(), commercePricingClassId, "UPDATE");
        return this.commercePricingClassLocalService.updateCommercePricingClass(commercePricingClassId, this.getUserId(), titleMap, descriptionMap, serviceContext);
    }

    public CommercePricingClass updateCommercePricingClassExternalReferenceCode(String externalReferenceCode, long commercePricingClassId) throws PortalException {
        this._commercePricingClassResourcePermission.check(this.getPermissionChecker(), commercePricingClassId, "UPDATE");
        return this.commercePricingClassLocalService.updateCommercePricingClassExternalReferenceCode(externalReferenceCode, commercePricingClassId);
    }

    private void _checkPortletResourcePermission(Group group, String actionId) throws PrincipalException {
        PortletResourcePermission portletResourcePermission = this._commercePricingClassResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), group, actionId);
    }
}

