<%--
/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
--%>

<%@ include file="/init.jsp" %>

<%
CommercePriceListDisplayContext commercePriceListDisplayContext = (CommercePriceListDisplayContext)request.getAttribute(WebKeys.PORTLET_DISPLAY_CONTEXT);

CommercePriceList commercePriceList = commercePriceListDisplayContext.getCommercePriceList();

String headerTitle = LanguageUtil.get(request, "add-price-list");

if (commercePriceList != null) {
	headerTitle = commercePriceList.getName();
}

portletDisplay.setShowBackIcon(true);

if (Validator.isNull(redirect)) {
	portletDisplay.setURLBack(String.valueOf(renderResponse.createRenderURL()));
}
else {
	portletDisplay.setURLBack(redirect);
}
%>

<liferay-portlet:renderURL var="editCommercePriceListExternalReferenceCodeURL" windowState="<%= LiferayWindowState.POP_UP.toString() %>">
	<portlet:param name="mvcRenderCommandName" value="/commerce_price_list/edit_commerce_price_list_external_reference_code" />
	<portlet:param name="commercePriceListId" value="<%= String.valueOf(commercePriceListDisplayContext.getCommercePriceListId()) %>" />
</liferay-portlet:renderURL>

<commerce-ui:header
	actions="<%= commercePriceListDisplayContext.getHeaderActionModels() %>"
	bean="<%= commercePriceList %>"
	beanIdLabel="id"
	externalReferenceCode="<%= (commercePriceList == null) ? StringPool.BLANK : commercePriceList.getExternalReferenceCode() %>"
	externalReferenceCodeEditUrl="<%= (commercePriceList == null) ? StringPool.BLANK : editCommercePriceListExternalReferenceCodeURL %>"
	model="<%= CommercePriceList.class %>"
	title="<%= headerTitle %>"
	wrapperCssClasses="side-panel-top-anchor"
/>

<liferay-frontend:screen-navigation
	containerCssClass="col-md-10"
	key="<%= CommercePriceListScreenNavigationConstants.SCREEN_NAVIGATION_KEY_COMMERCE_PRICE_LIST_GENERAL %>"
	modelBean="<%= commercePriceListDisplayContext.getCommercePriceList() %>"
	navCssClass="col-md-2"
	portletURL="<%= currentURLObj %>"
/>

<aui:script>
	document
		.getElementById('<portlet:namespace />publishButton')
		.addEventListener('click', function (e) {
			e.preventDefault();

			var form = document.getElementById('<portlet:namespace />fm');

			if (!form) {
				throw new Error('Form with id: <portlet:namespace />fm not found!');
			}

			var workflowActionInput = document.getElementById(
				'<portlet:namespace />workflowAction'
			);

			if (workflowActionInput) {
				workflowActionInput.value =
					'<%= WorkflowConstants.ACTION_PUBLISH %>';
			}

			submitForm(form);
		});
</aui:script>