/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.pricing.web.internal.constants;

import com.liferay.commerce.pricing.constants.CommercePricingPortletKeys;

/**
 * @author Riccardo Alberti
 * @author Alessio Antonio Rendina
 */
public class CommercePricingFDSNames {

	public static final String DISCOUNT_CATEGORIES =
		CommercePricingPortletKeys.COMMERCE_DISCOUNT + "-discountCategories";

	public static final String DISCOUNT_PRICING_CLASSES =
		CommercePricingPortletKeys.COMMERCE_DISCOUNT +
			"-discountPricingClasses";

	public static final String DISCOUNT_PRODUCT_DEFINITIONS =
		CommercePricingPortletKeys.COMMERCE_DISCOUNT +
			"-discountProductDefinitions";

	public static final String DISCOUNT_QUALIFIER_ACCOUNT_GROUPS =
		CommercePricingPortletKeys.COMMERCE_DISCOUNT +
			"-discountQualifierAccountGroups";

	public static final String DISCOUNT_QUALIFIER_ACCOUNTS =
		CommercePricingPortletKeys.COMMERCE_DISCOUNT +
			"-discountQualifierAccounts";

	public static final String DISCOUNT_QUALIFIER_CHANNELS =
		CommercePricingPortletKeys.COMMERCE_DISCOUNT +
			"-discountQualifierChannels";

	public static final String DISCOUNT_QUALIFIER_ORDER_TYPES =
		CommercePricingPortletKeys.COMMERCE_DISCOUNT +
			"-discountQualifierOrderTypes";

	public static final String DISCOUNT_RULE_PRODUCT_DEFINITIONS =
		CommercePricingPortletKeys.COMMERCE_DISCOUNT +
			"-discountRuleProductDefinitions";

	public static final String DISCOUNT_RULES =
		CommercePricingPortletKeys.COMMERCE_DISCOUNT + "-discountRules";

	public static final String DISCOUNT_SKUS =
		CommercePricingPortletKeys.COMMERCE_DISCOUNT + "-discountSkus";

	public static final String DISCOUNTS =
		CommercePricingPortletKeys.COMMERCE_DISCOUNT + "-discounts";

	public static final String INSTANCE_PRICE_ENTRIES =
		CommercePricingPortletKeys.COMMERCE_PRICE_LIST +
			"-instancePriceEntries";

	public static final String INSTANCE_TIER_PRICE_ENTRIES =
		CommercePricingPortletKeys.COMMERCE_PRICE_LIST +
			"-instanceTierPriceEntries";

	public static final String PRICE_LIST_ENTRIES =
		CommercePricingPortletKeys.COMMERCE_PRICE_LIST + "-priceListEntries";

	public static final String PRICE_LIST_QUALIFIER_ACCOUNT_GROUPS =
		CommercePricingPortletKeys.COMMERCE_PRICE_LIST +
			"-priceListQualifierAccountGroups";

	public static final String PRICE_LIST_QUALIFIER_ACCOUNTS =
		CommercePricingPortletKeys.COMMERCE_PRICE_LIST +
			"-priceListQualifierAccounts";

	public static final String PRICE_LIST_QUALIFIER_CHANNELS =
		CommercePricingPortletKeys.COMMERCE_PRICE_LIST +
			"-priceListQualifierChannels";

	public static final String PRICE_LIST_QUALIFIER_ORDER_TYPES =
		CommercePricingPortletKeys.COMMERCE_PRICE_LIST +
			"-priceListQualifierOrderTypes";

	public static final String PRICE_LISTS =
		CommercePricingPortletKeys.COMMERCE_PRICE_LIST + "-priceLists";

	public static final String PRICE_MODIFIER_CATEGORIES =
		CommercePricingPortletKeys.COMMERCE_PRICE_LIST +
			"-priceModifierCategories";

	public static final String PRICE_MODIFIER_PRICING_CLASSES =
		CommercePricingPortletKeys.COMMERCE_PRICE_LIST +
			"-priceModifierPricingClasses";

	public static final String PRICE_MODIFIER_PRODUCT_DEFINITIONS =
		CommercePricingPortletKeys.COMMERCE_PRICE_LIST +
			"-priceModifierProductDefinitions";

	public static final String PRICE_MODIFIERS =
		CommercePricingPortletKeys.COMMERCE_PRICE_LIST + "-priceModifiers";

	public static final String PRICING_CLASSES =
		CommercePricingPortletKeys.COMMERCE_PRICING_CLASSES + "-pricingClasses";

	public static final String PRICING_CLASSES_DISCOUNTS =
		CommercePricingPortletKeys.COMMERCE_PRICING_CLASSES +
			"-pricingClassesDiscounts";

	public static final String PRICING_CLASSES_PRICE_LISTS =
		CommercePricingPortletKeys.COMMERCE_PRICING_CLASSES +
			"-pricingClassesPriceLists";

	public static final String PRICING_CLASSES_PRODUCT_DEFINITIONS =
		CommercePricingPortletKeys.COMMERCE_PRICING_CLASSES +
			"-pricingClassesCPDefinitions";

	public static final String PRODUCT_PRICING_CLASSES =
		CommercePricingPortletKeys.COMMERCE_PRICING_CLASSES +
			"-productPricingClasses";

	public static final String PROMOTION_ENTRIES =
		CommercePricingPortletKeys.COMMERCE_PRICE_LIST + "-promotionEntries";

	public static final String TIER_PRICE_ENTRIES =
		CommercePricingPortletKeys.COMMERCE_PRICE_LIST + "-tierPriceEntries";

}