/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.ddm.internal;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.product.constants.CPConstants;
import com.liferay.commerce.product.ddm.DDMHelper;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelLocalService;
import com.liferay.commerce.product.util.DDMFormValuesHelper;
import com.liferay.commerce.util.CommerceUtil;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.servlet.PipingServletResponseFactory;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMHelper.class})
public class DDMHelperImpl
implements DDMHelper {
    private static final String[] _ARRAY_VALUE_FIELD_TYPE = new String[]{"select", "checkbox", "checkbox_multiple"};
    @Reference
    private CPDefinitionOptionValueRelLocalService _cpDefinitionOptionValueRelLocalService;
    @Reference
    private DDMFormRenderer _ddmFormRenderer;
    @Reference
    private DDMFormValuesHelper _ddmFormValuesHelper;
    @Reference
    private Portal _portal;

    public DDMForm getCPAttachmentFileEntryDDMForm(Locale locale, Map<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelCPDefinitionOptionValueRels) {
        return this._getDDMForm(locale, false, true, false, cpDefinitionOptionRelCPDefinitionOptionValueRels);
    }

    public DDMForm getCPInstanceDDMForm(Locale locale, boolean ignoreSKUCombinations, Map<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelCPDefinitionOptionValueRels) {
        return this._getDDMForm(locale, ignoreSKUCombinations, false, false, cpDefinitionOptionRelCPDefinitionOptionValueRels);
    }

    public DDMForm getPublicStoreDDMForm(long groupId, long commerceAccountId, long cpDefinitionId, Locale locale, boolean ignoreSKUCombinations, Map<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelCPDefinitionOptionValueRels, long companyId, long userId) {
        DDMForm ddmForm = this._getDDMForm(locale, ignoreSKUCombinations, false, true, cpDefinitionOptionRelCPDefinitionOptionValueRels);
        if (!ignoreSKUCombinations) {
            ddmForm.addDDMFormRule(this._createDDMFormRule(ddmForm, groupId, commerceAccountId, cpDefinitionId, companyId, userId, locale));
        }
        return ddmForm;
    }

    public String renderCPAttachmentFileEntryOptions(long cpDefinitionId, String json, PageContext pageContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelCPDefinitionOptionValueRels) throws PortalException {
        Locale locale = this._portal.getLocale(httpServletRequest);
        DDMForm ddmForm = this.getCPAttachmentFileEntryDDMForm(locale, cpDefinitionOptionRelCPDefinitionOptionValueRels);
        return this._render(cpDefinitionId, locale, ddmForm, json, pageContext, httpServletRequest, httpServletResponse);
    }

    public String renderCPAttachmentFileEntryOptions(long cpDefinitionId, String json, RenderRequest renderRequest, RenderResponse renderResponse, Map<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelCPDefinitionOptionValueRels) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public String renderCPInstanceOptions(long cpDefinitionId, String json, boolean ignoreSKUCombinations, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelCPDefinitionOptionValueRels) throws PortalException {
        Locale locale = this._portal.getLocale(httpServletRequest);
        DDMForm ddmForm = this.getCPInstanceDDMForm(locale, ignoreSKUCombinations, cpDefinitionOptionRelCPDefinitionOptionValueRels);
        return this._render(cpDefinitionId, locale, ddmForm, json, null, httpServletRequest, httpServletResponse);
    }

    public String renderPublicStoreOptions(long cpDefinitionId, String json, boolean ignoreSKUCombinations, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelCPDefinitionOptionValueRels) throws PortalException {
        Locale locale = this._portal.getLocale(httpServletRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        DDMForm ddmForm = this.getPublicStoreDDMForm(this._portal.getScopeGroupId(httpServletRequest), CommerceUtil.getCommerceAccountId((CommerceContext)((CommerceContext)httpServletRequest.getAttribute("COMMERCE_CONTEXT"))), cpDefinitionId, locale, ignoreSKUCombinations, cpDefinitionOptionRelCPDefinitionOptionValueRels, themeDisplay.getCompanyId(), themeDisplay.getUserId());
        return this._render(cpDefinitionId, locale, ddmForm, json, null, httpServletRequest, httpServletResponse);
    }

    private DDMFormRule _createDDMFormRule(DDMForm ddmForm, long groupId, long commerceAccountId, long cpDefinitionId, long companyId, long userId, Locale locale) {
        String action = this._createDDMFormRuleAction(ddmForm, groupId, commerceAccountId, cpDefinitionId, companyId, userId, locale);
        return new DDMFormRule("TRUE", new String[]{action});
    }

    private String _createDDMFormRuleAction(DDMForm ddmForm, long groupId, long commerceAccountId, long cpDefinitionId, long companyId, long userId, Locale locale) {
        return StringBundler.concat((String[])new String[]{"call('getCPInstanceOptionsValues', concat(", this._createDDMFormRuleInputMapping(ddmForm, groupId, commerceAccountId, cpDefinitionId, companyId, userId, locale), "), '", this._createDDMFormRuleOutputMapping(ddmForm), "')"});
    }

    private String _createDDMFormRuleInputMapping(DDMForm ddmForm, long groupId, long commerceAccountId, long cpDefinitionId, long companyId, long userId, Locale locale) {
        List ddmFormFields = ddmForm.getDDMFormFields();
        StringBundler sb = new StringBundler(ddmFormFields.size() * 5 + 13);
        sb.append("'locale=");
        sb.append(LocaleUtil.toLanguageId((Locale)locale));
        sb.append("', ';','userId=");
        sb.append(userId);
        sb.append("', ';','commerceAccountId=");
        sb.append(commerceAccountId);
        sb.append("', ';','groupId=");
        sb.append(groupId);
        sb.append("', ';','cpDefinitionId=");
        sb.append(cpDefinitionId);
        sb.append("', ';','companyId=");
        sb.append(companyId);
        sb.append("'");
        for (DDMFormField ddmFormField : ddmFormFields) {
            sb.append(", ';','");
            sb.append(ddmFormField.getName());
            sb.append("=', getValue('");
            sb.append(ddmFormField.getName());
            sb.append("')");
        }
        return sb.toString();
    }

    private String _createDDMFormRuleOutputMapping(DDMForm ddmForm) {
        List ddmFormFields = ddmForm.getDDMFormFields();
        StringBundler sb = new StringBundler(ddmFormFields.size() * 4);
        for (DDMFormField ddmFormField : ddmFormFields) {
            sb.append(ddmFormField.getName());
            sb.append("=");
            sb.append(ddmFormField.getName());
            sb.append(";");
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private DDMForm _getDDMForm(Locale locale, boolean ignoreSKUCombinations, boolean optional, boolean publicStore, Map<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelCPDefinitionOptionValueRels) {
        if (cpDefinitionOptionRelCPDefinitionOptionValueRels.isEmpty()) {
            return null;
        }
        DDMForm ddmForm = new DDMForm();
        for (Map.Entry<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelEntry : cpDefinitionOptionRelCPDefinitionOptionValueRels.entrySet()) {
            CPDefinitionOptionRel cpDefinitionOptionRel = cpDefinitionOptionRelEntry.getKey();
            if (Validator.isNull((String)cpDefinitionOptionRel.getDDMFormFieldTypeName())) continue;
            List<CPDefinitionOptionValueRel> cpDefinitionOptionValueRels = cpDefinitionOptionRelEntry.getValue();
            DDMFormField ddmFormField = this._getDDMFormField(cpDefinitionOptionRel, cpDefinitionOptionValueRels, locale);
            if (publicStore) {
                this._setPredefinedValue(ddmFormField, cpDefinitionOptionRel);
                if (!optional) {
                    ddmFormField.setRequired(this._isDDMFormFieldRequired(cpDefinitionOptionRel, ignoreSKUCombinations, publicStore));
                }
            } else {
                ddmFormField.setRequired(!optional);
            }
            ddmForm.addDDMFormField(ddmFormField);
        }
        ddmForm.addAvailableLocale(locale);
        ddmForm.setDefaultLocale(locale);
        return ddmForm;
    }

    private DDMFormField _getDDMFormField(CPDefinitionOptionRel cpDefinitionOptionRel, List<CPDefinitionOptionValueRel> cpDefinitionOptionValueRels, Locale locale) {
        DDMFormField ddmFormField = new DDMFormField(cpDefinitionOptionRel.getKey(), cpDefinitionOptionRel.getDDMFormFieldTypeName());
        LocalizedValue ddmFormFieldLabelLocalizedValue = new LocalizedValue(locale);
        ddmFormFieldLabelLocalizedValue.addString(locale, cpDefinitionOptionRel.getName(locale));
        ddmFormField.setLabel(ddmFormFieldLabelLocalizedValue);
        if (cpDefinitionOptionValueRels.isEmpty()) {
            return ddmFormField;
        }
        ddmFormField.setDDMFormFieldOptions(this._getDDMFormFieldOptions(cpDefinitionOptionValueRels, locale));
        return ddmFormField;
    }

    private DDMFormFieldOptions _getDDMFormFieldOptions(List<CPDefinitionOptionValueRel> cpDefinitionOptionValueRels, Locale locale) {
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
            ddmFormFieldOptions.addOptionLabel(cpDefinitionOptionValueRel.getKey(), locale, cpDefinitionOptionValueRel.getName(locale));
        }
        return ddmFormFieldOptions;
    }

    private LocalizedValue _getDDMFormFieldPredefinedValue(DDMFormFieldOptions ddmFormFieldOptions, boolean arrayValueFieldType, String optionValueKey) {
        Map options = ddmFormFieldOptions.getOptions();
        if (options.isEmpty()) {
            return new LocalizedValue(ddmFormFieldOptions.getDefaultLocale());
        }
        for (Map.Entry entry : options.entrySet()) {
            LocalizedValue localizedValue = new LocalizedValue();
            LocalizedValue curLocalizedValue = (LocalizedValue)entry.getValue();
            if (arrayValueFieldType) {
                localizedValue.addString(curLocalizedValue.getDefaultLocale(), "[\"" + (String)entry.getKey() + "\"]");
            } else {
                localizedValue.addString(curLocalizedValue.getDefaultLocale(), (String)entry.getKey());
            }
            if (!Validator.isNull((String)optionValueKey) && !Objects.equals(optionValueKey, entry.getKey())) continue;
            return localizedValue;
        }
        throw new IllegalArgumentException("Provided DDM field options miss valid field value");
    }

    private boolean _isArrayValueCPDefinitionOptionRelFieldType(CPDefinitionOptionRel cpDefinitionOptionRel) {
        return ArrayUtil.contains((Object[])_ARRAY_VALUE_FIELD_TYPE, (Object)cpDefinitionOptionRel.getDDMFormFieldTypeName());
    }

    private boolean _isDDMFormFieldRequired(CPDefinitionOptionRel cpDefinitionOptionRel, boolean ignoreSKUCombinations, boolean publicStore) {
        if (this._isIterableCPDefinitionOptionRelFieldType(cpDefinitionOptionRel) && !this._cpDefinitionOptionValueRelLocalService.hasCPDefinitionOptionValueRels(cpDefinitionOptionRel.getCPDefinitionOptionRelId())) {
            return false;
        }
        if (ignoreSKUCombinations) {
            return cpDefinitionOptionRel.isRequired();
        }
        return cpDefinitionOptionRel.isSkuContributor() || publicStore && cpDefinitionOptionRel.isRequired();
    }

    private boolean _isIterableCPDefinitionOptionRelFieldType(CPDefinitionOptionRel cpDefinitionOptionRel) {
        return ArrayUtil.contains((Object[])CPConstants.PRODUCT_OPTION_MULTIPLE_VALUES_FIELD_TYPES, (Object)cpDefinitionOptionRel.getDDMFormFieldTypeName());
    }

    private String _render(long cpDefinitionId, Locale locale, DDMForm ddmForm, String json, PageContext pageContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        DDMFormValues ddmFormValues;
        if (ddmForm == null) {
            return "";
        }
        if (pageContext != null) {
            httpServletResponse = PipingServletResponseFactory.createPipingServletResponse((PageContext)pageContext);
        }
        DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
        ddmFormRenderingContext.setContainerId("ProductOptions" + String.valueOf(cpDefinitionId));
        ddmFormRenderingContext.setHttpServletRequest(httpServletRequest);
        ddmFormRenderingContext.setHttpServletResponse(httpServletResponse);
        ddmFormRenderingContext.setLocale(locale);
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        ddmFormRenderingContext.setPortletNamespace(portletDisplay.getNamespace());
        ddmFormRenderingContext.setShowRequiredFieldsWarning(false);
        if (Validator.isNotNull((String)json) && (ddmFormValues = this._ddmFormValuesHelper.deserialize(ddmForm, json, locale)) != null) {
            ddmFormRenderingContext.setDDMFormValues(ddmFormValues);
        }
        return this._ddmFormRenderer.render(ddmForm, ddmFormRenderingContext);
    }

    private void _setPredefinedValue(DDMFormField ddmFormField, CPDefinitionOptionRel cpDefinitionOptionRel) {
        CPDefinitionOptionValueRel preselectedCPDefinitionOptionValueRel = cpDefinitionOptionRel.fetchPreselectedCPDefinitionOptionValueRel();
        String predefinedValueKey = null;
        if (preselectedCPDefinitionOptionValueRel != null) {
            predefinedValueKey = preselectedCPDefinitionOptionValueRel.getKey();
        }
        if (Validator.isNull(predefinedValueKey) && !cpDefinitionOptionRel.isSkuContributor()) {
            return;
        }
        ddmFormField.setPredefinedValue(this._getDDMFormFieldPredefinedValue(ddmFormField.getDDMFormFieldOptions(), this._isArrayValueCPDefinitionOptionRelFieldType(cpDefinitionOptionRel), predefinedValueKey));
    }
}

