/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.product.definitions.web.internal.constants;

import com.liferay.commerce.product.constants.CPPortletKeys;

/**
 * @author Alessio Antonio Rendina
 */
public class CommerceProductFDSNames {

	public static final String ALL_PRODUCT_INSTANCES =
		CPPortletKeys.CP_DEFINITIONS + "-allProductInstances";

	public static final String PRODUCT_ACCOUNT_GROUPS =
		CPPortletKeys.CP_DEFINITIONS + "-productAccountGroups";

	public static final String PRODUCT_ATTACHMENTS =
		CPPortletKeys.CP_DEFINITIONS + "-productAttachments";

	public static final String PRODUCT_CHANNELS =
		CPPortletKeys.CP_DEFINITIONS + "-productChannels";

	public static final String PRODUCT_DEFINITION_SPECIFICATIONS =
		CPPortletKeys.CP_DEFINITIONS + "-productDefinitionSpecifications";

	public static final String PRODUCT_DEFINITIONS =
		CPPortletKeys.CP_DEFINITIONS + "-productDefinitions";

	public static final String PRODUCT_DISPLAY_PAGES =
		CPPortletKeys.CP_DEFINITIONS + "-productDisplayPages";

	public static final String PRODUCT_IMAGES =
		CPPortletKeys.CP_DEFINITIONS + "-productImages";

	public static final String PRODUCT_INSTANCES =
		CPPortletKeys.CP_DEFINITIONS + "-productInstances";

	public static final String PRODUCT_LINKS =
		CPPortletKeys.CP_DEFINITIONS + "-productLinks";

	public static final String PRODUCT_OPTION_VALUES =
		CPPortletKeys.CP_DEFINITIONS + "-productOptionValues";

	public static final String PRODUCT_OPTION_VALUES_STATIC =
		CPPortletKeys.CP_DEFINITIONS + "-productOptionValuesStatic";

	public static final String PRODUCT_OPTIONS =
		CPPortletKeys.CP_DEFINITIONS + "-productOptions";

	/**
	 * @deprecated As of Athanasius (7.3.x)
	 */
	@Deprecated
	public static final String PRODUCT_PRICING_CLASSES =
		CPPortletKeys.CP_DEFINITIONS + "-productPricingClasses";

}