/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.product.definitions.web.internal.constants;

import com.liferay.commerce.product.constants.CPPortletKeys;

/**
 * @author Alessio Antonio Rendina
 */
public class CommerceProductFDSNames {

	public static final String ALL_PRODUCT_INSTANCES =
		CPPortletKeys.CP_DEFINITIONS + "-allProductInstances";

	public static final String PRODUCT_ACCOUNT_GROUPS =
		CPPortletKeys.CP_DEFINITIONS + "-productAccountGroups";

	public static final String PRODUCT_ATTACHMENTS =
		CPPortletKeys.CP_DEFINITIONS + "-productAttachments";

	public static final String PRODUCT_CHANNELS =
		CPPortletKeys.CP_DEFINITIONS + "-productChannels";

	public static final String PRODUCT_DEFINITION_SPECIFICATIONS =
		CPPortletKeys.CP_DEFINITIONS + "-productDefinitionSpecifications";

	public static final String PRODUCT_DEFINITIONS =
		CPPortletKeys.CP_DEFINITIONS + "-productDefinitions";

	public static final String PRODUCT_DISPLAY_PAGES =
		CPPortletKeys.CP_DEFINITIONS + "-productDisplayPages";

	public static final String PRODUCT_IMAGES =
		CPPortletKeys.CP_DEFINITIONS + "-productImages";

	public static final String PRODUCT_INSTANCES =
		CPPortletKeys.CP_DEFINITIONS + "-productInstances";

	public static final String PRODUCT_LINKS =
		CPPortletKeys.CP_DEFINITIONS + "-productLinks";

	public static final String PRODUCT_OPTION_VALUES =
		CPPortletKeys.CP_DEFINITIONS + "-productOptionValues";

	public static final String PRODUCT_OPTION_VALUES_STATIC =
		CPPortletKeys.CP_DEFINITIONS + "-productOptionValuesStatic";

	public static final String PRODUCT_OPTIONS =
		CPPortletKeys.CP_DEFINITIONS + "-productOptions";

	/**
	 * @deprecated As of Athanasius (7.3.x)
	 */
	@Deprecated
	public static final String PRODUCT_PRICING_CLASSES =
		CPPortletKeys.CP_DEFINITIONS + "-productPricingClasses";

}