/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.catalog;

import com.liferay.commerce.product.catalog.CPCatalogEntry;
import com.liferay.commerce.product.catalog.CPSku;
import com.liferay.commerce.product.internal.catalog.CPSkuImpl;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class DatabaseCPCatalogEntryImpl
implements CPCatalogEntry {
    private final CPDefinition _cpDefinition;
    private final CPInstanceLocalService _cpInstanceLocalService;
    private final String _languageId;

    public DatabaseCPCatalogEntryImpl(CPDefinition cpDefinition, CPInstanceLocalService cpInstanceLocalService, Locale locale) {
        this._cpDefinition = cpDefinition;
        this._cpInstanceLocalService = cpInstanceLocalService;
        this._languageId = LanguageUtil.getLanguageId((Locale)locale);
    }

    public long getCPDefinitionId() {
        return this._cpDefinition.getCPDefinitionId();
    }

    public long getCProductId() {
        return this._cpDefinition.getCProductId();
    }

    public List<CPSku> getCPSkus() {
        ArrayList<CPSku> cpSkus = new ArrayList<CPSku>();
        List cpInstances = this._cpInstanceLocalService.getCPDefinitionInstances(this._cpDefinition.getCPDefinitionId(), 0, -1, -1, null);
        for (CPInstance cpInstance : cpInstances) {
            cpSkus.add(new CPSkuImpl(cpInstance));
        }
        return cpSkus;
    }

    public String getDefaultImageFileUrl() {
        try {
            return this._cpDefinition.getDefaultImageFileURL();
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    public double getDepth() {
        return this._cpDefinition.getDepth();
    }

    public String getDescription() {
        return this._cpDefinition.getDescription(this._languageId);
    }

    public long getGroupId() {
        return this._cpDefinition.getGroupId();
    }

    public double getHeight() {
        return this._cpDefinition.getHeight();
    }

    public String getMetaDescription(String languageId) {
        return this._cpDefinition.getMetaDescription(languageId);
    }

    public String getMetaKeywords(String languageId) {
        return this._cpDefinition.getMetaKeywords(languageId);
    }

    public String getMetaTitle(String languageId) {
        return this._cpDefinition.getMetaTitle(languageId);
    }

    public String getName() {
        return this._cpDefinition.getName(this._languageId);
    }

    public String getProductTypeName() {
        return this._cpDefinition.getProductTypeName();
    }

    public String getShortDescription() {
        return this._cpDefinition.getShortDescription(this._languageId);
    }

    public String getUrl() {
        return this._cpDefinition.getURL(this._languageId);
    }

    public boolean isIgnoreSKUCombinations() {
        return this._cpDefinition.isIgnoreSKUCombinations();
    }
}

