/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.catalog;

import com.liferay.commerce.product.catalog.CPCatalogEntry;
import com.liferay.commerce.product.catalog.CPSku;
import com.liferay.commerce.product.internal.catalog.CPSkuImpl;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class IndexCPCatalogEntryImpl
implements CPCatalogEntry {
    private final CPDefinitionLocalService _cpDefinitionLocalService;
    private final CPInstanceLocalService _cpInstanceLocalService;
    private final Document _document;
    private final Locale _locale;

    public IndexCPCatalogEntryImpl(Document document, CPDefinitionLocalService cpDefinitionLocalService, CPInstanceLocalService cpInstanceLocalService, Locale locale) {
        this._document = document;
        this._cpDefinitionLocalService = cpDefinitionLocalService;
        this._cpInstanceLocalService = cpInstanceLocalService;
        this._locale = locale;
    }

    public long getCPDefinitionId() {
        return GetterUtil.getLong((String)this._document.get("entryClassPK"));
    }

    public long getCProductId() {
        return GetterUtil.getLong((String)this._document.get("cpProductId"));
    }

    public List<CPSku> getCPSkus() {
        ArrayList<CPSku> cpSkus = new ArrayList<CPSku>();
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinition(this.getCPDefinitionId());
        if (cpDefinition == null) {
            return cpSkus;
        }
        List cpInstances = this._cpInstanceLocalService.getCPDefinitionInstances(cpDefinition.getCPDefinitionId(), 0, -1, -1, null);
        for (CPInstance cpInstance : cpInstances) {
            cpSkus.add(new CPSkuImpl(cpInstance));
        }
        return cpSkus;
    }

    public String getDefaultImageFileUrl() {
        return this._document.get("defaultImageFileUrl");
    }

    public double getDepth() {
        return GetterUtil.getDouble((String)this._document.get("depth"));
    }

    public String getDescription() {
        return this._document.get(this._locale, "description");
    }

    public long getGroupId() {
        return GetterUtil.getLong((String)this._document.get("groupId"));
    }

    public double getHeight() {
        return GetterUtil.getDouble((String)this._document.get("height"));
    }

    public String getMetaDescription(String languageId) {
        return this._document.get(this._locale, "metaDescription");
    }

    public String getMetaKeywords(String languageId) {
        return this._document.get(this._locale, "metaKeywords");
    }

    public String getMetaTitle(String languageId) {
        return this._document.get(this._locale, "metaTitle");
    }

    public String getName() {
        return this._document.get(this._locale, "name");
    }

    public String getProductTypeName() {
        return this._document.get("productTypeName");
    }

    public String getShortDescription() {
        return this._document.get(this._locale, "shortDescription");
    }

    public String getUrl() {
        return this._document.get(this._locale, "url");
    }

    public boolean isIgnoreSKUCombinations() {
        return GetterUtil.getBoolean((String)this._document.get("isIgnoreSKUCombinations"));
    }
}

