/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.data.source;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.commerce.product.catalog.CPQuery;
import com.liferay.commerce.product.data.source.CPDataSource;
import com.liferay.commerce.product.internal.data.source.BaseCPDataSourceAssetEntryImpl;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.util.CPDefinitionHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"commerce.product.data.source.name=assetTagsDataSource"}, service={CPDataSource.class})
public class CPDataSourceAssetTagsImpl
extends BaseCPDataSourceAssetEntryImpl {
    public static final String NAME = "assetTagsDataSource";
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;

    public String getLabel(Locale locale) {
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(locale), (String)"products-of-the-same-tags");
    }

    public String getName() {
        return NAME;
    }

    @Override
    protected CPQuery getCPQuery(long cpDefinitionId) throws PortalException {
        CPQuery cpQuery = new CPQuery();
        cpQuery.setAnyTagIds(this._getTagIds(cpDefinitionId));
        return cpQuery;
    }

    private long[] _getTagIds(long cpDefinitionId) throws PortalException {
        AssetEntry assetEntry = this._assetEntryLocalService.getEntry(CPDefinition.class.getName(), cpDefinitionId);
        List assetTags = assetEntry.getTags();
        long[] tagIds = new long[assetTags.size()];
        for (int i = 0; i < assetTags.size(); ++i) {
            AssetTag assetTag = (AssetTag)assetTags.get(i);
            tagIds[i] = assetTag.getTagId();
        }
        return tagIds;
    }

    @Reference(unbind="-")
    private void _setCPDefinitionHelper(CPDefinitionHelper cpDefinitionHelper) {
        this.cpDefinitionHelper = cpDefinitionHelper;
    }

    @Reference(unbind="-")
    private void _setPortal(Portal portal) {
        this.portal = portal;
    }
}

