/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.data.source;

import com.liferay.commerce.product.data.source.CPDataSource;
import com.liferay.commerce.product.data.source.CPDataSourceRegistry;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CPDataSourceRegistry.class})
public class CPDataSourceRegistryImpl
implements CPDataSourceRegistry {
    private static final Log _log = LogFactoryUtil.getLog(CPDataSourceRegistryImpl.class);
    @Reference
    private Portal _portal;
    private ServiceTrackerList<CPDataSource, CPDataSource> _serviceTrackerList;

    public CPDataSource getCPDataSource(String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        for (CPDataSource cpDataSource : this._serviceTrackerList) {
            if (!key.equals(cpDataSource.getName())) continue;
            return cpDataSource;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("No commerce product data source registered with key " + key));
        }
        return null;
    }

    public List<CPDataSource> getCPDataSources() {
        ArrayList<CPDataSource> cpDataSources = new ArrayList<CPDataSource>();
        for (CPDataSource cpDataSource : this._serviceTrackerList) {
            if (!Validator.isNotNull((String)cpDataSource.getName())) continue;
            cpDataSources.add(cpDataSource);
        }
        return Collections.unmodifiableList(cpDataSources);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, CPDataSource.class);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
    }
}

