/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.importer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.commerce.product.importer.CPFileImporter;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.ThemeSetting;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.resource.bundle.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ClassResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CPFileImporter.class})
public class CPFileImporterImpl
implements CPFileImporter {
    public static final String GROUP_ID_PLACEHOLDER = "[$GROUP_ID$]";
    public static final String IMG_TAG = "<img alt='' src='%s' data-fileentryid='%s' />";
    public static final String LOCALE_PLACEHOLDER = "[$LOCALE$]";
    private static final Log _log = LogFactoryUtil.getLog(CPFileImporterImpl.class);
    private static final Pattern _journalArticleHTMLImagePattern = Pattern.compile("\\[%([^\\[%]+)%\\]");
    private static final Pattern _journalArticleJSONImagePattern = Pattern.compile("\\[\\$([^\\[%]+)\\$\\]");
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private DDM _ddm;
    @Reference
    private DDMFormDeserializer _ddmFormDeserializer;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private ThemeLocalService _themeLocalService;

    public void cleanLayouts(ServiceContext serviceContext) throws PortalException {
        this._layoutLocalService.deleteLayouts(serviceContext.getScopeGroupId(), true, serviceContext);
        this._layoutLocalService.deleteLayouts(serviceContext.getScopeGroupId(), false, serviceContext);
    }

    public void createJournalArticles(JSONArray journalArticleJSONArray, ClassLoader classLoader, String dependenciesFilePath, ServiceContext serviceContext) throws Exception {
        for (int i = 0; i < journalArticleJSONArray.length(); ++i) {
            JSONObject journalArticleJSONObject = journalArticleJSONArray.getJSONObject(i);
            this.createJournalArticle(journalArticleJSONObject, classLoader, dependenciesFilePath, serviceContext);
        }
    }

    public void createLayouts(JSONArray jsonArray, ClassLoader classLoader, String dependenciesFilePath, ServiceContext serviceContext) throws Exception {
        this.createLayouts(jsonArray, null, classLoader, dependenciesFilePath, serviceContext);
    }

    public void createRoles(JSONArray jsonArray, ServiceContext serviceContext) throws PortalException {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            JSONObject actionsJSONObject = jsonObject.getJSONObject("actions");
            String name = jsonObject.getString("name");
            int scope = jsonObject.getInt("scope");
            int type = jsonObject.getInt("type");
            Role role = this.getRole(name, type, serviceContext);
            if (actionsJSONObject != null) {
                this.updateActions(role, actionsJSONObject, scope, serviceContext);
                continue;
            }
            JSONArray actionsJSONArray = jsonObject.getJSONArray("actions");
            for (int j = 0; j < actionsJSONArray.length(); ++j) {
                this.updateActions(role, actionsJSONArray.getJSONObject(j), scope, serviceContext);
            }
        }
    }

    public DDMTemplate getDDMTemplate(File file, long classNameId, long classPK, long resourceClassNameId, String name, String type, String mode, String language, ServiceContext serviceContext) throws Exception {
        if (file == null) {
            return this._ddmTemplateLocalService.fetchTemplate(serviceContext.getScopeGroupId(), classNameId, this.getKey(name));
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        String script = StringUtil.read((InputStream)bufferedInputStream);
        return this.fetchOrAddDDMTemplate(classNameId, classPK, resourceClassNameId, name, type, mode, language, script, serviceContext);
    }

    public void updateLogo(File file, boolean privateLayout, boolean logo, ServiceContext serviceContext) throws PortalException {
        this._layoutSetLocalService.updateLogo(serviceContext.getScopeGroupId(), privateLayout, logo, file);
    }

    public void updateLookAndFeel(String themeId, boolean privateLayout, ServiceContext serviceContext) throws PortalException {
        Theme theme = this._themeLocalService.fetchTheme(serviceContext.getCompanyId(), themeId);
        if (theme == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("No Theme registered with themeId: " + themeId));
            }
            return;
        }
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(serviceContext.getScopeGroupId(), privateLayout);
        UnicodeProperties typeSettingUnicodeProperties = layoutSet.getSettingsProperties();
        this.setThemeSettingProperties(theme, typeSettingUnicodeProperties);
        this._layoutSetLocalService.updateLookAndFeel(serviceContext.getScopeGroupId(), privateLayout, themeId, "", "");
    }

    protected void addLayoutPortlets(JSONArray jsonArray, Layout layout, String layoutTemplateId, ClassLoader classLoader, ServiceContext serviceContext) throws Exception {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, layoutTemplateId, false);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject portletJSONObject = jsonArray.getJSONObject(i);
            String portletId = this.addPortletId(portletJSONObject, layoutTypePortlet, serviceContext);
            this.setPortletPreferences(portletJSONObject.getJSONObject("portletPreferences"), layout, portletId, serviceContext);
            this.setPortletLookAndFeel(portletJSONObject.getJSONObject("lookAndFeel"), layout, portletId, classLoader);
        }
    }

    protected String addPortletId(JSONObject jsonObject, LayoutTypePortlet layoutTypePortlet, ServiceContext serviceContext) throws Exception {
        String layoutColumnId = jsonObject.getString("layoutColumnId");
        int layoutColumnPos = jsonObject.getInt("layoutColumnPos");
        String portletName = jsonObject.getString("portletName");
        return layoutTypePortlet.addPortletId(serviceContext.getUserId(), portletName, layoutColumnId, layoutColumnPos, false);
    }

    protected JournalArticle createJournalArticle(JSONObject jsonObject, ClassLoader classLoader, String dependenciesFilePath, ServiceContext serviceContext) throws Exception {
        String articleId = jsonObject.getString("articleId");
        articleId = StringUtil.toUpperCase((String)StringUtil.trim((String)articleId));
        JournalArticle journalArticle = this._journalArticleLocalService.fetchArticle(serviceContext.getScopeGroupId(), articleId);
        if (journalArticle != null) {
            return journalArticle;
        }
        String ddmStructureKey = jsonObject.getString("ddmStructureKey");
        String ddmTemplateKey = jsonObject.getString("ddmTemplateKey");
        DDMStructure ddmStructure = this.fetchOrAddDDMStructure(ddmStructureKey, classLoader, dependenciesFilePath, ddmStructureKey + ".json", serviceContext);
        InputStream inputStream = classLoader.getResourceAsStream(dependenciesFilePath + ddmTemplateKey + ".ftl");
        if (inputStream != null) {
            this.fetchOrAddDDMTemplate(this._portal.getClassNameId(DDMStructure.class), ddmStructure.getStructureId(), this._portal.getClassNameId(JournalArticle.class), ddmTemplateKey, "display", null, "ftl", StringUtil.read((InputStream)inputStream), serviceContext);
        }
        Locale locale = serviceContext.getLocale();
        HashMap titleMap = HashMapBuilder.put((Object)locale, (Object)jsonObject.getString("title")).build();
        HashMap descriptionMap = HashMapBuilder.put((Object)locale, (Object)jsonObject.getString("description")).build();
        String content = StringUtil.read((ClassLoader)classLoader, (String)(dependenciesFilePath + articleId + ".xml"));
        content = this.getNormalizedContent(content, classLoader, dependenciesFilePath, serviceContext);
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        int displayDateMonth = displayCalendar.get(2);
        int displayDateDay = displayCalendar.get(5);
        int displayDateYear = displayCalendar.get(1);
        int displayDateHour = displayCalendar.get(10);
        int displayDateMinute = displayCalendar.get(12);
        int displayDateAmPm = displayCalendar.get(9);
        if (displayDateAmPm == 1) {
            displayDateHour += 12;
        }
        journalArticle = this._journalArticleLocalService.addArticle(null, serviceContext.getUserId(), serviceContext.getScopeGroupId(), 0L, 0L, 0L, articleId, false, 1.0, (Map)titleMap, (Map)descriptionMap, (Map)titleMap, content, ddmStructureKey, ddmTemplateKey, "", displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, false, "", null, null, "", serviceContext);
        JSONArray permissionsJSONArray = jsonObject.getJSONArray("permissions");
        if (permissionsJSONArray != null && permissionsJSONArray.length() > 0) {
            this.updatePermissions(journalArticle.getCompanyId(), journalArticle.getModelClassName(), String.valueOf(journalArticle.getResourcePrimKey()), permissionsJSONArray);
        } else {
            this.updatePermissions(journalArticle.getCompanyId(), journalArticle.getModelClassName(), String.valueOf(journalArticle.getResourcePrimKey()), null);
        }
        return journalArticle;
    }

    protected void createLayout(JSONObject jsonObject, Layout parentLayout, ClassLoader classLoader, String dependenciesFilePath, ServiceContext serviceContext) throws Exception {
        JSONArray sublayoutsJSONArray;
        JSONArray portletsJSONArray;
        JSONObject lookAndFeelJSONObject;
        boolean hidden = jsonObject.getBoolean("hidden");
        String icon = jsonObject.getString("icon");
        String layoutType = jsonObject.getString("layoutType", "portlet");
        String name = jsonObject.getString("name");
        boolean privateLayout = jsonObject.getBoolean("privateLayout");
        long parentLayoutId = 0L;
        if (parentLayout != null) {
            parentLayoutId = parentLayout.getLayoutId();
        }
        String friendlyURL = StringUtil.toLowerCase((String)name);
        friendlyURL = friendlyURL.trim();
        friendlyURL = FriendlyURLNormalizerUtil.normalize((String)friendlyURL);
        friendlyURL = '/' + friendlyURL;
        Layout layout = this._layoutLocalService.addLayout(serviceContext.getUserId(), serviceContext.getScopeGroupId(), privateLayout, parentLayoutId, name, name, "", layoutType, hidden, friendlyURL, serviceContext);
        if (Validator.isNotNull((String)icon)) {
            String filePath = dependenciesFilePath + "layout_icons/" + icon;
            InputStream inputStream = classLoader.getResourceAsStream(filePath);
            byte[] byteArray = FileUtil.getBytes((InputStream)inputStream);
            layout = this._layoutLocalService.updateIconImage(layout.getPlid(), byteArray);
        }
        if ((lookAndFeelJSONObject = jsonObject.getJSONObject("lookAndFeel")) != null) {
            layout = this.updateLayoutLookAndFeel(lookAndFeelJSONObject, layout);
        }
        if ((portletsJSONArray = jsonObject.getJSONArray("portlets")) != null && portletsJSONArray.length() > 0) {
            String layoutTemplateId = jsonObject.getString("layoutTemplateId");
            this.addLayoutPortlets(portletsJSONArray, layout, layoutTemplateId, classLoader, serviceContext);
        }
        layout = this._layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
        JSONArray permissionsJSONArray = jsonObject.getJSONArray("permissions");
        if (permissionsJSONArray != null && permissionsJSONArray.length() > 0) {
            this.updatePermissions(layout.getCompanyId(), layout.getModelClassName(), String.valueOf(layout.getPlid()), permissionsJSONArray);
        }
        if ((sublayoutsJSONArray = jsonObject.getJSONArray("subLayouts")) != null && sublayoutsJSONArray.length() > 0) {
            this.createLayouts(sublayoutsJSONArray, layout, classLoader, dependenciesFilePath, serviceContext);
        }
    }

    protected void createLayouts(JSONArray jsonArray, Layout parentLayout, ClassLoader classLoader, String dependenciesFilePath, ServiceContext serviceContext) throws Exception {
        for (int i = 0; i < jsonArray.length(); ++i) {
            this.createLayout(jsonArray.getJSONObject(i), parentLayout, classLoader, dependenciesFilePath, serviceContext);
        }
    }

    protected void deleteThemeSettingsProperties(UnicodeProperties typeSettingsUnicodeProperties, String device) {
        String keyPrefix = ThemeSettingImpl.namespaceProperty((String)device);
        Set keys = typeSettingsUnicodeProperties.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!key.startsWith(keyPrefix)) continue;
            iterator.remove();
        }
    }

    protected DDMStructure fetchOrAddDDMStructure(String ddmStructureKey, ClassLoader classLoader, String dependencyFilePath, String ddmStructureFileName, ServiceContext serviceContext) throws Exception {
        long classNameId = this._portal.getClassNameId(JournalArticle.class);
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(serviceContext.getScopeGroupId(), classNameId, ddmStructureKey, true);
        if (ddmStructure != null) {
            return ddmStructure;
        }
        Map<Locale, String> nameMap = Collections.singletonMap(serviceContext.getLocale(), TextFormatter.format((String)ddmStructureKey, (int)9));
        String json = StringUtil.read((ClassLoader)classLoader, (String)(dependencyFilePath + ddmStructureFileName));
        json = this.getNormalizedContent(json, classLoader, dependencyFilePath, serviceContext);
        DDMFormDeserializerDeserializeRequest ddmFormDeserializerDeserializeRequest = DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)json).build();
        DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = this._ddmFormDeserializer.deserialize(ddmFormDeserializerDeserializeRequest);
        DDMForm ddmForm = ddmFormDeserializerDeserializeResponse.getDDMForm();
        ddmForm = this._updateDDMFormAvailableLocales(ddmForm, serviceContext.getLocale());
        DDMFormLayout ddmFormLayout = this._ddm.getDefaultDDMFormLayout(ddmForm);
        return this._ddmStructureLocalService.addStructure(serviceContext.getUserId(), serviceContext.getScopeGroupId(), 0L, classNameId, ddmStructureKey, nameMap, null, ddmForm, ddmFormLayout, "json", 0, serviceContext);
    }

    protected DDMTemplate fetchOrAddDDMTemplate(long classNameId, long classPK, long resourceClassNameId, String name, String type, String mode, String language, String script, ServiceContext serviceContext) throws PortalException {
        HashMap nameMap = HashMapBuilder.put((Object)LocaleUtil.getSiteDefault(), (Object)name).build();
        DDMTemplate ddmTemplate = this._ddmTemplateLocalService.fetchTemplate(serviceContext.getScopeGroupId(), classNameId, this.getKey(name));
        ddmTemplate = ddmTemplate == null ? this._ddmTemplateLocalService.addTemplate(serviceContext.getUserId(), serviceContext.getScopeGroupId(), classNameId, classPK, resourceClassNameId, this.getKey(name), (Map)nameMap, null, type, mode, language, script, true, false, "", null, serviceContext) : this._ddmTemplateLocalService.updateTemplate(serviceContext.getUserId(), ddmTemplate.getTemplateId(), classPK, (Map)nameMap, null, type, mode, language, script, true, serviceContext);
        return ddmTemplate;
    }

    protected FileEntry fetchOrAddFileEntry(ClassLoader classLoader, String dependenciesFilePath, String fileName, ServiceContext serviceContext) throws Exception {
        FileEntry fileEntry;
        block3: {
            fileEntry = null;
            try {
                fileEntry = this._dlAppLocalService.getFileEntry(serviceContext.getScopeGroupId(), 0L, fileName);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        if (fileEntry != null) {
            return fileEntry;
        }
        String filePath = dependenciesFilePath + fileName;
        InputStream inputStream = classLoader.getResourceAsStream(filePath);
        String mimeType = MimeTypesUtil.getContentType((String)fileName);
        byte[] byteArray = FileUtil.getBytes((InputStream)inputStream);
        return this._dlAppLocalService.addFileEntry(null, serviceContext.getUserId(), serviceContext.getScopeGroupId(), 0L, fileName, mimeType, fileName, "", "", byteArray, null, null, serviceContext);
    }

    protected long getAssetEntryId(String articleId, ServiceContext serviceContext) throws PortalException {
        if (Validator.isNull((String)articleId)) {
            return 0L;
        }
        JournalArticle journalArticle = this._journalArticleLocalService.fetchArticle(serviceContext.getScopeGroupId(), articleId);
        if (journalArticle == null) {
            return 0L;
        }
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
        if (assetEntry == null) {
            return 0L;
        }
        return assetEntry.getEntryId();
    }

    protected String getKey(String name) {
        name = StringUtil.replace((String)name, (char)' ', (char)'-');
        name = StringUtil.toUpperCase((String)name);
        return name;
    }

    protected String getNormalizedContent(String content, ClassLoader classLoader, String dependenciesFilePath, ServiceContext serviceContext) throws Exception {
        content = StringUtil.replace((String)content, (String)GROUP_ID_PLACEHOLDER, (String)String.valueOf(serviceContext.getScopeGroupId()));
        content = StringUtil.replace((String)content, (String)LOCALE_PLACEHOLDER, (String)LocaleUtil.toLanguageId((Locale)serviceContext.getLocale()));
        content = this._replaceJournalArticleImages(content, _journalArticleHTMLImagePattern, (UnsafeFunction<FileEntry, String, Exception>)((UnsafeFunction)fileEntry -> {
            String previewURL = DLUtil.getDownloadURL((FileEntry)fileEntry, (FileVersion)fileEntry.getLatestFileVersion(), null, (String)"", (boolean)false, (boolean)false);
            return String.format(IMG_TAG, previewURL, String.valueOf(fileEntry.getFileEntryId()));
        }), classLoader, dependenciesFilePath, serviceContext);
        content = this._replaceJournalArticleImages(content, _journalArticleJSONImagePattern, (UnsafeFunction<FileEntry, String, Exception>)((UnsafeFunction)fileEntry -> {
            JSONObject jsonObject = this._jsonFactory.createJSONObject();
            jsonObject.put("alt", fileEntry.getTitle()).put("groupId", fileEntry.getGroupId()).put("name", fileEntry.getFileName()).put("title", fileEntry.getTitle()).put("type", "document").put("url", this._portletFileRepository.getDownloadPortletFileEntryURL(serviceContext.getThemeDisplay(), fileEntry, "")).put("uuid", fileEntry.getUuid());
            return jsonObject.toJSONString();
        }), classLoader, dependenciesFilePath, serviceContext);
        return content;
    }

    protected Role getRole(String name, int type, ServiceContext serviceContext) throws PortalException {
        Role role = this._roleLocalService.fetchRole(serviceContext.getCompanyId(), name);
        if (role == null) {
            role = this._roleLocalService.addRole(serviceContext.getUserId(), null, 0L, name, (Map)HashMapBuilder.put((Object)serviceContext.getLocale(), (Object)name).build(), null, type, null, serviceContext);
        }
        return role;
    }

    protected void setLocalizedValues(PortletPreferences portletPreferences, ResourceBundleLoader resourceBundleLoader, long groupId, String key, String value) throws PortletException {
        for (Locale locale : LanguageUtil.getAvailableLocales((long)groupId)) {
            ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
            portletPreferences.setValue(key + "_" + LanguageUtil.getLanguageId((Locale)locale), LanguageUtil.get((ResourceBundle)resourceBundle, (String)value));
        }
    }

    protected void setPortletLookAndFeel(JSONObject jsonObject, Layout layout, String portletId, ClassLoader classLoader) throws Exception {
        if (jsonObject == null) {
            return;
        }
        PortletPreferencesIds portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds((long)layout.getCompanyId(), (long)layout.getGroupId(), (long)layout.getPlid(), (String)portletId, (String)"portletInstance");
        PortletPreferences portletPreferences = this._portletPreferencesLocalService.getPreferences(portletPreferencesIds);
        AggregateResourceBundleLoader resourceBundleLoader = new AggregateResourceBundleLoader(new ResourceBundleLoader[]{new ClassResourceBundleLoader("content.Language", classLoader), ResourceBundleLoaderUtil.getPortalResourceBundleLoader()});
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = jsonObject.getString(key);
            if (key.equals("portletSetupTitle")) {
                this.setLocalizedValues(portletPreferences, (ResourceBundleLoader)resourceBundleLoader, layout.getGroupId(), key, value);
                continue;
            }
            portletPreferences.setValue(key, value);
        }
        portletPreferences.store();
    }

    protected void setPortletPreferences(JSONObject jsonObject, Layout layout, String portletId, ServiceContext serviceContext) throws Exception {
        if (jsonObject == null) {
            return;
        }
        PortletPreferencesIds portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds((long)layout.getGroupId(), (long)0L, (Layout)layout, (String)portletId, (boolean)false);
        PortletPreferences portletPreferences = this._portletPreferencesLocalService.getPreferences(portletPreferencesIds);
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = jsonObject.getString(key);
            if (key.equals("assetEntryId")) {
                String articleId = jsonObject.getString("articleId");
                value = String.valueOf(this.getAssetEntryId(articleId, serviceContext));
            } else if (key.equals("groupId")) {
                value = String.valueOf(serviceContext.getScopeGroupId());
            }
            portletPreferences.setValue(key, value);
        }
        portletPreferences.store();
    }

    protected void setThemeSettingProperties(Theme theme, UnicodeProperties typeSettingUnicodeProperties) {
        String device = "regular";
        this.deleteThemeSettingsProperties(typeSettingUnicodeProperties, device);
        Map themeSettings = theme.getConfigurableSettings();
        for (Map.Entry entry : themeSettings.entrySet()) {
            ThemeSetting themeSetting = (ThemeSetting)entry.getValue();
            String value = themeSetting.getValue();
            if (value.equals(themeSetting.getValue())) continue;
            typeSettingUnicodeProperties.setProperty(ThemeSettingImpl.namespaceProperty((String)device, (String)((String)entry.getKey())), value);
        }
    }

    protected void updateAction(Role role, String resource, String actionId, int scope, ServiceContext serviceContext) throws PortalException {
        if (scope == 1) {
            this._resourcePermissionLocalService.addResourcePermission(serviceContext.getCompanyId(), resource, scope, String.valueOf(role.getCompanyId()), role.getRoleId(), actionId);
        } else if (scope == 3) {
            this._resourcePermissionLocalService.addResourcePermission(serviceContext.getCompanyId(), resource, 3, String.valueOf(0L), role.getRoleId(), actionId);
        } else if (scope == 2) {
            this._resourcePermissionLocalService.removeResourcePermissions(serviceContext.getCompanyId(), resource, 2, role.getRoleId(), actionId);
            this._resourcePermissionLocalService.addResourcePermission(serviceContext.getCompanyId(), resource, 2, String.valueOf(serviceContext.getScopeGroupId()), role.getRoleId(), actionId);
        }
    }

    protected void updateActions(Role role, JSONObject jsonObject, int scope, ServiceContext serviceContext) throws PortalException {
        String resource = jsonObject.getString("resource");
        JSONArray actionIdsJSONArray = jsonObject.getJSONArray("actionIds");
        for (int i = 0; i < actionIdsJSONArray.length(); ++i) {
            String actionId = actionIdsJSONArray.getString(i);
            this.updateAction(role, resource, actionId, scope, serviceContext);
        }
    }

    protected Layout updateLayoutLookAndFeel(JSONObject jsonObject, Layout layout) {
        UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Set typeSettingPropertiesKeys = typeSettingsUnicodeProperties.keySet();
            if (typeSettingPropertiesKeys.contains(key)) {
                typeSettingsUnicodeProperties.replace((Object)key, (Object)jsonObject.getString(key));
                continue;
            }
            typeSettingsUnicodeProperties.put(key, jsonObject.getString(key));
        }
        layout.setTypeSettingsProperties(typeSettingsUnicodeProperties);
        return layout;
    }

    protected void updatePermissions(long companyId, String name, String primKey, JSONArray jsonArray) throws PortalException {
        if (jsonArray == null) {
            jsonArray = JSONFactoryUtil.createJSONArray((String)"[{\"actionIds\": [\"VIEW\"], \"roleName\": \"Site Member\",\"scope\": 4}]");
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            int scope = jsonObject.getInt("scope");
            String roleName = jsonObject.getString("roleName");
            Role role = this._roleLocalService.getRole(companyId, roleName);
            Object[] actionIds = new String[]{};
            JSONArray actionIdsJSONArray = jsonObject.getJSONArray("actionIds");
            if (actionIdsJSONArray != null) {
                for (int j = 0; j < actionIdsJSONArray.length(); ++j) {
                    actionIds = (String[])ArrayUtil.append((Object[])actionIds, (Object)actionIdsJSONArray.getString(j));
                }
            }
            this._resourcePermissionLocalService.setResourcePermissions(companyId, name, scope, primKey, role.getRoleId(), (String[])actionIds);
        }
    }

    private String _replaceJournalArticleImages(String content, Pattern pattern, UnsafeFunction<FileEntry, String, Exception> replacementFunction, ClassLoader classLoader, String dependenciesFilePath, ServiceContext serviceContext) throws Exception {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String fileName = matcher.group(1);
            FileEntry fileEntry = this.fetchOrAddFileEntry(classLoader, dependenciesFilePath, fileName, serviceContext);
            String replacement = (String)replacementFunction.apply((Object)fileEntry);
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private DDMForm _updateDDMFormAvailableLocales(DDMForm ddmForm, Locale locale) {
        Set availableLocales = ddmForm.getAvailableLocales();
        availableLocales.add(locale);
        ddmForm.setAvailableLocales(availableLocales);
        ddmForm.setDefaultLocale(locale);
        return ddmForm;
    }
}

