/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.layout.admin.util;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.asset.kernel.service.AssetVocabularyService;
import com.liferay.commerce.product.url.CPFriendlyURL;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.layout.admin.kernel.util.Sitemap;
import com.liferay.layout.admin.kernel.util.SitemapURLProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={SitemapURLProvider.class})
public class AssetCategorySitemapURLProvider
implements SitemapURLProvider {
    @Reference
    private AssetCategoryService _assetCategoryService;
    @Reference
    private AssetVocabularyService _assetVocabularyService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CPFriendlyURL _cpFriendlyURL;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private Sitemap _sitemap;

    public String getClassName() {
        return AssetCategory.class.getName();
    }

    public void visitLayout(Element element, String layoutUuid, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        Group group;
        Company company;
        List assetVocabularies;
        long plid = this._portal.getPlidFromPortletId(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), "com_liferay_commerce_product_content_web_internal_portlet_CPCategoryContentPortlet");
        Layout layout = this._layoutLocalService.getLayout(plid);
        if (layoutUuid.equals(layout.getUuid()) && (assetVocabularies = this._assetVocabularyService.getGroupVocabularies((company = this._companyLocalService.getCompany((group = layoutSet.getGroup()).getCompanyId())).getGroupId(), group.getName(themeDisplay.getLocale()), -1, -1, null)).size() == 1) {
            AssetVocabulary assetVocabulary = (AssetVocabulary)assetVocabularies.get(0);
            List assetCategories = this._assetCategoryService.getVocabularyRootCategories(assetVocabulary.getGroupId(), assetVocabulary.getVocabularyId(), -1, -1, null);
            for (AssetCategory assetCategory : assetCategories) {
                this.visitLayout(element, layout, assetCategory.getCategoryId(), themeDisplay);
            }
        }
    }

    public void visitLayoutSet(Element element, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
    }

    protected void visitLayout(Element element, Layout layout, long assetCategoryId, ThemeDisplay themeDisplay) throws PortalException {
        if (layout.isSystem()) {
            return;
        }
        UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
        if (!GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("sitemap-include"), (boolean)true)) {
            return;
        }
        String currentSiteURL = this._portal.getGroupFriendlyURL(layout.getLayoutSet(), themeDisplay);
        String urlSeparator = this._cpFriendlyURL.getAssetCategoryURLSeparator(themeDisplay.getCompanyId());
        FriendlyURLEntry friendlyURLEntry = this._friendlyURLEntryLocalService.getMainFriendlyURLEntry(this._portal.getClassNameId(AssetCategory.class), assetCategoryId);
        String categoryFriendlyURL = currentSiteURL + urlSeparator + friendlyURLEntry.getUrlTitle(themeDisplay.getLanguageId());
        this._sitemap.addURLElement(element, categoryFriendlyURL, typeSettingsUnicodeProperties, layout.getModifiedDate(), categoryFriendlyURL, null);
    }
}

