/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.layout.admin.util;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.product.catalog.CPCatalogEntry;
import com.liferay.commerce.product.catalog.CPQuery;
import com.liferay.commerce.product.data.source.CPDataSourceResult;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.url.CPFriendlyURL;
import com.liferay.commerce.product.util.CPDefinitionHelper;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.layout.admin.kernel.util.Sitemap;
import com.liferay.layout.admin.kernel.util.SitemapURLProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.xml.Element;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={SitemapURLProvider.class})
public class CPDefinitionSitemapURLProvider
implements SitemapURLProvider {
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CPDefinitionHelper _cpDefinitionHelper;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPFriendlyURL _cpFriendlyURL;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private Sitemap _sitemap;

    public String getClassName() {
        return CPDefinition.class.getName();
    }

    public void visitLayout(Element element, String layoutUuid, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        long plid = this._portal.getPlidFromPortletId(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), "com_liferay_commerce_product_content_web_internal_portlet_CPContentPortlet");
        Layout layout = this._layoutLocalService.getLayout(plid);
        if (layoutUuid.equals(layout.getUuid())) {
            long groupId = this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(layoutSet.getGroupId());
            CommerceAccount commerceAccount = this._commerceAccountHelper.getCurrentCommerceAccount(themeDisplay.getRequest());
            SearchContext searchContext = new SearchContext();
            searchContext.setAttributes((Map)HashMapBuilder.put((Object)"status", (Object)0).put((Object)"commerceAccountGroupIds", (Object)this._commerceAccountHelper.getCommerceAccountGroupIds(commerceAccount.getCommerceAccountId())).put((Object)"commerceChannelGroupId", (Object)groupId).build());
            searchContext.setCompanyId(themeDisplay.getCompanyId());
            CPQuery cpQuery = new CPQuery();
            cpQuery.setOrderByCol1("title");
            cpQuery.setOrderByCol2("modifiedDate");
            cpQuery.setOrderByType1("ASC");
            cpQuery.setOrderByType2("DESC");
            CPDataSourceResult cpDataSourceResult = this._cpDefinitionHelper.search(groupId, searchContext, cpQuery, -1, -1);
            for (CPCatalogEntry cpCatalogEntry : cpDataSourceResult.getCPCatalogEntries()) {
                if (!layoutUuid.equals(layout.getUuid())) continue;
                this.visitLayout(element, layout, cpCatalogEntry.getCPDefinitionId(), themeDisplay);
            }
        }
    }

    public void visitLayoutSet(Element element, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
    }

    protected void visitLayout(Element element, Layout layout, long cpDefinitionId, ThemeDisplay themeDisplay) throws PortalException {
        if (layout.isSystem()) {
            return;
        }
        UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
        if (!GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("sitemap-include"), (boolean)true)) {
            return;
        }
        String currentSiteURL = this._portal.getGroupFriendlyURL(layout.getLayoutSet(), themeDisplay);
        String urlSeparator = this._cpFriendlyURL.getProductURLSeparator(themeDisplay.getCompanyId());
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        FriendlyURLEntry friendlyURLEntry = this._friendlyURLEntryLocalService.getMainFriendlyURLEntry(this._portal.getClassNameId(CProduct.class), cpDefinition.getCProductId());
        String productFriendlyURL = currentSiteURL + urlSeparator + friendlyURLEntry.getUrlTitle(themeDisplay.getLanguageId());
        this._sitemap.addURLElement(element, productFriendlyURL, typeSettingsUnicodeProperties, layout.getModifiedDate(), productFriendlyURL, null);
    }
}

