/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.model.listener;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.commerce.product.service.CPAttachmentFileEntryLocalService;
import com.liferay.commerce.product.service.CPDisplayLayoutLocalService;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={ModelListener.class})
public class AssetCategoryModelListener
extends BaseModelListener<AssetCategory> {
    private static final Log _log = LogFactoryUtil.getLog(AssetCategoryModelListener.class);
    @Reference
    private CPAttachmentFileEntryLocalService _cpAttachmentFileEntryLocalService;
    @Reference
    private CPDisplayLayoutLocalService _cpDisplayLayoutLocalService;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;

    public void onAfterCreate(AssetCategory assetCategory) throws ModelListenerException {
        block2: {
            try {
                Group companyGroup = this._groupLocalService.getCompanyGroup(assetCategory.getCompanyId());
                this._friendlyURLEntryLocalService.addFriendlyURLEntry(companyGroup.getGroupId(), this._portal.getClassNameId(AssetCategory.class), assetCategory.getCategoryId(), this._getUniqueUrlTitles(assetCategory), new ServiceContext());
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)portalException, (Throwable)portalException);
            }
        }
    }

    public void onBeforeRemove(AssetCategory assetCategory) {
        block2: {
            try {
                this._cpAttachmentFileEntryLocalService.deleteCPAttachmentFileEntries(AssetCategory.class.getName(), assetCategory.getCategoryId());
                this._cpDisplayLayoutLocalService.deleteCPDisplayLayouts(AssetCategory.class, assetCategory.getCategoryId());
                Group companyGroup = this._groupLocalService.getCompanyGroup(assetCategory.getCompanyId());
                this._friendlyURLEntryLocalService.deleteFriendlyURLEntry(companyGroup.getGroupId(), AssetCategory.class, assetCategory.getCategoryId());
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)portalException, (Throwable)portalException);
            }
        }
    }

    private Map<String, String> _getUniqueUrlTitles(AssetCategory assetCategory) throws PortalException {
        HashMap<String, String> urlTitleMap = new HashMap<String, String>();
        Map titleMap = assetCategory.getTitleMap();
        for (Map.Entry titleEntry : titleMap.entrySet()) {
            Group companyGroup = this._groupLocalService.getCompanyGroup(assetCategory.getCompanyId());
            String urlTitle = this._friendlyURLEntryLocalService.getUniqueUrlTitle(companyGroup.getGroupId(), this._portal.getClassNameId(AssetCategory.class), assetCategory.getCategoryId(), (String)titleEntry.getValue());
            urlTitleMap.put(LocaleUtil.toLanguageId((Locale)((Locale)titleEntry.getKey())), urlTitle);
        }
        return urlTitleMap;
    }
}

