/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.model.listener;

import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPMeasurementUnitLocalService;
import com.liferay.commerce.product.service.CPTaxCategoryLocalService;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ModelListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={ModelListener.class})
public class CompanyModelListener
extends BaseModelListener<Company> {
    private static final Log _log = LogFactoryUtil.getLog(CompanyModelListener.class);
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPMeasurementUnitLocalService _cpMeasurementUnitLocalService;
    @Reference
    private CPTaxCategoryLocalService _cpTaxCategoryLocalService;

    public void onBeforeRemove(Company company) {
        try {
            long companyId = company.getCompanyId();
            this._cpDefinitionLocalService.deleteCPDefinitions(companyId);
            this._cpMeasurementUnitLocalService.deleteCPMeasurementUnits(companyId);
            this._cpTaxCategoryLocalService.deleteCPTaxCategories(companyId);
            this._commerceCatalogLocalService.deleteCommerceCatalogs(companyId);
            this._commerceChannelLocalService.deleteCommerceChannels(companyId);
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
        }
    }
}

