/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.model.listener;

import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPOptionValue;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={ModelListener.class})
public class ExpandoColumnModelListener
extends BaseModelListener<ExpandoColumn> {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;

    public void onAfterRemove(ExpandoColumn expandoColumn) throws ModelListenerException {
        if (expandoColumn == null) {
            return;
        }
        try {
            if (this._checkCPOptionValueExpandoColumn(expandoColumn.getTableId())) {
                this._removeCPDefinitionOptionValueRelExpandoColumn(expandoColumn);
            }
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    public void onAfterUpdate(ExpandoColumn expandoColumn) throws ModelListenerException {
        try {
            if (this._checkCPOptionValueExpandoColumn(expandoColumn.getTableId())) {
                this._copyToCPDefinitionOptionValueRelExpandoColumn(expandoColumn);
            }
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private boolean _checkCPOptionValueExpandoColumn(long tableId) throws PortalException {
        ExpandoTable expandoTable = this._expandoTableLocalService.fetchExpandoTable(tableId);
        if (expandoTable == null) {
            return false;
        }
        return Objects.equals(expandoTable.getClassName(), CPOptionValue.class.getName());
    }

    private void _copyToCPDefinitionOptionValueRelExpandoColumn(ExpandoColumn cpOptionValueExpandoColumn) throws PortalException {
        ExpandoTable cpDefinitionOptionValueRelExpandoTable = this._expandoTableLocalService.addDefaultTable(cpOptionValueExpandoColumn.getCompanyId(), this._classNameLocalService.getClassNameId(CPDefinitionOptionValueRel.class.getName()));
        ExpandoColumn cpDefinitionOptionValueRelExpandoColumn = this._expandoColumnLocalService.addColumn(cpDefinitionOptionValueRelExpandoTable.getTableId(), cpOptionValueExpandoColumn.getName(), cpOptionValueExpandoColumn.getType(), (Object)cpOptionValueExpandoColumn.getDefaultValue());
        cpDefinitionOptionValueRelExpandoColumn.setTypeSettingsProperties(cpOptionValueExpandoColumn.getTypeSettingsProperties());
        this._expandoColumnLocalService.updateExpandoColumn(cpDefinitionOptionValueRelExpandoColumn);
    }

    private void _removeCPDefinitionOptionValueRelExpandoColumn(ExpandoColumn cpOptionValueExpandoColumn) throws PortalException {
        ExpandoTable cpDefinitionOptionValueRelExpandoTable = this._expandoTableLocalService.fetchDefaultTable(cpOptionValueExpandoColumn.getCompanyId(), this._classNameLocalService.getClassNameId(CPDefinitionOptionValueRel.class.getName()));
        if (cpDefinitionOptionValueRelExpandoTable == null) {
            return;
        }
        this._expandoColumnLocalService.deleteColumn(cpDefinitionOptionValueRelExpandoTable.getTableId(), cpOptionValueExpandoColumn.getName());
        int count = this._expandoColumnLocalService.getColumnsCount(cpDefinitionOptionValueRelExpandoTable.getTableId());
        if (count == 0) {
            this._expandoTableLocalService.deleteTable(cpDefinitionOptionValueRelExpandoTable.getTableId());
        }
    }
}

