/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.model.listener;

import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.Company;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={PortalInstanceLifecycleListener.class})
public class PortalInstanceLifecycleListenerImpl
extends BasePortalInstanceLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(PortalInstanceLifecycleListenerImpl.class);
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;

    public void portalInstanceRegistered(Company company) throws Exception {
        try {
            List commerceCatalogs = this._commerceCatalogLocalService.getCommerceCatalogs(company.getCompanyId(), true);
            if (commerceCatalogs.isEmpty()) {
                CommerceCatalog commerceCatalog = this._commerceCatalogLocalService.addDefaultCommerceCatalog(company.getCompanyId());
                Message message = new Message();
                message.put("commerceCatalogId", (Object)commerceCatalog.getCommerceCatalogId());
                MessageBusUtil.sendMessage((String)"liferay/base_price_list", (Message)message);
            }
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
        }
    }
}

