/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.option;

import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.option.CommerceOptionValue;
import com.liferay.commerce.product.option.CommerceOptionValueHelper;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelLocalService;
import com.liferay.commerce.product.util.JsonHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommerceOptionValueHelper.class})
public class CommerceOptionValueHelperImpl
implements CommerceOptionValueHelper {
    @Reference
    private CPDefinitionOptionRelLocalService _cpDefinitionOptionRelLocalService;
    @Reference
    private CPDefinitionOptionValueRelLocalService _cpDefinitionOptionValueRelLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private JsonHelper _jsonHelper;

    public List<CommerceOptionValue> getCPDefinitionCommerceOptionValues(long cpDefinitionId, String json) throws PortalException {
        Map cpDefinitionOptionRelCPDefinitionOptionValueRelIds = this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelCPDefinitionOptionValueRelIds(cpDefinitionId, json);
        if (cpDefinitionOptionRelCPDefinitionOptionValueRelIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CommerceOptionValue> commerceOptionValues = new ArrayList<CommerceOptionValue>();
        for (Map.Entry entry : cpDefinitionOptionRelCPDefinitionOptionValueRelIds.entrySet()) {
            Long key = (Long)entry.getKey();
            List value = (List)entry.getValue();
            Iterator iterator = value.iterator();
            while (iterator.hasNext()) {
                CPDefinitionOptionValueRel cpDefinitionOptionValueRel;
                long cpDefinitionOptionValueRelId = (Long)iterator.next();
                CPDefinitionOptionRel cpDefinitionOptionRel = this._cpDefinitionOptionRelLocalService.fetchCPDefinitionOptionRel(key.longValue());
                if (cpDefinitionOptionRel == null || (cpDefinitionOptionValueRel = this._cpDefinitionOptionValueRelLocalService.fetchCPDefinitionOptionValueRel(cpDefinitionOptionValueRelId)) == null) continue;
                CommerceOptionValue.Builder commerceOptionValueBuilder = new CommerceOptionValue.Builder();
                commerceOptionValueBuilder.optionKey(cpDefinitionOptionRel.getKey());
                commerceOptionValueBuilder.optionValueKey(cpDefinitionOptionValueRel.getKey());
                if (!cpDefinitionOptionRel.isPriceContributor()) {
                    commerceOptionValues.add(commerceOptionValueBuilder.build());
                    continue;
                }
                commerceOptionValueBuilder.priceType(cpDefinitionOptionRel.getPriceType());
                commerceOptionValueBuilder.price(cpDefinitionOptionValueRel.getPrice());
                commerceOptionValueBuilder.quantity(cpDefinitionOptionValueRel.getQuantity());
                CPInstance cpDefinitionOptionValueRelCPInstance = cpDefinitionOptionValueRel.fetchCPInstance();
                if (cpDefinitionOptionValueRelCPInstance != null) {
                    commerceOptionValueBuilder.cpInstanceId(cpDefinitionOptionValueRelCPInstance.getCPInstanceId());
                    if (cpDefinitionOptionRel.isPriceTypeDynamic()) {
                        commerceOptionValueBuilder.price(cpDefinitionOptionValueRelCPInstance.getPrice());
                    }
                }
                commerceOptionValues.add(commerceOptionValueBuilder.build());
            }
        }
        return commerceOptionValues;
    }

    public CommerceOptionValue toCommerceOptionValue(String json) throws JSONException {
        return this._toCommerceOptionValue(this._jsonFactory.createJSONObject(json));
    }

    public List<CommerceOptionValue> toCommerceOptionValues(String json) throws JSONException {
        ArrayList<CommerceOptionValue> commerceOptionValues = new ArrayList<CommerceOptionValue>();
        JSONArray commerceOptionValuesJSONArray = this._jsonHelper.getJSONArray(json);
        for (int i = 0; i < commerceOptionValuesJSONArray.length(); ++i) {
            JSONObject jsonObject = commerceOptionValuesJSONArray.getJSONObject(i);
            JSONArray valueJSONArray = this._jsonHelper.getValueAsJSONArray("value", jsonObject);
            if (valueJSONArray.length() > 0) {
                for (int j = 0; j < valueJSONArray.length(); ++j) {
                    String value = valueJSONArray.getString(j);
                    jsonObject.put("value", value);
                    commerceOptionValues.add(this._toCommerceOptionValue(jsonObject));
                }
                continue;
            }
            commerceOptionValues.add(this._toCommerceOptionValue(jsonObject));
        }
        return commerceOptionValues;
    }

    private CommerceOptionValue _toCommerceOptionValue(JSONObject jsonObject) {
        CommerceOptionValue.Builder commerceOptionValueBuilder = new CommerceOptionValue.Builder();
        commerceOptionValueBuilder.optionKey(jsonObject.getString("key"));
        JSONArray valueJSONArray = this._jsonHelper.getValueAsJSONArray("value", jsonObject);
        if (valueJSONArray.length() > 0) {
            commerceOptionValueBuilder.optionValueKey(valueJSONArray.getString(0));
        }
        if (jsonObject.has("priceType")) {
            commerceOptionValueBuilder.priceType(jsonObject.getString("priceType"));
        }
        if (jsonObject.has("price")) {
            commerceOptionValueBuilder.price(new BigDecimal(jsonObject.getString("price")));
        }
        if (jsonObject.has("quantity")) {
            commerceOptionValueBuilder.quantity(jsonObject.getInt("quantity"));
        }
        if (jsonObject.has("cpInstanceId")) {
            commerceOptionValueBuilder.cpInstanceId(jsonObject.getLong("cpInstanceId"));
        }
        return commerceOptionValueBuilder.build();
    }
}

