/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.osgi.commands;

import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"osgi.command.function=createProducts", "osgi.command.scope=commerce"}, service={CPOSGiCommands.class})
public class CPOSGiCommands {
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void createProducts(long groupId, String prefix, int quantity) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        User user = this._userLocalService.getDefaultUser(group.getCompanyId());
        List commerceCatalogs = this._commerceCatalogLocalService.getCommerceCatalogs(user.getCompanyId(), true);
        CommerceCatalog commerceCatalog = (CommerceCatalog)commerceCatalogs.get(0);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setTimeZone(user.getTimeZone());
        serviceContext.setUserId(user.getUserId());
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        displayCalendar.add(1, -1);
        int displayDateMonth = displayCalendar.get(2);
        int displayDateDay = displayCalendar.get(5);
        int displayDateYear = displayCalendar.get(1);
        int displayDateHour = displayCalendar.get(10);
        int displayDateMinute = displayCalendar.get(12);
        int displayDateAmPm = displayCalendar.get(9);
        if (displayDateAmPm == 1) {
            displayDateHour += 12;
        }
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        for (int i = 0; i < quantity; ++i) {
            String title = prefix + i;
            titleMap.put(LocaleUtil.US, title);
            this._cpDefinitionLocalService.addCPDefinition(null, commerceCatalog.getGroupId(), user.getUserId(), titleMap, null, null, null, null, null, null, "simple", true, false, false, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0L, false, false, null, true, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, 0, 0, 0, 0, 0, true, "default", false, 0, null, null, 0L, serviceContext);
        }
    }
}

