/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.permission;

import com.liferay.commerce.product.model.CPOptionCategory;
import com.liferay.commerce.product.permission.CPOptionCategoryPermission;
import com.liferay.commerce.product.service.CPOptionCategoryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CPOptionCategoryPermission.class})
public class CPOptionCategoryPermissionImpl
implements CPOptionCategoryPermission {
    @Reference
    private CPOptionCategoryLocalService _cpOptionCategoryLocalService;

    public void check(PermissionChecker permissionChecker, CPOptionCategory cpOptionCategory, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, cpOptionCategory, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CPOptionCategory.class.getName(), cpOptionCategory.getCPOptionCategoryId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long cpOptionCategoryId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, cpOptionCategoryId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CPOptionCategory.class.getName(), cpOptionCategoryId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CPOptionCategory cpOptionCategory, String actionId) throws PortalException {
        return this.contains(permissionChecker, cpOptionCategory.getCPOptionCategoryId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long cpOptionCategoryId, String actionId) throws PortalException {
        CPOptionCategory cpOptionCategory = this._cpOptionCategoryLocalService.fetchCPOptionCategory(cpOptionCategoryId);
        if (cpOptionCategory == null) {
            return false;
        }
        return this._contains(permissionChecker, cpOptionCategory, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long[] cpOptionCategoryIds, String actionId) throws PortalException {
        if (ArrayUtil.isEmpty((long[])cpOptionCategoryIds)) {
            return false;
        }
        for (long cpOptionCategoryId : cpOptionCategoryIds) {
            if (this.contains(permissionChecker, cpOptionCategoryId, actionId)) continue;
            return false;
        }
        return true;
    }

    private boolean _contains(PermissionChecker permissionChecker, CPOptionCategory cpOptionCategory, String actionId) throws PortalException {
        if (permissionChecker.isCompanyAdmin(cpOptionCategory.getCompanyId()) || permissionChecker.isOmniadmin()) {
            return true;
        }
        if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), CPOptionCategory.class.getName(), cpOptionCategory.getCPOptionCategoryId(), permissionChecker.getUserId(), actionId) && cpOptionCategory.getUserId() == permissionChecker.getUserId()) {
            return true;
        }
        return permissionChecker.hasPermission(null, CPOptionCategory.class.getName(), cpOptionCategory.getCPOptionCategoryId(), actionId);
    }
}

