/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.permission;

import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.permission.CPOptionPermission;
import com.liferay.commerce.product.service.CPOptionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CPOptionPermission.class})
public class CPOptionPermissionImpl
implements CPOptionPermission {
    @Reference
    private CPOptionLocalService _cpOptionLocalService;

    public void check(PermissionChecker permissionChecker, CPOption cpOption, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, cpOption, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CPOption.class.getName(), cpOption.getCPOptionId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long cpOptionId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, cpOptionId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CPOption.class.getName(), cpOptionId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CPOption cpOption, String actionId) throws PortalException {
        return this.contains(permissionChecker, cpOption.getCPOptionId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long cpOptionId, String actionId) throws PortalException {
        CPOption cpOption = this._cpOptionLocalService.fetchCPOption(cpOptionId);
        if (cpOption == null) {
            return false;
        }
        return this._contains(permissionChecker, cpOption, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long[] cpOptionIds, String actionId) throws PortalException {
        if (ArrayUtil.isEmpty((long[])cpOptionIds)) {
            return false;
        }
        for (long cpOptionId : cpOptionIds) {
            if (this.contains(permissionChecker, cpOptionId, actionId)) continue;
            return false;
        }
        return true;
    }

    private boolean _contains(PermissionChecker permissionChecker, CPOption cpOption, String actionId) throws PortalException {
        if (permissionChecker.isCompanyAdmin(cpOption.getCompanyId()) || permissionChecker.isOmniadmin()) {
            return true;
        }
        if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), CPOption.class.getName(), cpOption.getCPOptionId(), permissionChecker.getUserId(), actionId) && cpOption.getUserId() == permissionChecker.getUserId()) {
            return true;
        }
        return permissionChecker.hasPermission(null, CPOption.class.getName(), cpOption.getCPOptionId(), actionId);
    }
}

