/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.permission;

import com.liferay.commerce.product.model.CPSpecificationOption;
import com.liferay.commerce.product.permission.CPSpecificationOptionPermission;
import com.liferay.commerce.product.service.CPSpecificationOptionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CPSpecificationOptionPermission.class})
public class CPSpecificationOptionPermissionImpl
implements CPSpecificationOptionPermission {
    @Reference
    private CPSpecificationOptionLocalService _cpSpecificationOptionLocalService;

    public void check(PermissionChecker permissionChecker, CPSpecificationOption cpSpecificationOption, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, cpSpecificationOption, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CPSpecificationOption.class.getName(), cpSpecificationOption.getCPSpecificationOptionId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long cpSpecificationOptionId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, cpSpecificationOptionId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CPSpecificationOption.class.getName(), cpSpecificationOptionId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CPSpecificationOption cpSpecificationOption, String actionId) throws PortalException {
        return this.contains(permissionChecker, cpSpecificationOption.getCPSpecificationOptionId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long cpSpecificationOptionId, String actionId) throws PortalException {
        CPSpecificationOption cpSpecificationOption = this._cpSpecificationOptionLocalService.fetchCPSpecificationOption(cpSpecificationOptionId);
        if (cpSpecificationOption == null) {
            return false;
        }
        return this._contains(permissionChecker, cpSpecificationOption, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long[] cpSpecificationOptionIds, String actionId) throws PortalException {
        if (ArrayUtil.isEmpty((long[])cpSpecificationOptionIds)) {
            return false;
        }
        for (long cpSpecificationOptionId : cpSpecificationOptionIds) {
            if (this.contains(permissionChecker, cpSpecificationOptionId, actionId)) continue;
            return false;
        }
        return true;
    }

    private boolean _contains(PermissionChecker permissionChecker, CPSpecificationOption cpSpecificationOption, String actionId) throws PortalException {
        if (permissionChecker.isCompanyAdmin(cpSpecificationOption.getCompanyId()) || permissionChecker.isOmniadmin()) {
            return true;
        }
        if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), CPSpecificationOption.class.getName(), cpSpecificationOption.getCPSpecificationOptionId(), permissionChecker.getUserId(), actionId) && cpSpecificationOption.getUserId() == permissionChecker.getUserId()) {
            return true;
        }
        return permissionChecker.hasPermission(null, CPSpecificationOption.class.getName(), cpSpecificationOption.getCPSpecificationOptionId(), actionId);
    }
}

