/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.permission;

import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.permission.CommerceCatalogPermission;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommerceCatalogPermission.class})
public class CommerceCatalogPermissionImpl
implements CommerceCatalogPermission {
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;

    public void check(PermissionChecker permissionChecker, CommerceCatalog commerceCatalog, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceCatalog, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceCatalog.class.getName(), commerceCatalog.getCommerceCatalogId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long commerceCatalogId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceCatalogId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceCatalog.class.getName(), commerceCatalogId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CommerceCatalog commerceCatalog, String actionId) throws PortalException {
        return this.contains(permissionChecker, commerceCatalog.getCommerceCatalogId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long commerceCatalogId, String actionId) throws PortalException {
        CommerceCatalog commerceCatalog = this._commerceCatalogLocalService.fetchCommerceCatalog(commerceCatalogId);
        if (commerceCatalog == null) {
            return false;
        }
        return this._contains(permissionChecker, commerceCatalog, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long[] commerceCatalogIds, String actionId) throws PortalException {
        if (ArrayUtil.isEmpty((long[])commerceCatalogIds)) {
            return false;
        }
        for (long commerceCatalogId : commerceCatalogIds) {
            if (this.contains(permissionChecker, commerceCatalogId, actionId)) continue;
            return false;
        }
        return true;
    }

    private boolean _contains(PermissionChecker permissionChecker, CommerceCatalog commerceCatalog, String actionId) throws PortalException {
        if (permissionChecker.isCompanyAdmin(commerceCatalog.getCompanyId()) || permissionChecker.isOmniadmin()) {
            return true;
        }
        if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), CommerceCatalog.class.getName(), commerceCatalog.getCommerceCatalogId(), permissionChecker.getUserId(), actionId) && commerceCatalog.getUserId() == permissionChecker.getUserId()) {
            return true;
        }
        return permissionChecker.hasPermission(commerceCatalog.getGroupId(), CommerceCatalog.class.getName(), commerceCatalog.getCommerceCatalogId(), actionId);
    }
}

