/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.permission;

import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.permission.CommerceChannelPermission;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommerceChannelPermission.class})
public class CommerceChannelPermissionImpl
implements CommerceChannelPermission {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;

    public void check(PermissionChecker permissionChecker, CommerceChannel commerceChannel, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceChannel, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceChannel.class.getName(), commerceChannel.getCommerceChannelId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long commerceChannelId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceChannelId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceChannel.class.getName(), commerceChannelId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CommerceChannel commerceChannel, String actionId) throws PortalException {
        return this.contains(permissionChecker, commerceChannel.getCommerceChannelId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long commerceChannelId, String actionId) throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannel(commerceChannelId);
        if (commerceChannel == null) {
            return false;
        }
        return this._contains(permissionChecker, commerceChannel, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long[] commerceChannelIds, String actionId) throws PortalException {
        if (ArrayUtil.isEmpty((long[])commerceChannelIds)) {
            return false;
        }
        for (long commerceChannelId : commerceChannelIds) {
            if (this.contains(permissionChecker, commerceChannelId, actionId)) continue;
            return false;
        }
        return true;
    }

    private boolean _contains(PermissionChecker permissionChecker, CommerceChannel commerceChannel, String actionId) throws PortalException {
        if (permissionChecker.isCompanyAdmin(commerceChannel.getCompanyId()) || permissionChecker.isOmniadmin()) {
            return true;
        }
        if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), CommerceChannel.class.getName(), commerceChannel.getCommerceChannelId(), permissionChecker.getUserId(), actionId) && commerceChannel.getUserId() == permissionChecker.getUserId()) {
            return true;
        }
        Group group = this._commerceChannelLocalService.getCommerceChannelGroup(commerceChannel.getCommerceChannelId());
        return permissionChecker.hasPermission(group, CommerceChannel.class.getName(), commerceChannel.getCommerceChannelId(), actionId);
    }
}

