/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.permission;

import com.liferay.commerce.account.model.CommerceAccountGroupRel;
import com.liferay.commerce.account.service.CommerceAccountGroupRelService;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelRel;
import com.liferay.commerce.product.permission.CommerceCatalogPermission;
import com.liferay.commerce.product.permission.CommerceProductViewPermission;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.service.CommerceChannelRelLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommerceProductViewPermission.class})
public class CommerceProductViewPermissionImpl
implements CommerceProductViewPermission {
    @Reference
    private CommerceAccountGroupRelService _commerceAccountGroupRelService;
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private CommerceCatalogPermission _commerceCatalogPermission;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceChannelRelLocalService _commerceChannelRelLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private GroupLocalService _groupLocalService;

    public void check(PermissionChecker permissionChecker, long commerceAccountId, long cpDefinitionId) throws PortalException {
        if (this.contains(permissionChecker, commerceAccountId, cpDefinitionId)) {
            return;
        }
        throw new PrincipalException.MustHavePermission(permissionChecker.getUserId(), CPDefinition.class.getName(), cpDefinitionId, new String[]{"VIEW"});
    }

    public void check(PermissionChecker permissionChecker, long commerceAccountId, long groupId, long cpDefinitionId) throws PortalException {
        if (this.contains(permissionChecker, commerceAccountId, groupId, cpDefinitionId)) {
            return;
        }
        throw new PrincipalException.MustHavePermission(permissionChecker.getUserId(), CPDefinition.class.getName(), cpDefinitionId, new String[]{"VIEW"});
    }

    public boolean contains(PermissionChecker permissionChecker, long commerceAccountId, long cpDefinitionId) throws PortalException {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        return this._viewCatalog(permissionChecker, cpDefinition.getCommerceCatalog()) || this._accountEnabled(commerceAccountId, cpDefinition);
    }

    public boolean contains(PermissionChecker permissionChecker, long commerceAccountId, long groupId, long cpDefinitionId) throws PortalException {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        if (!this._channelEnabled(groupId, cpDefinition)) {
            return false;
        }
        return this._viewCatalog(permissionChecker, cpDefinition.getCommerceCatalog()) || this._accountEnabled(commerceAccountId, cpDefinition);
    }

    private boolean _accountEnabled(long commerceAccountId, CPDefinition cpDefinition) throws PortalException {
        if (!cpDefinition.isAccountGroupFilterEnabled()) {
            return true;
        }
        List commerceAccountGroupRels = this._commerceAccountGroupRelService.getCommerceAccountGroupRels(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), -1, -1, null);
        long[] commerceAccountGroupIds = this._commerceAccountHelper.getCommerceAccountGroupIds(commerceAccountId);
        for (CommerceAccountGroupRel commerceAccountGroupRel : commerceAccountGroupRels) {
            if (!ArrayUtil.contains((long[])commerceAccountGroupIds, (long)commerceAccountGroupRel.getCommerceAccountGroupId())) continue;
            return true;
        }
        return false;
    }

    private boolean _channelEnabled(long groupId, CPDefinition cpDefinition) {
        if (!cpDefinition.isChannelFilterEnabled()) {
            return true;
        }
        List commerceChannelRels = this._commerceChannelRelLocalService.getCommerceChannelRels(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), -1, -1, null);
        long commerceChannelId = this._getCommerceChannelId(groupId);
        for (CommerceChannelRel commerceChannelRel : commerceChannelRels) {
            if (commerceChannelRel.getCommerceChannelId() != commerceChannelId) continue;
            return true;
        }
        return false;
    }

    private long _getCommerceChannelId(long groupId) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        String className = group.getClassName();
        if (className.equals(CommerceChannel.class.getName())) {
            return group.getClassPK();
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(groupId);
        if (commerceChannel != null) {
            return commerceChannel.getCommerceChannelId();
        }
        return 0L;
    }

    private boolean _viewCatalog(PermissionChecker permissionChecker, CommerceCatalog commerceCatalog) throws PortalException {
        return this._commerceCatalogPermission.contains(permissionChecker, commerceCatalog, "VIEW");
    }
}

