/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.portlet.action;

import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionLink;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPDefinitionSpecificationOptionValue;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.portlet.action.ActionHelper;
import com.liferay.commerce.product.service.CPAttachmentFileEntryService;
import com.liferay.commerce.product.service.CPDefinitionLinkService;
import com.liferay.commerce.product.service.CPDefinitionOptionRelService;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelService;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPDefinitionSpecificationOptionValueService;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.commerce.product.type.CPType;
import com.liferay.commerce.product.type.CPTypeServicesTracker;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={ActionHelper.class})
public class ActionHelperImpl
implements ActionHelper {
    @Reference
    private CPAttachmentFileEntryService _cpAttachmentFileEntryService;
    @Reference
    private CPDefinitionLinkService _cpDefinitionLinkService;
    @Reference
    private CPDefinitionOptionRelService _cpDefinitionOptionRelService;
    @Reference
    private CPDefinitionOptionValueRelService _cpDefinitionOptionValueRelService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPDefinitionSpecificationOptionValueService _cpDefinitionSpecificationOptionValueService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private CProductLocalService _cProductLocalService;
    @Reference
    private CPTypeServicesTracker _cpTypeServicesTracker;
    @Reference
    private Portal _portal;

    public List<CPAttachmentFileEntry> getCPAttachmentFileEntries(PortletRequest portletRequest) throws PortalException {
        long[] cpAttachmentFileEntryIds;
        ArrayList<CPAttachmentFileEntry> cpAttachmentFileEntries = new ArrayList<CPAttachmentFileEntry>();
        for (long cpAttachmentFileEntryId : cpAttachmentFileEntryIds = ParamUtil.getLongValues((PortletRequest)portletRequest, (String)"rowIds")) {
            CPAttachmentFileEntry cpAttachmentFileEntry = this._cpAttachmentFileEntryService.fetchCPAttachmentFileEntry(cpAttachmentFileEntryId);
            if (cpAttachmentFileEntry == null) continue;
            cpAttachmentFileEntries.add(cpAttachmentFileEntry);
        }
        return cpAttachmentFileEntries;
    }

    public CPAttachmentFileEntry getCPAttachmentFileEntry(PortletRequest portletRequest) throws PortalException {
        CPAttachmentFileEntry cpAttachmentFileEntry = (CPAttachmentFileEntry)portletRequest.getAttribute("CP_ATTACHMENT_FILE_ENTRY");
        if (cpAttachmentFileEntry != null) {
            return cpAttachmentFileEntry;
        }
        long cpAttachmentFileEntryId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"cpAttachmentFileEntryId");
        if (cpAttachmentFileEntryId > 0L) {
            cpAttachmentFileEntry = this._cpAttachmentFileEntryService.fetchCPAttachmentFileEntry(cpAttachmentFileEntryId);
        }
        if (cpAttachmentFileEntry != null) {
            portletRequest.setAttribute("CP_ATTACHMENT_FILE_ENTRY", (Object)cpAttachmentFileEntry);
        }
        return cpAttachmentFileEntry;
    }

    public CPDefinition getCPDefinition(PortletRequest portletRequest) throws PortalException {
        CPDefinition cpDefinition = (CPDefinition)portletRequest.getAttribute("CP_DEFINITION");
        if (cpDefinition != null) {
            return cpDefinition;
        }
        long cpDefinitionId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"cpDefinitionId");
        cpDefinition = this._validateCPDefinition(cpDefinitionId);
        if (cpDefinition != null) {
            portletRequest.setAttribute("CP_DEFINITION", (Object)cpDefinition);
        }
        return cpDefinition;
    }

    public CPDefinitionLink getCPDefinitionLink(PortletRequest portletRequest) throws PortalException {
        CPDefinitionLink cpDefinitionLink = (CPDefinitionLink)portletRequest.getAttribute("CP_DEFINITION_LINK");
        if (cpDefinitionLink != null) {
            return cpDefinitionLink;
        }
        long cpDefinitionLinkId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"cpDefinitionLinkId");
        if (cpDefinitionLinkId > 0L) {
            cpDefinitionLink = this._cpDefinitionLinkService.fetchCPDefinitionLink(cpDefinitionLinkId);
        }
        if (cpDefinitionLink != null) {
            portletRequest.setAttribute("CP_DEFINITION_LINK", (Object)cpDefinitionLink);
        }
        return cpDefinitionLink;
    }

    public List<CPDefinitionLink> getCPDefinitionLinks(PortletRequest portletRequest) throws PortalException {
        long[] cpDefinitionLinkIds;
        ArrayList<CPDefinitionLink> cpDefinitionLinks = new ArrayList<CPDefinitionLink>();
        for (long cpDefinitionLinkId : cpDefinitionLinkIds = ParamUtil.getLongValues((PortletRequest)portletRequest, (String)"rowIds")) {
            cpDefinitionLinks.add(this._cpDefinitionLinkService.getCPDefinitionLink(cpDefinitionLinkId));
        }
        return cpDefinitionLinks;
    }

    public CPDefinitionOptionRel getCPDefinitionOptionRel(PortletRequest portletRequest) throws PortalException {
        CPDefinitionOptionValueRel cpDefinitionOptionValueRel;
        CPDefinitionOptionRel cpDefinitionOptionRel = (CPDefinitionOptionRel)portletRequest.getAttribute("CP_DEFINITION_OPTION_REL");
        if (cpDefinitionOptionRel != null) {
            return cpDefinitionOptionRel;
        }
        long cpDefinitionOptionRelId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"cpDefinitionOptionRelId");
        if (cpDefinitionOptionRelId <= 0L && (cpDefinitionOptionValueRel = this.getCPDefinitionOptionValueRel(portletRequest)) != null) {
            cpDefinitionOptionRelId = cpDefinitionOptionValueRel.getCPDefinitionOptionRelId();
        }
        if (cpDefinitionOptionRelId > 0L) {
            cpDefinitionOptionRel = this._cpDefinitionOptionRelService.fetchCPDefinitionOptionRel(cpDefinitionOptionRelId);
        }
        if (cpDefinitionOptionRel != null) {
            portletRequest.setAttribute("CP_DEFINITION_OPTION_REL", (Object)cpDefinitionOptionRel);
        }
        return cpDefinitionOptionRel;
    }

    public List<CPDefinitionOptionRel> getCPDefinitionOptionRels(PortletRequest portletRequest) throws PortalException {
        long[] cpDefinitionOptionRelIds;
        ArrayList<CPDefinitionOptionRel> cpDefinitionOptionRels = new ArrayList<CPDefinitionOptionRel>();
        for (long cpDefinitionOptionRelId : cpDefinitionOptionRelIds = ParamUtil.getLongValues((PortletRequest)portletRequest, (String)"rowIds")) {
            cpDefinitionOptionRels.add(this._cpDefinitionOptionRelService.getCPDefinitionOptionRel(cpDefinitionOptionRelId));
        }
        return cpDefinitionOptionRels;
    }

    public CPDefinitionOptionValueRel getCPDefinitionOptionValueRel(PortletRequest portletRequest) throws PortalException {
        CPDefinitionOptionValueRel cpDefinitionOptionValueRel = (CPDefinitionOptionValueRel)portletRequest.getAttribute("CP_DEFINITION_OPTION_VALUE_REL");
        if (cpDefinitionOptionValueRel != null) {
            return cpDefinitionOptionValueRel;
        }
        long cpDefinitionOptionValueRelId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"cpDefinitionOptionValueRelId");
        if (cpDefinitionOptionValueRelId > 0L) {
            cpDefinitionOptionValueRel = this._cpDefinitionOptionValueRelService.fetchCPDefinitionOptionValueRel(cpDefinitionOptionValueRelId);
        }
        if (cpDefinitionOptionValueRel != null) {
            portletRequest.setAttribute("CP_DEFINITION_OPTION_VALUE_REL", (Object)cpDefinitionOptionValueRel);
        }
        return cpDefinitionOptionValueRel;
    }

    public List<CPDefinitionOptionValueRel> getCPDefinitionOptionValueRels(long cpDefinitionOptionRelId) throws PortalException {
        int total = this._cpDefinitionOptionValueRelService.getCPDefinitionOptionValueRelsCount(cpDefinitionOptionRelId);
        return this._cpDefinitionOptionValueRelService.getCPDefinitionOptionValueRels(cpDefinitionOptionRelId, 0, total);
    }

    public List<CPDefinitionOptionValueRel> getCPDefinitionOptionValueRels(PortletRequest portletRequest) throws PortalException {
        long[] cpDefinitionOptionValueRelIds;
        ArrayList<CPDefinitionOptionValueRel> cpDefinitionOptionValueRels = new ArrayList<CPDefinitionOptionValueRel>();
        for (long cpDefinitionOptionValueRelId : cpDefinitionOptionValueRelIds = ParamUtil.getLongValues((PortletRequest)portletRequest, (String)"rowIds")) {
            cpDefinitionOptionValueRels.add(this._cpDefinitionOptionValueRelService.getCPDefinitionOptionValueRel(cpDefinitionOptionValueRelId));
        }
        return cpDefinitionOptionValueRels;
    }

    public List<CPDefinition> getCPDefinitions(PortletRequest portletRequest) throws PortalException {
        long[] cpDefinitionIds;
        ArrayList<CPDefinition> cpDefinitions = new ArrayList<CPDefinition>();
        for (long cpDefinitionId : cpDefinitionIds = ParamUtil.getLongValues((PortletRequest)portletRequest, (String)"rowIds")) {
            cpDefinitions.add(this._cpDefinitionService.getCPDefinition(cpDefinitionId));
        }
        return cpDefinitions;
    }

    public CPDefinitionSpecificationOptionValue getCPDefinitionSpecificationOptionValue(PortletRequest portletRequest) throws PortalException {
        CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = (CPDefinitionSpecificationOptionValue)portletRequest.getAttribute("CP_DEFINITION_SPECIFICATION_OPTION_VALUE");
        if (cpDefinitionSpecificationOptionValue != null) {
            return cpDefinitionSpecificationOptionValue;
        }
        long cpDefinitionSpecificationOptionValueId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"cpDefinitionSpecificationOptionValueId");
        if (cpDefinitionSpecificationOptionValueId > 0L) {
            cpDefinitionSpecificationOptionValue = this._cpDefinitionSpecificationOptionValueService.fetchCPDefinitionSpecificationOptionValue(cpDefinitionSpecificationOptionValueId);
        }
        if (cpDefinitionSpecificationOptionValue != null) {
            portletRequest.setAttribute("CP_DEFINITION_SPECIFICATION_OPTION_VALUE", (Object)cpDefinitionSpecificationOptionValue);
        }
        return cpDefinitionSpecificationOptionValue;
    }

    public List<CPDefinitionSpecificationOptionValue> getCPDefinitionSpecificationOptionValues(PortletRequest portletRequest) throws PortalException {
        long[] cpDefinitionSpecificationOptionValueIds;
        ArrayList<CPDefinitionSpecificationOptionValue> cpDefinitionSpecificationOptionValues = new ArrayList<CPDefinitionSpecificationOptionValue>();
        for (long cpDefinitionSpecificationOptionValueId : cpDefinitionSpecificationOptionValueIds = ParamUtil.getLongValues((PortletRequest)portletRequest, (String)"rowIds")) {
            cpDefinitionSpecificationOptionValues.add(this._cpDefinitionSpecificationOptionValueService.getCPDefinitionSpecificationOptionValue(cpDefinitionSpecificationOptionValueId));
        }
        return cpDefinitionSpecificationOptionValues;
    }

    public CPInstance getCPInstance(PortletRequest portletRequest) throws PortalException {
        CPInstance cpInstance = (CPInstance)portletRequest.getAttribute("CP_INSTANCE");
        if (cpInstance != null) {
            return cpInstance;
        }
        long cpInstanceId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"cpInstanceId");
        if (cpInstanceId > 0L) {
            cpInstance = this._cpInstanceService.getCPInstance(cpInstanceId);
        }
        if (cpInstance != null) {
            portletRequest.setAttribute("CP_INSTANCE", (Object)cpInstance);
        }
        return cpInstance;
    }

    public List<CPInstance> getCPInstances(PortletRequest portletRequest) throws PortalException {
        long[] cpInstanceIds;
        ArrayList<CPInstance> cpInstances = new ArrayList<CPInstance>();
        for (long cpInstanceId : cpInstanceIds = ParamUtil.getLongValues((PortletRequest)portletRequest, (String)"rowIds")) {
            cpInstances.add(this._cpInstanceService.getCPInstance(cpInstanceId));
        }
        return cpInstances;
    }

    public CPType getCPType(String name) {
        return this._cpTypeServicesTracker.getCPType(name);
    }

    public List<CPType> getCPTypes() {
        return this._cpTypeServicesTracker.getCPTypes();
    }

    public List<CPDefinitionOptionRel> getSkuContributorCPDefinitionOptionRels(long cpDefinitionId) throws PortalException {
        return this._cpDefinitionOptionRelService.getCPDefinitionOptionRels(cpDefinitionId, true);
    }

    public void writeJSON(PortletRequest portletRequest, ActionResponse actionResponse, Object object) throws IOException {
        HttpServletResponse httpServletResponse = this._portal.getHttpServletResponse((PortletResponse)actionResponse);
        httpServletResponse.setContentType("application/json");
        ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)object.toString());
        httpServletResponse.flushBuffer();
    }

    private CPDefinition _validateCPDefinition(Long cpDefinitionId) throws PortalException {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinition(cpDefinitionId.longValue());
        if (cpDefinition != null) {
            CProduct cProduct = this._cProductLocalService.getCProduct(cpDefinition.getCProductId());
            if (cpDefinition.getStatus() == 0 && cpDefinitionId.longValue() != cProduct.getPublishedCPDefinitionId()) {
                cpDefinition = this._cpDefinitionService.fetchCPDefinition(cProduct.getPublishedCPDefinitionId());
            }
        }
        return cpDefinition;
    }
}

