/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.search;

import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.service.CPAttachmentFileEntryLocalService;
import com.liferay.commerce.product.util.CPInstanceHelper;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.ExistsFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={Indexer.class})
public class CPAttachmentFileEntryIndexer
extends BaseIndexer<CPAttachmentFileEntry> {
    public static final String CLASS_NAME = CPAttachmentFileEntry.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(CPAttachmentFileEntryIndexer.class);
    @Reference
    private CPAttachmentFileEntryLocalService _cpAttachmentFileEntryLocalService;
    @Reference
    private CPInstanceHelper _cpInstanceHelper;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CPAttachmentFileEntryIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "groupId", "modified", "scopeGroupId", "relatedEntityClassNameId", "relatedEntityClassPK", "relatedEntityClassPK", "fileEntryId"});
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        String[] fieldNames;
        long classPK;
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
        if (status != -1) {
            contextBooleanFilter.addRequiredTerm("status", status);
        }
        long classNameId = GetterUtil.getLong((Object)searchContext.getAttribute("relatedEntityClassNameId"));
        int type = GetterUtil.getInteger((Object)searchContext.getAttribute("type"), (int)-1);
        if (type >= 0) {
            contextBooleanFilter.addRequiredTerm("type", type);
        }
        if (classNameId > 0L) {
            contextBooleanFilter.addRequiredTerm("relatedEntityClassNameId", classNameId);
        }
        if ((classPK = GetterUtil.getLong((Object)searchContext.getAttribute("relatedEntityClassPK"))) > 0L) {
            contextBooleanFilter.addRequiredTerm("relatedEntityClassPK", classPK);
        }
        if ((fieldNames = (String[])searchContext.getAttribute("OPTIONS")) == null) {
            return;
        }
        for (String fieldName : fieldNames) {
            String[] fieldValues = (String[])searchContext.getAttribute(fieldName);
            TermsFilter termsFilter = new TermsFilter(fieldName);
            termsFilter.addValues(fieldValues);
            ExistsFilter existFilter = new ExistsFilter(fieldName);
            BooleanFilter existBooleanFilter = new BooleanFilter();
            existBooleanFilter.add((Filter)existFilter, BooleanClauseOccur.MUST_NOT);
            BooleanFilter fieldBooleanFilter = new BooleanFilter();
            fieldBooleanFilter.add((Filter)existBooleanFilter, BooleanClauseOccur.SHOULD);
            fieldBooleanFilter.add((Filter)termsFilter, BooleanClauseOccur.SHOULD);
            contextBooleanFilter.add((Filter)fieldBooleanFilter, BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchLocalizedTerm(searchQuery, searchContext, "content", false);
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "relatedEntityClassNameId", false);
        this.addSearchTerm(searchQuery, searchContext, "relatedEntityClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(CPAttachmentFileEntry cpAttachmentFileEntry) throws Exception {
        this.deleteDocument(cpAttachmentFileEntry.getCompanyId(), cpAttachmentFileEntry.getCPAttachmentFileEntryId());
    }

    protected Document doGetDocument(CPAttachmentFileEntry cpAttachmentFileEntry) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing attachment file entry " + cpAttachmentFileEntry));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)cpAttachmentFileEntry);
        document.addText("content", "");
        document.addNumber("priority", cpAttachmentFileEntry.getPriority());
        document.addNumber("type", cpAttachmentFileEntry.getType());
        document.addDateSortable("displayDate", cpAttachmentFileEntry.getDisplayDate());
        document.addNumber("relatedEntityClassNameId", cpAttachmentFileEntry.getClassNameId());
        document.addNumber("relatedEntityClassPK", cpAttachmentFileEntry.getClassPK());
        document.addNumber("fileEntryId", cpAttachmentFileEntry.getFileEntryId());
        Map cpDefinitionOptionRelListMap = this._cpInstanceHelper.getCPDefinitionOptionRelsMap(cpAttachmentFileEntry.getClassPK(), cpAttachmentFileEntry.getJson());
        for (Map.Entry cpDefinitionOptionRelListMapEntry : cpDefinitionOptionRelListMap.entrySet()) {
            CPDefinitionOptionRel cpDefinitionOptionRel = (CPDefinitionOptionRel)cpDefinitionOptionRelListMapEntry.getKey();
            CPOption cpOption = cpDefinitionOptionRel.getCPOption();
            ArrayList<String> optionValueIds = new ArrayList<String>();
            for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : (List)cpDefinitionOptionRelListMapEntry.getValue()) {
                optionValueIds.add(cpDefinitionOptionValueRel.getKey());
            }
            document.addText("ATTRIBUTE_" + cpOption.getKey() + "_VALUES_IDS", ArrayUtil.toStringArray(optionValueIds));
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + cpAttachmentFileEntry + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "relatedEntityClassNameId", "relatedEntityClassPK");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CPAttachmentFileEntry cpAttachmentFileEntry) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), cpAttachmentFileEntry.getCompanyId(), this.getDocument(cpAttachmentFileEntry), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._cpAttachmentFileEntryLocalService.getCPAttachmentFileEntry(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCPAttachmentFileEntries(companyId);
    }

    protected void reindexCPAttachmentFileEntries(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._cpAttachmentFileEntryLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(cpAttachmentFileEntry -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(cpAttachmentFileEntry)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    long cpAttachmentFileEntryId = cpAttachmentFileEntry.getCPAttachmentFileEntryId();
                    _log.warn((Object)("Unable to index commerce product attachment file entry " + cpAttachmentFileEntryId), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

