/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.search;

import com.liferay.commerce.account.model.CommerceAccountGroupRelModel;
import com.liferay.commerce.account.service.CommerceAccountGroupRelService;
import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.service.CommercePriceEntryLocalService;
import com.liferay.commerce.product.links.CPDefinitionLinkTypeRegistry;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionLink;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.model.CPSpecificationOption;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelRel;
import com.liferay.commerce.product.service.CPDefinitionLinkLocalService;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CommerceChannelRelLocalService;
import com.liferay.commerce.util.CommerceBigDecimalUtil;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.facet.util.RangeParserUtil;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.RangeTermFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={Indexer.class})
public class CPDefinitionIndexer
extends BaseIndexer<CPDefinition> {
    public static final String CLASS_NAME = CPDefinition.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(CPDefinitionIndexer.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CommerceAccountGroupRelService _commerceAccountGroupRelService;
    @Reference
    private CommerceChannelRelLocalService _commerceChannelRelLocalService;
    @Reference
    private CommerceMediaResolver _commerceMediaResolver;
    @Reference
    private CommercePriceEntryLocalService _commercePriceEntryLocalService;
    @Reference
    private CPDefinitionLinkLocalService _cpDefinitionLinkLocalService;
    @Reference
    private CPDefinitionLinkTypeRegistry _cpDefinitionLinkTypeRegistry;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CPDefinitionIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "groupId", "modified", "name", "scopeGroupId", "uid"});
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        Map attributes;
        int[] statuses = GetterUtil.getIntegerValues((Object)searchContext.getAttribute("status"));
        if (ArrayUtil.isEmpty((int[])statuses)) {
            int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
            statuses = new int[]{status};
        }
        if (!ArrayUtil.contains((int[])statuses, (int)-1)) {
            TermsFilter statusesTermsFilter = new TermsFilter("status");
            statusesTermsFilter.addValues(ArrayUtil.toStringArray((int[])statuses));
            contextBooleanFilter.add((Filter)statusesTermsFilter, BooleanClauseOccur.MUST);
        }
        if ((attributes = searchContext.getAttributes()).containsKey("basePrice")) {
            String[] basePriceRanges;
            BooleanFilter priceRangeBooleanFilter = new BooleanFilter();
            for (String basePriceRange : basePriceRanges = GetterUtil.getStringValues(attributes.get("basePrice"))) {
                String[] basePriceRangeParts = RangeParserUtil.parserRange((String)basePriceRange);
                RangeTermFilter rangeTermFilter = new RangeTermFilter("basePrice", true, true, basePriceRangeParts[0], basePriceRangeParts[1]);
                priceRangeBooleanFilter.add((Filter)rangeTermFilter, BooleanClauseOccur.SHOULD);
            }
            contextBooleanFilter.add((Filter)priceRangeBooleanFilter, BooleanClauseOccur.MUST);
        }
        if (attributes.containsKey("published")) {
            boolean published = GetterUtil.getBoolean(attributes.get("published"));
            contextBooleanFilter.addRequiredTerm("published", published);
        }
        if (attributes.containsKey("subscriptionEnabled")) {
            boolean subscriptionEnabled = GetterUtil.getBoolean(attributes.get("subscriptionEnabled"));
            contextBooleanFilter.addRequiredTerm("subscriptionEnabled", subscriptionEnabled);
        }
        contextBooleanFilter.addRequiredTerm("hidden", false);
        String definitionLinkType = GetterUtil.getString(attributes.get("definitionLinkType"));
        long definitionLinkCPDefinitionId = GetterUtil.getLong(attributes.get("definitionLinkCPDefinitionId"));
        if (Validator.isNotNull((String)definitionLinkType) && definitionLinkCPDefinitionId > 0L) {
            TermsFilter linkFilter = new TermsFilter(definitionLinkType);
            linkFilter.addValue(String.valueOf(definitionLinkCPDefinitionId));
            contextBooleanFilter.add((Filter)linkFilter, BooleanClauseOccur.MUST);
        }
        if (attributes.containsKey("excludedCPDefinitionId")) {
            String excludedCPDefinitionId = String.valueOf(attributes.get("excludedCPDefinitionId"));
            contextBooleanFilter.addTerm("entryClassPK", excludedCPDefinitionId, BooleanClauseOccur.MUST_NOT);
        }
        if (GetterUtil.getBoolean(attributes.get("secure"))) {
            long commerceChannelId = GetterUtil.getLong(attributes.get("commerceChannelGroupId"));
            BooleanFilter channelBooleanFilter = new BooleanFilter();
            BooleanFilter channelFilterEnableBooleanFilter = new BooleanFilter();
            channelFilterEnableBooleanFilter.addTerm("channelFilterEnabled", Boolean.TRUE.toString(), BooleanClauseOccur.MUST);
            if (commerceChannelId > 0L) {
                channelFilterEnableBooleanFilter.addTerm("channelGroupIds", String.valueOf(commerceChannelId), BooleanClauseOccur.MUST);
            } else {
                channelFilterEnableBooleanFilter.addTerm("channelGroupIds", "-1", BooleanClauseOccur.MUST);
            }
            channelBooleanFilter.add((Filter)channelFilterEnableBooleanFilter, BooleanClauseOccur.SHOULD);
            channelBooleanFilter.addTerm("channelFilterEnabled", Boolean.FALSE.toString(), BooleanClauseOccur.SHOULD);
            contextBooleanFilter.add((Filter)channelBooleanFilter, BooleanClauseOccur.MUST);
            long[] commerceAccountGroupIds = GetterUtil.getLongValues((Object)searchContext.getAttribute("commerceAccountGroupIds"), null);
            BooleanFilter accountGroupsBooleanFilter = new BooleanFilter();
            BooleanFilter accountGroupsFilteEnableBooleanFilter = new BooleanFilter();
            accountGroupsFilteEnableBooleanFilter.addTerm("accountGroupFilterEnabled", Boolean.TRUE.toString(), BooleanClauseOccur.MUST);
            if (commerceAccountGroupIds != null && commerceAccountGroupIds.length > 0) {
                BooleanFilter accountGroupIdsBooleanFilter = new BooleanFilter();
                for (long commerceAccountGroupId : commerceAccountGroupIds) {
                    TermFilter termFilter = new TermFilter("commerceAccountGroupIds", String.valueOf(commerceAccountGroupId));
                    accountGroupIdsBooleanFilter.add((Filter)termFilter, BooleanClauseOccur.SHOULD);
                }
                accountGroupsFilteEnableBooleanFilter.add((Filter)accountGroupIdsBooleanFilter, BooleanClauseOccur.MUST);
            } else {
                accountGroupsFilteEnableBooleanFilter.addTerm("commerceAccountGroupIds", "-1", BooleanClauseOccur.MUST);
            }
            accountGroupsBooleanFilter.add((Filter)accountGroupsFilteEnableBooleanFilter, BooleanClauseOccur.SHOULD);
            accountGroupsBooleanFilter.addTerm("accountGroupFilterEnabled", Boolean.FALSE.toString(), BooleanClauseOccur.SHOULD);
            contextBooleanFilter.add((Filter)accountGroupsBooleanFilter, BooleanClauseOccur.MUST);
        } else {
            long[] groupIds = searchContext.getGroupIds();
            if (groupIds == null || groupIds.length == 0) {
                contextBooleanFilter.addTerm("groupId", "-1", BooleanClauseOccur.MUST);
            }
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchLocalizedTerm(searchQuery, searchContext, "content", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "description", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "shortDescription", false);
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "name", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "name", false);
        this.addSearchTerm(searchQuery, searchContext, "skus", false);
        this.addSearchTerm(searchQuery, searchContext, "externalReferenceCode", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "specificationOptionsValuesNames", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(CPDefinition cpDefinition) throws Exception {
        this.deleteDocument(cpDefinition.getCompanyId(), cpDefinition.getCPDefinitionId());
    }

    protected Document doGetDocument(CPDefinition cpDefinition) throws Exception {
        Map languageIdToUrlTitleMap;
        List languageIds;
        String cpDefinitionDefaultLanguageId;
        Document document;
        block28: {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Indexing definition " + cpDefinition));
            }
            document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)cpDefinition);
            cpDefinitionDefaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)cpDefinition.getName());
            languageIds = this._cpDefinitionLocalService.getCPDefinitionLocalizationLanguageIds(cpDefinition.getCPDefinitionId());
            long classNameId = this._classNameLocalService.getClassNameId(CProduct.class);
            languageIdToUrlTitleMap = new HashMap();
            try {
                FriendlyURLEntry friendlyURLEntry = this._friendlyURLEntryLocalService.getMainFriendlyURLEntry(classNameId, cpDefinition.getCProductId());
                languageIdToUrlTitleMap = friendlyURLEntry.getLanguageIdToUrlTitleMap();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block28;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        for (Object languageId : languageIds) {
            String description = cpDefinition.getDescription((String)languageId);
            String name = cpDefinition.getName((String)languageId);
            String urlTitle = (String)languageIdToUrlTitleMap.get(languageId);
            String metaDescription = cpDefinition.getMetaDescription((String)languageId);
            String metaKeywords = cpDefinition.getMetaKeywords((String)languageId);
            String metaTitle = cpDefinition.getMetaTitle((String)languageId);
            String shortDescription = cpDefinition.getShortDescription((String)languageId);
            if (((String)languageId).equals(cpDefinitionDefaultLanguageId)) {
                document.addText("description", description);
                document.addText("name", name);
                document.addText("url", urlTitle);
                document.addText("metaDescription", metaDescription);
                document.addText("metaKeywords", metaKeywords);
                document.addText("metaTitle", metaTitle);
                document.addText("shortDescription", shortDescription);
                document.addText("defaultLanguageId", (String)languageId);
            }
            document.addText(LocalizationUtil.getLocalizedName((String)"name", (String)languageId), name);
            document.addText(LocalizationUtil.getLocalizedName((String)"description", (String)languageId), description);
            document.addText(LocalizationUtil.getLocalizedName((String)"url", (String)languageId), urlTitle);
            document.addText(LocalizationUtil.getLocalizedName((String)"metaDescription", (String)languageId), metaDescription);
            document.addText(LocalizationUtil.getLocalizedName((String)"metaKeywords", (String)languageId), metaKeywords);
            document.addText(LocalizationUtil.getLocalizedName((String)"metaTitle", (String)languageId), metaTitle);
            document.addText(LocalizationUtil.getLocalizedName((String)"shortDescription", (String)languageId), shortDescription);
            document.addText("content", description);
        }
        document.addText("name", cpDefinition.getName(cpDefinitionDefaultLanguageId));
        document.addText("description", cpDefinition.getDescription(cpDefinitionDefaultLanguageId));
        document.addText("url", (String)languageIdToUrlTitleMap.get(cpDefinitionDefaultLanguageId));
        document.addText("shortDescription", cpDefinition.getShortDescription(cpDefinitionDefaultLanguageId));
        ArrayList<Long> channelGroupIds = new ArrayList<Long>();
        for (CommerceChannelRel commerceChannelRel : this._commerceChannelRelLocalService.getCommerceChannelRels(cpDefinition.getModelClassName(), cpDefinition.getCPDefinitionId(), -1, -1, null)) {
            CommerceChannel commerceChannel = commerceChannelRel.getCommerceChannel();
            channelGroupIds.add(commerceChannel.getGroupId());
        }
        document.addNumber("channelGroupIds", ArrayUtil.toLongArray(channelGroupIds));
        List commerceAccountGroupRels = this._commerceAccountGroupRelService.getCommerceAccountGroupRels(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), -1, -1, null);
        Stream stream = commerceAccountGroupRels.stream();
        long[] commerceAccountGroupIds = stream.mapToLong(CommerceAccountGroupRelModel::getCommerceAccountGroupId).toArray();
        document.addNumber("commerceAccountGroupIds", commerceAccountGroupIds);
        ArrayList<String> optionNames = new ArrayList<String>();
        ArrayList<Long> optionIds = new ArrayList<Long>();
        List cpDefinitionOptionRels = cpDefinition.getCPDefinitionOptionRels();
        for (CPDefinitionOptionRel cpDefinitionOptionRel : cpDefinitionOptionRels) {
            if (!cpDefinitionOptionRel.isFacetable()) continue;
            CPOption cpOption = cpDefinitionOptionRel.getCPOption();
            optionNames.add(cpOption.getKey());
            optionIds.add(cpOption.getCPOptionId());
            List cpDefinitionOptionValueRels = cpDefinitionOptionRel.getCPDefinitionOptionValueRels();
            ArrayList<String> optionValueIds = new ArrayList<String>();
            Set availableLocales = LanguageUtil.getAvailableLocales((long)cpDefinitionOptionRel.getGroupId());
            for (Locale locale : availableLocales) {
                String languageId = LanguageUtil.getLanguageId((Locale)locale);
                ArrayList<String> localizedOptionValues = new ArrayList<String>();
                for (Object cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
                    optionValueIds.add(cpDefinitionOptionValueRel.getKey());
                    String localizedOptionValue = cpDefinitionOptionValueRel.getName(languageId);
                    if (Validator.isBlank((String)localizedOptionValue)) {
                        localizedOptionValue = cpDefinitionOptionValueRel.getName(cpDefinitionDefaultLanguageId);
                    }
                    localizedOptionValues.add(localizedOptionValue);
                }
                document.addText(StringBundler.concat((String[])new String[]{languageId, "_ATTRIBUTE_", cpOption.getKey(), "_VALUES_NAMES"}), ArrayUtil.toStringArray(localizedOptionValues));
            }
            document.addText("ATTRIBUTE_" + cpOption.getKey() + "_VALUES_IDS", ArrayUtil.toStringArray(optionValueIds));
        }
        document.addKeyword("productTypeName", cpDefinition.getProductTypeName());
        document.addKeyword("published", cpDefinition.isPublished());
        document.addKeyword("subscriptionEnabled", cpDefinition.isSubscriptionEnabled());
        document.addDateSortable("displayDate", cpDefinition.getDisplayDate());
        document.addNumber("depth", cpDefinition.getDepth());
        document.addNumber("height", cpDefinition.getHeight());
        CProduct cProduct = cpDefinition.getCProduct();
        document.addKeyword("externalReferenceCode", cProduct.getExternalReferenceCode());
        document.addKeyword("accountGroupFilterEnabled", cpDefinition.isAccountGroupFilterEnabled());
        document.addKeyword("channelFilterEnabled", cpDefinition.isChannelFilterEnabled());
        document.addKeyword("isIgnoreSKUCombinations", cpDefinition.isIgnoreSKUCombinations());
        document.addKeyword("cpProductId", cpDefinition.getCProductId());
        document.addText("optionsNames", ArrayUtil.toStringArray(optionNames));
        document.addNumber("optionsIds", ArrayUtil.toLongArray(optionIds));
        String[] skus = this._cpInstanceLocalService.getSKUs(cpDefinition.getCPDefinitionId());
        document.addText("skus", skus);
        ArrayList<String> specificationOptionNames = new ArrayList<String>();
        ArrayList<Long> specificationOptionIds = new ArrayList<Long>();
        ArrayList<String> specificationOptionValuesNames = new ArrayList<String>();
        List cpDefinitionSpecificationOptionValues = cpDefinition.getCPDefinitionSpecificationOptionValues();
        for (Object cpDefinitionSpecificationOptionValue : cpDefinitionSpecificationOptionValues) {
            CPSpecificationOption cpSpecificationOption = cpDefinitionSpecificationOptionValue.getCPSpecificationOption();
            if (!cpSpecificationOption.isFacetable()) continue;
            specificationOptionNames.add(cpSpecificationOption.getKey());
            specificationOptionIds.add(cpSpecificationOption.getCPSpecificationOptionId());
            String specificationOptionValue = cpDefinitionSpecificationOptionValue.getValue(cpDefinitionDefaultLanguageId);
            specificationOptionValuesNames.add(specificationOptionValue);
            Set availableLocales = LanguageUtil.getAvailableLocales((long)cpDefinitionSpecificationOptionValue.getGroupId());
            for (Locale locale : availableLocales) {
                String localeSpecificationValueName;
                Field field;
                String languageId = LanguageUtil.getLanguageId((Locale)locale);
                String localizedSpecificationOptionValue = cpDefinitionSpecificationOptionValue.getValue(languageId);
                if (Validator.isBlank((String)localizedSpecificationOptionValue)) {
                    localizedSpecificationOptionValue = specificationOptionValue;
                }
                if ((field = document.getField(localeSpecificationValueName = StringBundler.concat((String[])new String[]{languageId, "_SPECIFICATION_", cpSpecificationOption.getKey(), "_VALUE_NAME"}))) != null) {
                    String[] currentValues = field.getValues();
                    ArrayList<String> valuesArrayList = new ArrayList<String>(Arrays.asList(currentValues));
                    valuesArrayList.add(localizedSpecificationOptionValue);
                    String[] valuesArray = valuesArrayList.toArray(new String[0]);
                    document.addText(localeSpecificationValueName, valuesArray);
                    continue;
                }
                document.addText(localeSpecificationValueName, localizedSpecificationOptionValue);
            }
            String specificationValueName = "SPECIFICATION_" + cpSpecificationOption.getKey() + "_VALUE_NAME";
            Field field = document.getField(specificationValueName);
            if (field != null) {
                String[] currentValues = field.getValues();
                ArrayList<String> valuesArrayList = new ArrayList<String>(Arrays.asList(currentValues));
                valuesArrayList.add(specificationOptionValue);
                String[] valuesArray = valuesArrayList.toArray(new String[0]);
                document.addText(specificationValueName, valuesArray);
            } else {
                document.addText(specificationValueName, specificationOptionValue);
            }
            String specificationValueId = "SPECIFICATION_" + cpSpecificationOption.getKey() + "_VALUE_ID";
            long cpDefinitionSpecificationOptionValueId = cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId();
            field = document.getField(specificationValueId);
            if (field != null) {
                String[] currentValues = field.getValues();
                ArrayList<String> valuesArrayList = new ArrayList<String>(Arrays.asList(currentValues));
                valuesArrayList.add(String.valueOf(cpDefinitionSpecificationOptionValueId));
                String[] valuesArray = valuesArrayList.toArray(new String[0]);
                document.addNumber(specificationValueId, valuesArray);
                continue;
            }
            document.addNumber(specificationValueId, cpDefinitionSpecificationOptionValueId);
        }
        document.addText("specificationOptionsNames", ArrayUtil.toStringArray(specificationOptionNames));
        document.addNumber("specificationOptionsIds", ArrayUtil.toLongArray(specificationOptionIds));
        document.addText("specificationOptionsValuesNames", ArrayUtil.toStringArray(specificationOptionValuesNames));
        List types = this._cpDefinitionLinkTypeRegistry.getTypes();
        for (String type : types) {
            if (Validator.isNull((String)type)) continue;
            String[] linkedProductIds = this.getReverseCPDefinitionIds(cProduct.getCProductId(), type);
            document.addKeyword(type, linkedProductIds);
        }
        long cpAttachmentFileEntryId = 0L;
        CPAttachmentFileEntry cpAttachmentFileEntry = this._cpDefinitionLocalService.getDefaultImage(cpDefinition.getCPDefinitionId());
        if (cpAttachmentFileEntry != null) {
            document.addNumber("defaultImageFileEntryId", cpAttachmentFileEntry.getFileEntryId());
            cpAttachmentFileEntryId = cpAttachmentFileEntry.getCPAttachmentFileEntryId();
        }
        if (cpAttachmentFileEntryId == 0L) {
            document.addKeyword("defaultImageFileUrl", this._commerceMediaResolver.getDefaultURL(cpDefinition.getGroupId()));
        } else {
            document.addKeyword("defaultImageFileUrl", this._commerceMediaResolver.getURL(-1L, cpAttachmentFileEntryId, false, false, false));
        }
        if (cpDefinition.getStatus() != 0 && cpDefinition.getCPDefinitionId() != cProduct.getPublishedCPDefinitionId() && this._cpDefinitionLocalService.isVersionable(cpDefinition.getCPDefinitionId())) {
            document.addKeyword("hidden", true);
        } else {
            document.addKeyword("hidden", false);
        }
        CommerceCatalog commerceCatalog = cpDefinition.getCommerceCatalog();
        document.addKeyword("commerceCatalogId", commerceCatalog.getCommerceCatalogId());
        List cpInstances = cpDefinition.getCPInstances();
        if (cpInstances.size() == 1) {
            CPInstance cpInstance = (CPInstance)cpInstances.get(0);
            document.addNumber("basePrice", cpInstance.getPrice());
        } else if (!cpInstances.isEmpty()) {
            CPInstance firstCPInstance = (CPInstance)cpInstances.get(0);
            CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.getInstanceBaseCommercePriceEntry(firstCPInstance.getCPInstanceUuid(), "price-list");
            BigDecimal lowestPrice = commercePriceEntry.getPrice();
            for (CPInstance cpInstance : cpInstances) {
                commercePriceEntry = this._commercePriceEntryLocalService.getInstanceBaseCommercePriceEntry(cpInstance.getCPInstanceUuid(), "price-list");
                BigDecimal price = commercePriceEntry.getPrice();
                if (!CommerceBigDecimalUtil.lt((BigDecimal)price, (BigDecimal)lowestPrice)) continue;
                lowestPrice = price;
            }
            document.addNumber("basePrice", lowestPrice);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + cpDefinition + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "name", "description");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CPDefinition cpDefinition) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), cpDefinition.getCompanyId(), this.getDocument(cpDefinition), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._cpDefinitionLocalService.getCPDefinition(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCPDefinitions(companyId);
    }

    protected String[] getReverseCPDefinitionIds(long cProductId, String type) {
        List cpDefinitionLinks = this._cpDefinitionLinkLocalService.getReverseCPDefinitionLinks(cProductId, type);
        String[] reverseCPDefinitionIdsArray = new String[cpDefinitionLinks.size()];
        ArrayList<String> reverseCPDefinitionIds = new ArrayList<String>();
        for (CPDefinitionLink cpDefinitionLink : cpDefinitionLinks) {
            reverseCPDefinitionIds.add(String.valueOf(cpDefinitionLink.getCPDefinitionId()));
        }
        return reverseCPDefinitionIds.toArray(reverseCPDefinitionIdsArray);
    }

    protected void reindexCPDefinitions(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._cpDefinitionLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(cpDefinition -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(cpDefinition)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce product definition " + cpDefinition.getCPDefinitionId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

