/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.search;

import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={Indexer.class})
public class CPDefinitionOptionRelIndexer
extends BaseIndexer<CPDefinitionOptionRel> {
    public static final String CLASS_NAME = CPDefinitionOptionRel.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(CPDefinitionOptionRelIndexer.class);
    @Reference
    private CPDefinitionOptionRelLocalService _cpDefinitionOptionRelLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CPDefinitionOptionRelIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "groupId", "modified", "name", "scopeGroupId", "uid"});
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long cpDefinitionId = GetterUtil.getLong((Object)searchContext.getAttribute("CPDefinitionId"));
        if (cpDefinitionId > 0L) {
            contextBooleanFilter.addRequiredTerm("CPDefinitionId", cpDefinitionId);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchLocalizedTerm(searchQuery, searchContext, "content", false);
        this.addSearchTerm(searchQuery, searchContext, "definitionOptionValueRelName", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "definitionOptionValueRelName", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "description", false);
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "name", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(CPDefinitionOptionRel cpDefinitionOptionRel) throws Exception {
        this.deleteDocument(cpDefinitionOptionRel.getCompanyId(), cpDefinitionOptionRel.getCPDefinitionOptionRelId());
    }

    protected Document doGetDocument(CPDefinitionOptionRel cpDefinitionOptionRel) throws Exception {
        String[] languageIds;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing definition option rel " + cpDefinitionOptionRel));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)cpDefinitionOptionRel);
        List cpDefinitionOptionValueRels = cpDefinitionOptionRel.getCPDefinitionOptionValueRels();
        String cpDefinitionOptionRelDefaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)cpDefinitionOptionRel.getName());
        for (String languageId : languageIds = LocalizationUtil.getAvailableLanguageIds((String)cpDefinitionOptionRel.getName())) {
            String description = cpDefinitionOptionRel.getDescription(languageId);
            String name = cpDefinitionOptionRel.getName(languageId);
            ArrayList<String> cpDefinitionOptionValueRelNamesList = new ArrayList<String>();
            for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
                cpDefinitionOptionValueRelNamesList.add(cpDefinitionOptionValueRel.getName(languageId));
            }
            String[] cpDefinitionOptionValueRelNames = cpDefinitionOptionValueRelNamesList.toArray(new String[0]);
            if (languageId.equals(cpDefinitionOptionRelDefaultLanguageId)) {
                document.addText("definitionOptionValueRelName", cpDefinitionOptionValueRelNames);
                document.addText("description", description);
                document.addText("name", name);
                document.addText("defaultLanguageId", languageId);
            }
            document.addText(LocalizationUtil.getLocalizedName((String)"name", (String)languageId), name);
            document.addText(LocalizationUtil.getLocalizedName((String)"description", (String)languageId), description);
            document.addText("content", name);
            document.addKeyword("CPDefinitionId", cpDefinitionOptionRel.getCPDefinitionId());
            document.addText(LocalizationUtil.getLocalizedName((String)"definitionOptionValueRelName", (String)languageId), cpDefinitionOptionValueRelNames);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + cpDefinitionOptionRel + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "name", "description");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CPDefinitionOptionRel cpDefinitionOptionRel) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), cpDefinitionOptionRel.getCompanyId(), this.getDocument(cpDefinitionOptionRel), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRel(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCPDefinitionOptionRels(companyId);
    }

    protected void reindexCPDefinitionOptionRels(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._cpDefinitionOptionRelLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(cpDefinitionOptionRel -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(cpDefinitionOptionRel)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    long cpDefinitionOptionRelId = cpDefinitionOptionRel.getCPDefinitionOptionRelId();
                    _log.warn((Object)("Unable to index definition option rel " + cpDefinitionOptionRelId), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

