/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.search;

import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={Indexer.class})
public class CPDefinitionOptionValueRelIndexer
extends BaseIndexer<CPDefinitionOptionValueRel> {
    public static final String CLASS_NAME = CPDefinitionOptionValueRel.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(CPDefinitionOptionValueRelIndexer.class);
    @Reference
    private CPDefinitionOptionValueRelLocalService _cpDefinitionOptionValueRelLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CPDefinitionOptionValueRelIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "groupId", "modified", "name", "scopeGroupId", "uid", "key"});
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long cpDefinitionOptionRelId = GetterUtil.getLong((Object)searchContext.getAttribute("CPDefinitionOptionRelId"));
        if (cpDefinitionOptionRelId > 0L) {
            contextBooleanFilter.addRequiredTerm("CPDefinitionOptionRelId", cpDefinitionOptionRelId);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "key", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "name", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        this.addSearchTerm(searchQuery, searchContext, "sku", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(CPDefinitionOptionValueRel cpDefinitionOptionValueRel) throws Exception {
        this.deleteDocument(cpDefinitionOptionValueRel.getCompanyId(), cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId());
    }

    protected Document doGetDocument(CPDefinitionOptionValueRel cpDefinitionOptionValueRel) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing definition option rel " + cpDefinitionOptionValueRel));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)cpDefinitionOptionValueRel);
        String cpDefinitionOptionValueRelDefaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)cpDefinitionOptionValueRel.getName());
        Locale locale = LocaleUtil.fromLanguageId((String)cpDefinitionOptionValueRelDefaultLanguageId);
        this.addLocalizedField(document, "title", locale, cpDefinitionOptionValueRel.getNameMap());
        CPInstance cpInstance = cpDefinitionOptionValueRel.fetchCPInstance();
        if (cpInstance != null) {
            document.addKeyword("sku", cpInstance.getSku());
        }
        document.addNumber("priority", cpDefinitionOptionValueRel.getPriority());
        document.addKeyword("CPDefinitionOptionRelId", cpDefinitionOptionValueRel.getCPDefinitionOptionRelId());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + cpDefinitionOptionValueRel + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "name", "key");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CPDefinitionOptionValueRel cpDefinitionOptionValueRel) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), cpDefinitionOptionValueRel.getCompanyId(), this.getDocument(cpDefinitionOptionValueRel), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._cpDefinitionOptionValueRelLocalService.getCPDefinitionOptionValueRel(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCPDefinitionOptionValueRels(companyId);
    }

    protected void reindexCPDefinitionOptionValueRels(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._cpDefinitionOptionValueRelLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(cpDefinitionOptionValueRel -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(cpDefinitionOptionValueRel)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    long cpDefinitionOptionValueRelId = cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId();
                    _log.warn((Object)("Unable to index definition option rel " + cpDefinitionOptionValueRelId), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

