/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.search;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.commerce.product.catalog.CPQuery;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.portal.kernel.search.BaseSearcher;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.util.AssetUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

public class CPDefinitionSearcher
extends BaseSearcher {
    private final CPQuery _cpQuery;

    public CPDefinitionSearcher(CPQuery cpQuery) {
        this._cpQuery = cpQuery;
        this.setDefaultSelectedFieldNames(new String[]{"entryClassName", "entryClassPK", "uid", "name", "description", "url", "shortDescription", "defaultImageFileUrl", "depth", "height", "isIgnoreSKUCombinations", "productTypeName", "defaultImageFileUrl"});
        this.setDefaultSelectedLocalizedFieldNames(new String[]{"name"});
    }

    public String[] getSearchClassNames() {
        return new String[]{CPDefinition.class.getName()};
    }

    protected void addImpossibleTerm(BooleanFilter queryBooleanFilter, String field) throws Exception {
        queryBooleanFilter.addTerm(field, "-1", BooleanClauseOccur.MUST);
    }

    protected void addSearchAllCategories(BooleanFilter queryBooleanFilter) throws Exception {
        long[] allCategoryIds = this._cpQuery.getAllCategoryIds();
        if (allCategoryIds.length == 0) {
            return;
        }
        long[] filteredAllCategoryIds = AssetUtil.filterCategoryIds((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (long[])allCategoryIds);
        if (allCategoryIds.length != filteredAllCategoryIds.length) {
            this.addImpossibleTerm(queryBooleanFilter, "assetCategoryIds");
            return;
        }
        BooleanFilter categoryIdsBooleanFilter = new BooleanFilter();
        for (long allCategoryId : filteredAllCategoryIds) {
            AssetCategory assetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)allCategoryId);
            if (assetCategory == null) continue;
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
                categoryIds.addAll(AssetCategoryLocalServiceUtil.getSubcategoryIds((long)allCategoryId));
            }
            if (categoryIds.isEmpty()) {
                categoryIds.add(allCategoryId);
            }
            TermsFilter categoryIdTermsFilter = new TermsFilter("assetCategoryIds");
            categoryIdTermsFilter.addValues(ArrayUtil.toStringArray((Object[])categoryIds.toArray(new Long[0])));
            categoryIdsBooleanFilter.add((Filter)categoryIdTermsFilter, BooleanClauseOccur.MUST);
        }
        queryBooleanFilter.add((Filter)categoryIdsBooleanFilter, BooleanClauseOccur.MUST);
    }

    protected void addSearchAllTags(BooleanFilter queryBooleanFilter) throws Exception {
        long[][] allTagIdsArray = this._cpQuery.getAllTagIdsArray();
        if (allTagIdsArray.length == 0) {
            return;
        }
        BooleanFilter tagIdsArrayBooleanFilter = new BooleanFilter();
        for (long[] allTagIds : allTagIdsArray) {
            if (allTagIds.length == 0) continue;
            TermsFilter tagIdsTermsFilter = new TermsFilter("assetTagIds");
            tagIdsTermsFilter.addValues(ArrayUtil.toStringArray((long[])allTagIds));
            tagIdsArrayBooleanFilter.add((Filter)tagIdsTermsFilter, BooleanClauseOccur.MUST);
        }
        queryBooleanFilter.add((Filter)tagIdsArrayBooleanFilter, BooleanClauseOccur.MUST);
    }

    protected void addSearchAnyCategories(BooleanFilter queryBooleanFilter) throws Exception {
        long[] anyCategoryIds = this._cpQuery.getAnyCategoryIds();
        if (anyCategoryIds.length == 0) {
            return;
        }
        long[] filteredAnyCategoryIds = AssetUtil.filterCategoryIds((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (long[])anyCategoryIds);
        if (filteredAnyCategoryIds.length == 0) {
            this.addImpossibleTerm(queryBooleanFilter, "assetCategoryIds");
            return;
        }
        TermsFilter categoryIdsTermsFilter = new TermsFilter("assetCategoryIds");
        for (long anyCategoryId : filteredAnyCategoryIds) {
            AssetCategory assetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)anyCategoryId);
            if (assetCategory == null) continue;
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
                categoryIds.addAll(AssetCategoryLocalServiceUtil.getSubcategoryIds((long)anyCategoryId));
            }
            if (categoryIds.isEmpty()) {
                categoryIds.add(anyCategoryId);
            }
            categoryIdsTermsFilter.addValues(ArrayUtil.toStringArray((Object[])categoryIds.toArray(new Long[0])));
        }
        queryBooleanFilter.add((Filter)categoryIdsTermsFilter, BooleanClauseOccur.MUST);
    }

    protected void addSearchAnyTags(BooleanFilter queryBooleanFilter) throws Exception {
        long[] anyTagIds = this._cpQuery.getAnyTagIds();
        if (anyTagIds.length == 0) {
            return;
        }
        TermsFilter tagIdsTermsFilter = new TermsFilter("assetTagIds");
        tagIdsTermsFilter.addValues(ArrayUtil.toStringArray((long[])anyTagIds));
        queryBooleanFilter.add((Filter)tagIdsTermsFilter, BooleanClauseOccur.MUST);
    }

    protected void addSearchAssetCategoryIds(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchAllCategories(queryBooleanFilter);
        this.addSearchAnyCategories(queryBooleanFilter);
        this.addSearchNotAnyCategories(queryBooleanFilter);
        this.addSearchNotAllCategories(queryBooleanFilter);
    }

    protected void addSearchAssetTagNames(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchAllTags(queryBooleanFilter);
        this.addSearchAnyTags(queryBooleanFilter);
        this.addSearchNotAllTags(queryBooleanFilter);
        this.addSearchNotAnyTags(queryBooleanFilter);
    }

    protected Map<String, Query> addSearchKeywords(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String keywords = searchContext.getKeywords();
        if (Validator.isNull((String)keywords)) {
            return Collections.emptyMap();
        }
        Map queries = super.addSearchKeywords(searchQuery, searchContext);
        String field = Field.getLocalizedName((Locale)searchContext.getLocale(), (String)"localized_title");
        Query query = searchQuery.addTerm(field, keywords, true);
        queries.put(field, query);
        return queries;
    }

    protected void addSearchLayout(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        String layoutUuid = (String)((Object)searchContext.getAttribute("layoutUuid"));
        if (Validator.isNotNull((String)layoutUuid)) {
            queryBooleanFilter.addRequiredTerm("layoutUuid", layoutUuid);
        }
    }

    protected void addSearchNotAllCategories(BooleanFilter queryBooleanFilter) throws Exception {
        long[] notAllCategoryIds = this._cpQuery.getNotAllCategoryIds();
        if (notAllCategoryIds.length == 0) {
            return;
        }
        BooleanFilter categoryIdsBooleanFilter = new BooleanFilter();
        for (long notAllCategoryId : notAllCategoryIds) {
            AssetCategory assetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)notAllCategoryId);
            if (assetCategory == null) continue;
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
                categoryIds.addAll(AssetCategoryLocalServiceUtil.getSubcategoryIds((long)notAllCategoryId));
            }
            if (categoryIds.isEmpty()) {
                categoryIds.add(notAllCategoryId);
            }
            TermsFilter categoryIdTermsFilter = new TermsFilter("assetCategoryIds");
            categoryIdTermsFilter.addValues(ArrayUtil.toStringArray((Object[])categoryIds.toArray(new Long[0])));
            categoryIdsBooleanFilter.add((Filter)categoryIdTermsFilter, BooleanClauseOccur.MUST);
        }
        queryBooleanFilter.add((Filter)categoryIdsBooleanFilter, BooleanClauseOccur.MUST_NOT);
    }

    protected void addSearchNotAllTags(BooleanFilter queryBooleanFilter) throws Exception {
        long[][] notAllTagIdsArray = this._cpQuery.getNotAllTagIdsArray();
        if (notAllTagIdsArray.length == 0) {
            return;
        }
        BooleanFilter tagIdsArrayBooleanFilter = new BooleanFilter();
        for (long[] notAllTagIds : notAllTagIdsArray) {
            if (notAllTagIds.length == 0) continue;
            TermsFilter tagIdsTermsFilter = new TermsFilter("assetTagIds");
            tagIdsTermsFilter.addValues(ArrayUtil.toStringArray((long[])notAllTagIds));
            tagIdsArrayBooleanFilter.add((Filter)tagIdsTermsFilter, BooleanClauseOccur.MUST);
        }
        queryBooleanFilter.add((Filter)tagIdsArrayBooleanFilter, BooleanClauseOccur.MUST_NOT);
    }

    protected void addSearchNotAnyCategories(BooleanFilter queryBooleanFilter) throws Exception {
        long[] notAnyCategoryIds = this._cpQuery.getNotAnyCategoryIds();
        if (notAnyCategoryIds.length == 0) {
            return;
        }
        TermsFilter categoryIdsTermsFilter = new TermsFilter("assetCategoryIds");
        for (long notAnyCategoryId : notAnyCategoryIds) {
            AssetCategory assetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)notAnyCategoryId);
            if (assetCategory == null) continue;
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
                categoryIds.addAll(AssetCategoryLocalServiceUtil.getSubcategoryIds((long)notAnyCategoryId));
            }
            if (categoryIds.isEmpty()) {
                categoryIds.add(notAnyCategoryId);
            }
            categoryIdsTermsFilter.addValues(ArrayUtil.toStringArray((Object[])categoryIds.toArray(new Long[0])));
        }
        queryBooleanFilter.add((Filter)categoryIdsTermsFilter, BooleanClauseOccur.MUST_NOT);
    }

    protected void addSearchNotAnyTags(BooleanFilter queryBooleanFilter) throws Exception {
        long[] notAnyTagIds = this._cpQuery.getNotAnyTagIds();
        if (notAnyTagIds.length == 0) {
            return;
        }
        TermsFilter tagIgsTermsFilter = new TermsFilter("assetTagIds");
        tagIgsTermsFilter.addValues(ArrayUtil.toStringArray((long[])notAnyTagIds));
        queryBooleanFilter.add((Filter)tagIgsTermsFilter, BooleanClauseOccur.MUST_NOT);
    }
}

