/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.search;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDisplayLayout;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPDisplayLayoutLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={Indexer.class})
public class CPDisplayLayoutIndexer
extends BaseIndexer<CPDisplayLayout> {
    public static final String CLASS_NAME = CPDisplayLayout.class.getName();
    public static final String FIELD_COMMERCE_CATALOG_GROUP_ID = "commerceCatalogGroupId";
    public static final String FIELD_ENTRY_MODEL_CLASS_NAME = "entryModelClassName";
    private static final Log _log = LogFactoryUtil.getLog(CPDisplayLayoutIndexer.class);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPDisplayLayoutLocalService _cpDisplayLayoutLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference
    private Portal _portal;

    public CPDisplayLayoutIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"entryClassName", "entryClassPK", "uid"});
        this.setFilterSearch(false);
        this.setPermissionAware(false);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        Map attributes = searchContext.getAttributes();
        String entryModelClassName = (String)attributes.get(FIELD_ENTRY_MODEL_CLASS_NAME);
        if (Validator.isNotNull((String)entryModelClassName)) {
            contextBooleanFilter.addTerm(FIELD_ENTRY_MODEL_CLASS_NAME, entryModelClassName, BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
    }

    protected void doDelete(CPDisplayLayout cpDisplayLayout) throws Exception {
        this.deleteDocument(cpDisplayLayout.getCompanyId(), cpDisplayLayout.getCPDisplayLayoutId());
    }

    protected Document doGetDocument(CPDisplayLayout cpDisplayLayout) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing commerce product display layout " + cpDisplayLayout));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)cpDisplayLayout);
        String className = cpDisplayLayout.getClassName();
        document.addKeyword(FIELD_ENTRY_MODEL_CLASS_NAME, className);
        if (className.equals(CPDefinition.class.getName())) {
            CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpDisplayLayout.getClassPK());
            CommerceCatalog commerceCatalog = cpDefinition.getCommerceCatalog();
            document.addKeyword(FIELD_COMMERCE_CATALOG_GROUP_ID, cpDefinition.getGroupId());
            Locale locale = LocaleUtil.fromLanguageId((String)commerceCatalog.getCatalogDefaultLanguageId());
            this.addLocalizedField(document, "title", locale, cpDefinition.getNameMap());
            document.addText("name", cpDefinition.getName(commerceCatalog.getCatalogDefaultLanguageId()));
        }
        if (className.equals(AssetCategory.class.getName())) {
            AssetCategory assetCategory = this._assetCategoryLocalService.getAssetCategory(cpDisplayLayout.getClassPK());
            Locale siteDefaultLocale = this._portal.getSiteDefaultLocale(assetCategory.getGroupId());
            this.addLocalizedField(document, "description", siteDefaultLocale, assetCategory.getDescriptionMap());
            document.addText("name", assetCategory.getName());
            this.addLocalizedField(document, "title", siteDefaultLocale, assetCategory.getTitleMap());
        }
        document.addKeyword("groupId", cpDisplayLayout.getGroupId());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + cpDisplayLayout + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "entryClassPK", "entryClassPK");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CPDisplayLayout cpDisplayLayout) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), cpDisplayLayout.getCompanyId(), this.getDocument(cpDisplayLayout), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._cpDisplayLayoutLocalService.getCPDisplayLayout(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCPDisplayLayouts(companyId);
    }

    protected void reindexCPDisplayLayouts(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._cpDisplayLayoutLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(cpDisplayLayout -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(cpDisplayLayout)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce product display layout " + cpDisplayLayout.getCPDisplayLayoutId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

