/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.search;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.util.CPInstanceHelper;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.WildcardQuery;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.generic.WildcardQueryImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={Indexer.class})
public class CPInstanceIndexer
extends BaseIndexer<CPInstance> {
    public static final String CLASS_NAME = CPInstance.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(CPInstanceIndexer.class);
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPInstanceHelper _cpInstanceHelper;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CPInstanceIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "groupId", "modified", "scopeGroupId", "sku", "uid"});
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        String[] fieldNames;
        Map attributes;
        long cpDefinitionId;
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
        if (status != -1) {
            contextBooleanFilter.addRequiredTerm("status", status);
        }
        if ((cpDefinitionId = GetterUtil.getLong((Object)searchContext.getAttribute("CPDefinitionId"))) > 0L) {
            contextBooleanFilter.addRequiredTerm("CPDefinitionId", cpDefinitionId);
        }
        if ((attributes = searchContext.getAttributes()).containsKey("CPDefinitionStatus")) {
            int cpDefinitionStatus = GetterUtil.getInteger(attributes.get("CPDefinitionStatus"));
            if (cpDefinitionStatus == -1) {
                contextBooleanFilter.addRangeTerm("CPDefinitionStatus", 0, 7);
            } else {
                contextBooleanFilter.addRequiredTerm("CPDefinitionStatus", cpDefinitionStatus);
            }
        }
        if (attributes.containsKey("hasChildCPDefinitions")) {
            boolean hasChildCPDefinitions = GetterUtil.getBoolean(attributes.get("hasChildCPDefinitions"));
            contextBooleanFilter.addRequiredTerm("hasChildCPDefinitions", hasChildCPDefinitions);
        }
        if (attributes.containsKey("published")) {
            boolean published = GetterUtil.getBoolean(attributes.get("published"));
            contextBooleanFilter.addRequiredTerm("published", published);
        }
        if (attributes.containsKey("purchasable")) {
            boolean purchasable = GetterUtil.getBoolean(attributes.get("purchasable"));
            contextBooleanFilter.addRequiredTerm("purchasable", purchasable);
        }
        if ((fieldNames = (String[])searchContext.getAttribute("OPTIONS")) == null) {
            return;
        }
        for (String fieldName : fieldNames) {
            String fieldValue = (String)((Object)searchContext.getAttribute(fieldName));
            contextBooleanFilter.addRequiredTerm(fieldName, fieldValue);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String keywords;
        String expandoAttributes;
        this.addSearchLocalizedTerm(searchQuery, searchContext, "content", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "name", false);
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "name", false);
        this.addSearchTerm(searchQuery, searchContext, "sku", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        this.addSearchTerm(searchQuery, searchContext, "externalReferenceCode", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
        if (Validator.isNotNull((String)(keywords = searchContext.getKeywords()))) {
            try {
                keywords = StringUtil.toLowerCase((String)keywords);
                searchQuery.add((Query)this._getTrailingWildcardQuery("sku", keywords), BooleanClauseOccur.SHOULD);
            }
            catch (ParseException parseException) {
                throw new SystemException((Throwable)parseException);
            }
        }
    }

    protected void doDelete(CPInstance cpInstance) throws Exception {
        this.deleteDocument(cpInstance.getCompanyId(), cpInstance.getCPInstanceId());
    }

    protected Document doGetDocument(CPInstance cpInstance) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing definition " + cpInstance));
        }
        CPDefinition cpDefinition = cpInstance.getCPDefinition();
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)cpInstance);
        List languageIds = this._cpDefinitionLocalService.getCPDefinitionLocalizationLanguageIds(cpInstance.getCPDefinitionId());
        String cpDefinitionDefaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)cpDefinition.getName());
        for (String languageId : languageIds) {
            String name = cpDefinition.getName(languageId);
            if (languageId.equals(cpDefinitionDefaultLanguageId)) {
                document.addText("name", name);
                document.addText("defaultLanguageId", languageId);
            }
            document.addText(LocalizationUtil.getLocalizedName((String)"name", (String)languageId), name);
        }
        document.addText("name", cpDefinition.getName());
        document.addText("externalReferenceCode", cpInstance.getExternalReferenceCode());
        document.addText("content", cpInstance.getSku());
        document.addDateSortable("displayDate", cpInstance.getDisplayDate());
        document.addTextSortable("sku", cpInstance.getSku());
        document.addKeyword("CPDefinitionId", cpInstance.getCPDefinitionId());
        document.addKeyword("CPDefinitionStatus", cpDefinition.getStatus());
        document.addKeyword("published", cpInstance.isPublished());
        document.addKeyword("purchasable", cpInstance.isPurchasable());
        document.addKeyword("externalReferenceCode", cpInstance.getExternalReferenceCode());
        document.addKeyword("hasChildCPDefinitions", this._cpDefinitionLocalService.hasChildCPDefinitions(cpDefinition.getCPDefinitionId()));
        document.addKeyword("unspsc", cpInstance.getUnspsc());
        CommerceCatalog commerceCatalog = cpDefinition.getCommerceCatalog();
        document.addKeyword("commerceCatalogId", commerceCatalog.getCommerceCatalogId());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + cpInstance + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "sku", "content");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CPInstance cpInstance) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), cpInstance.getCompanyId(), this.getDocument(cpInstance), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._cpInstanceLocalService.getCPInstance(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCPInstances(companyId);
    }

    protected void reindexCPInstances(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._cpInstanceLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(cpInstance -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(cpInstance)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce product definition " + cpInstance.getCPInstanceId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    private WildcardQuery _getTrailingWildcardQuery(String field, String value) {
        return new WildcardQueryImpl(field, value + "*");
    }
}

