/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.search;

import com.liferay.commerce.product.model.CPOptionCategory;
import com.liferay.commerce.product.service.CPOptionCategoryLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={Indexer.class})
public class CPOptionCategoryIndexer
extends BaseIndexer<CPOptionCategory> {
    public static final String CLASS_NAME = CPOptionCategory.class.getName();
    public static final String FIELD_KEY = "key";
    private static final Log _log = LogFactoryUtil.getLog(CPOptionCategoryIndexer.class);
    @Reference
    private CPOptionCategoryLocalService _cpOptionCategoryLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CPOptionCategoryIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "modified", "name", "uid", FIELD_KEY});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchLocalizedTerm(searchQuery, searchContext, "description", false);
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, FIELD_KEY, false);
        this.addSearchTerm(searchQuery, searchContext, "title", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "title", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
    }

    protected void doDelete(CPOptionCategory cpOptionCategory) throws Exception {
        this.deleteDocument(cpOptionCategory.getCompanyId(), cpOptionCategory.getCPOptionCategoryId());
    }

    protected Document doGetDocument(CPOptionCategory cpOptionCategory) throws Exception {
        String[] languageIds;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing option " + cpOptionCategory));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)cpOptionCategory);
        String cpOptionCategoryDefaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)cpOptionCategory.getTitle());
        for (String languageId : languageIds = LocalizationUtil.getAvailableLanguageIds((String)cpOptionCategory.getTitle())) {
            String description = cpOptionCategory.getDescription(languageId);
            String title = cpOptionCategory.getTitle(languageId);
            if (languageId.equals(cpOptionCategoryDefaultLanguageId)) {
                document.addText("description", description);
                document.addText("title", title);
                document.addText("defaultLanguageId", languageId);
            }
            document.addText(LocalizationUtil.getLocalizedName((String)"title", (String)languageId), title);
            document.addText(LocalizationUtil.getLocalizedName((String)"description", (String)languageId), description);
            document.addText(FIELD_KEY, cpOptionCategory.getKey());
            document.addText("content", title);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + cpOptionCategory + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "title", "description");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CPOptionCategory cpOptionCategory) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), cpOptionCategory.getCompanyId(), this.getDocument(cpOptionCategory), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._cpOptionCategoryLocalService.getCPOptionCategory(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCPOptionCategorys(companyId);
    }

    protected void reindexCPOptionCategorys(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._cpOptionCategoryLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(cpOptionCategory -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(cpOptionCategory)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce product option " + cpOptionCategory.getCPOptionCategoryId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

