/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.search;

import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.service.CPOptionLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={Indexer.class})
public class CPOptionIndexer
extends BaseIndexer<CPOption> {
    public static final String CLASS_NAME = CPOption.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(CPOptionIndexer.class);
    @Reference
    private CPOptionLocalService _cpOptionLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CPOptionIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "modified", "name", "uid", "key"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchLocalizedTerm(searchQuery, searchContext, "description", false);
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "key", false);
        this.addSearchTerm(searchQuery, searchContext, "optionValueName", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "optionValueName", false);
        this.addSearchTerm(searchQuery, searchContext, "name", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "name", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(CPOption cpOption) throws Exception {
        this.deleteDocument(cpOption.getCompanyId(), cpOption.getCPOptionId());
    }

    protected Document doGetDocument(CPOption cpOption) throws Exception {
        String[] languageIds;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing option " + cpOption));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)cpOption);
        String cpOptionDefaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)cpOption.getName());
        for (String languageId : languageIds = LocalizationUtil.getAvailableLanguageIds((String)cpOption.getName())) {
            String description = cpOption.getDescription(languageId);
            String name = cpOption.getName(languageId);
            if (languageId.equals(cpOptionDefaultLanguageId)) {
                document.addText("description", description);
                document.addText("name", name);
                document.addText("defaultLanguageId", languageId);
            }
            document.addText(LocalizationUtil.getLocalizedName((String)"name", (String)languageId), name);
            document.addText(LocalizationUtil.getLocalizedName((String)"description", (String)languageId), description);
            document.addText("key", cpOption.getKey());
            document.addText("content", name);
            document.addText("DDMFormFieldTypeName", cpOption.getDDMFormFieldTypeName());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + cpOption + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "name", "description");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CPOption cpOption) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), cpOption.getCompanyId(), this.getDocument(cpOption), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._cpOptionLocalService.getCPOption(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCPOptions(companyId);
    }

    protected void reindexCPOptions(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._cpOptionLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(cpOption -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(cpOption)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce product option " + cpOption.getCPOptionId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

