/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.search;

import com.liferay.commerce.product.model.CPOptionValue;
import com.liferay.commerce.product.service.CPOptionValueLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={Indexer.class})
public class CPOptionValueIndexer
extends BaseIndexer<CPOptionValue> {
    public static final String CLASS_NAME = CPOptionValue.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(CPOptionValueIndexer.class);
    @Reference
    private CPOptionValueLocalService _cpOptionValueLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CPOptionValueIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "groupId", "modified", "name", "scopeGroupId", "uid", "CPOptionId", "key"});
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long cpOptionId = GetterUtil.getLong((Object)searchContext.getAttribute("CPOptionId"));
        if (cpOptionId > 0L) {
            contextBooleanFilter.addRequiredTerm("CPOptionId", cpOptionId);
        }
    }

    protected void doDelete(CPOptionValue cpOptionValue) throws Exception {
        this.deleteDocument(cpOptionValue.getCompanyId(), cpOptionValue.getCPOptionValueId());
    }

    protected Document doGetDocument(CPOptionValue cpOptionValue) throws Exception {
        String[] languageIds;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing option value " + cpOptionValue));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)cpOptionValue);
        String cpOptionValueDefaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)cpOptionValue.getName());
        for (String languageId : languageIds = LocalizationUtil.getAvailableLanguageIds((String)cpOptionValue.getName())) {
            String name = cpOptionValue.getName(languageId);
            if (languageId.equals(cpOptionValueDefaultLanguageId)) {
                document.addText("name", name);
                document.addText("defaultLanguageId", languageId);
            }
            document.addText(LocalizationUtil.getLocalizedName((String)"name", (String)languageId), name);
            document.addNumber("priority", cpOptionValue.getPriority());
            document.addText("key", cpOptionValue.getKey());
            document.addText("content", name);
            document.addNumber("CPOptionId", cpOptionValue.getCPOptionId());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + cpOptionValue + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "name", "description");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CPOptionValue cpOptionValue) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), cpOptionValue.getCompanyId(), this.getDocument(cpOptionValue), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._cpOptionValueLocalService.getCPOptionValue(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCPOptionValues(companyId);
    }

    protected void reindexCPOptionValues(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._cpOptionValueLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(cpOptionValue -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(cpOptionValue)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce product option " + cpOptionValue.getCPOptionValueId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

